/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal;

import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.TemplateNature;
import com.ibm.etools.webpage.template.internal.BackwardCompatibilityUtil;
import com.ibm.etools.webpage.template.util.TemplateFacetUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class TemplateFeatureMigrationOperation
extends AbstractMigration {
    IMigrationStatus okStatus = new MigrationStatus(Status.OK_STATUS);
    public static final String FACETS_METADATA_FILE = ".settings/org.eclipse.wst.common.project.facet.core.xml";

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        if (project == null || !project.isAccessible()) {
            return this.okStatus;
        }
        if (TemplateFacetUtil.hasTemplateFacet(project)) {
            return this.okStatus;
        }
        BackwardCompatibilityUtil bcu = new BackwardCompatibilityUtil();
        boolean installFacet = true;
        if (installFacet) {
            try {
                this.installProjectFacet(project, "web.template", monitor);
            }
            catch (CoreException e) {
                Logger.log(e);
            }
        } else {
            try {
                TemplateNature.removeNature(project, monitor);
            }
            catch (CoreException e) {
                Logger.log(e);
            }
            bcu.notifyFacetUninstalled(project);
        }
        return this.okStatus;
    }

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        IFile facetsMetaDataFile = project.getFile(FACETS_METADATA_FILE);
        ArrayList<IFile> filesList = new ArrayList<IFile>();
        filesList.add(facetsMetaDataFile);
        return filesList;
    }

    private void installProjectFacet(IProject project, String id, IProgressMonitor monitor) throws CoreException {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)id);
        IProjectFacetVersion version = facet.getLatestVersion();
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        facetedProject.installProjectFacet(version, null, monitor);
    }
}

