/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.commands;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.JSPRootTaglibDirectiveCommand;
import com.ibm.etools.webedit.common.commands.utils.JSPRootAttributeModifier;
import com.ibm.etools.webedit.common.commands.utils.RemoveTag;
import com.ibm.etools.webedit.common.utils.NodeDataAccessor;
import java.util.ArrayList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TplJSPRootAttributeModifier
implements JSPRootAttributeModifier {
    private String prefix;
    private String uri;
    private Element jsproot;

    public static JSPRootAttributeModifier create(HTMLCommand command) {
        JSPRootTaglibDirectiveCommand c;
        Element insertElement;
        if (command instanceof JSPRootTaglibDirectiveCommand && (insertElement = TplJSPRootAttributeModifier.getTplInsertElement((c = (JSPRootTaglibDirectiveCommand)command).getJspRoot())) instanceof IDOMElement) {
            return new TplJSPRootAttributeModifier();
        }
        return null;
    }

    public void setAttribute(Element element, String name, String value) {
        this.jsproot = element;
        this.prefix = name;
        this.uri = value;
        if (!this.execute()) {
            NodeDataAccessor.setAttribute((Element)element, (String)name, (String)value);
        }
    }

    public void removeAttribute(Element element, String name) {
        this.jsproot = element;
        this.prefix = name;
        this.uri = null;
        this.execute();
    }

    private boolean execute() {
        Element insertElement = TplJSPRootAttributeModifier.getTplInsertElement(this.jsproot);
        if (!(insertElement instanceof IDOMElement)) {
            return false;
        }
        String attrName = this.prefix;
        Element[] operators = TplJSPRootAttributeModifier.findOperatorFor(insertElement, attrName);
        boolean modifyable = operators.length > 0 || !this.jsproot.hasAttribute(attrName);
        Element operator = this.uri != null && operators.length > 0 ? operators[0] : null;
        int i = 0;
        while (i < operators.length) {
            if (operator != operators[i]) {
                new RemoveTag(null, true).removeNode((Node)operators[i], true);
            }
            ++i;
        }
        if (this.uri != null && modifyable) {
            if (operator == null) {
                operator = ((IDOMDocument)this.jsproot.getOwnerDocument()).createCommentElement("tpl:operator", ((IDOMElement)insertElement).isJSPTag());
                operator.setAttribute("type", "jsproot");
                operator.setAttribute("name", attrName);
                insertElement.getParentNode().insertBefore(operator, insertElement);
            }
            operator.setAttribute("value", this.uri);
        }
        boolean dataEditable = ((IDOMElement)this.jsproot).isDataEditable();
        try {
            if (!dataEditable && modifyable) {
                ((IDOMElement)this.jsproot).setDataEditable(true);
            }
            if (this.uri == null) {
                this.jsproot.removeAttribute(attrName);
            } else if (!this.uri.equals(NodeDataAccessor.getAttribute((Element)this.jsproot, (String)attrName))) {
                NodeDataAccessor.setAttribute((Element)this.jsproot, (String)attrName, (String)this.uri);
            }
        }
        finally {
            if (!dataEditable) {
                ((IDOMElement)this.jsproot).setDataEditable(false);
            }
        }
        return true;
    }

    private static Element getTplInsertElement(Element root) {
        String insertTagName = "tpl:insert";
        Node e = root;
        while (e != null) {
            if (insertTagName.equals(e.getNodeName())) {
                return e;
            }
            e = e.getParentNode();
        }
        return null;
    }

    private static Element[] findOperatorFor(Element insertElement, String name) {
        String opTagName = "tpl:operator";
        ArrayList<Element> result = new ArrayList<Element>(1);
        Node n = insertElement.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 1) {
                if (!opTagName.equals(n.getNodeName())) break;
                Element e = (Element)n;
                if ("jsproot".equals(e.getAttribute("type")) && name.equals(e.getAttribute("name"))) {
                    result.add(0, e);
                }
            }
            n = n.getPreviousSibling();
        }
        return result.toArray(new Element[result.size()]);
    }
}

