/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.commands;

import com.ibm.etools.webedit.common.commands.RangeCommand;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.commands.utils.RemoveTag;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.internal.commands.utils.IInvisibleNodeDeletionCustomizor;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.PageTemplateCommentConstants;
import com.ibm.etools.webpage.template.commands.PageTemplateCommandUtil;
import com.ibm.etools.webpage.template.internal.model.LinkUtil;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplGet;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.TplTemplate;
import com.ibm.etools.webpage.template.model.util.TemplateEncodingUtil;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import com.ibm.etools.webpage.template.readonly.ReadOnlyNodeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class ReplaceTemplateCommand
extends RangeCommand
implements PageTemplateCommentConstants,
IInvisibleNodeDeletionCustomizor {
    private FileURL newTemplateFileURL;
    private IStructuredDocument tplDocument;
    private Map contentsMap;
    private final boolean keepUseFaces = true;
    private static final String NAME_REMOVING = "****** Special name to be removed by ReplaceTemplateCommand ****** ";

    public ReplaceTemplateCommand() {
        super("");
    }

    protected void doExecute() {
        List putNodes;
        String prefix;
        NodeList jspPageDirNodeList;
        Node jspNode;
        IStructuredModel sedModel;
        IFile file;
        IDOMModel model;
        HTMLCommandTarget target = this.getCommandTarget();
        IDOMModel iDOMModel = model = target != null ? target.getActiveModel() : null;
        if (model == null) {
            return;
        }
        IDOMDocument doc = model.getDocument();
        NodeList jspNodeList = doc.getElementsByTagName("jsp:directive.page");
        Node pageDirective = jspNodeList != null && jspNodeList.getLength() > 0 ? jspNodeList.item(0) : null;
        Node useFacesNode = PageTemplateCommandUtil.getUseFacesNode(model);
        NodeList tldNodeList = null;
        tldNodeList = doc.getElementsByTagName("jsp:directive.taglib");
        TemplateModelSession session = new TemplateModelSession();
        TemplateModel tplOrgModel = session.getTemplateModel((IStructuredModel)model);
        TplNode node = TemplateModelUtil.findTemplateNodeOf(tplOrgModel, false);
        if (node == null) {
            return;
        }
        TplNodeList orgPutList = null;
        if (node.getNodeType() == 2) {
            String name;
            orgPutList = ((TplTemplate)node).getPutList();
            if (this.contentsMap != null) {
                int i = 0;
                while (i < orgPutList.getLength()) {
                    TplPut putNode = (TplPut)orgPutList.item(i);
                    Object newId = this.contentsMap.get(putNode.getName());
                    if (newId != null) {
                        if (!newId.equals(putNode.getName())) {
                            putNode.setName(newId.toString());
                        }
                    } else {
                        putNode.setName(NAME_REMOVING + Integer.toString(i));
                    }
                    ++i;
                }
            }
            HashMap<String, TplPut> map = new HashMap<String, TplPut>();
            ArrayList<Node> dupList = new ArrayList<Node>();
            int i = 0;
            while (i < orgPutList.getLength()) {
                TplPut putNode = (TplPut)orgPutList.item(i);
                name = putNode.getName();
                TplPut dupNode = (TplPut)map.get(name);
                if (dupNode != null) {
                    dupList.add(putNode.getRefNode().getDomNode());
                } else {
                    map.put(name, putNode);
                }
                ++i;
            }
            i = 0;
            while (i < dupList.size()) {
                Element dupNode = (Element)dupList.get(i);
                name = dupNode.getAttribute("name");
                Element orgNode = (Element)((TplPut)map.get(name)).getRefNode().getDomNode();
                DocumentFragment frag = doc.createDocumentFragment();
                while (dupNode.getFirstChild() != null) {
                    frag.appendChild(dupNode.getFirstChild());
                }
                orgNode.appendChild(frag);
                ++i;
            }
            if (dupList.size() > 0) {
                session.clear();
                tplOrgModel = session.getTemplateModel((IStructuredModel)model);
                node = TemplateModelUtil.findTemplateNodeOf(tplOrgModel, false);
                orgPutList = ((TplTemplate)node).getPutList();
            }
        }
        if (node.getNodeType() == 2) {
            TemplateModel tplNewModel = null;
            file = this.newTemplateFileURL.getIFile();
            String sseId = ModelManagerUtil.calculateSSEModelId((IFile)file);
            sedModel = file != null ? this.getModelManager().getExistingModelForRead((Object)sseId) : null;
            try {
                tplNewModel = sedModel != null ? session.getTemplateModel(sedModel) : (this.tplDocument != null ? session.getTemplateModel(this.tplDocument, this.newTemplateFileURL.getPath().toString()) : session.getTemplateModel(this.newTemplateFileURL.getPath()));
            }
            finally {
                if (sedModel != null) {
                    sedModel.releaseFromRead();
                }
            }
            ArrayList<Node> unmapList = new ArrayList<Node>();
            int i = 0;
            while (i < orgPutList.getLength()) {
                TplPut putNode = (TplPut)orgPutList.item(i);
                String name = putNode.getName();
                TplGet getNode = TemplateModelUtil.findGetNodeOf(tplNewModel, name);
                if (getNode == null) {
                    unmapList.add(putNode.getRefNode().getDomNode());
                }
                ++i;
            }
            i = 0;
            while (i < unmapList.size()) {
                Node toBeRemoved = (Node)unmapList.get(i);
                toBeRemoved.getParentNode().removeChild(toBeRemoved);
                ++i;
            }
            if (unmapList.size() > 0) {
                session.clear();
                tplOrgModel = session.getTemplateModel((IStructuredModel)model);
                node = TemplateModelUtil.findTemplateNodeOf(tplOrgModel, false);
            }
        }
        String pageURL = this.newTemplateFileURL.getURL();
        if (model != null) {
            String pageAttr;
            String location = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
            IFile file2 = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(location));
            if (file2 != null && (pageAttr = LinkUtil.getResolvedNonPortalAwareURI(WebComponent.getComponent((IResource)file2), this.newTemplateFileURL)) != null) {
                pageURL = pageAttr;
            }
        }
        if (node != null) {
            ((Element)node.getRefNode().getDomNode()).setAttribute("page", pageURL);
        }
        session.clear();
        tplOrgModel = session.getTemplateModel((IStructuredModel)model);
        file = this.newTemplateFileURL.getIFile();
        String sseId = ModelManagerUtil.calculateSSEModelId((IFile)file);
        sedModel = file != null ? this.getModelManager().getExistingModelForRead((Object)sseId) : null;
        try {
            if (sedModel != null) {
                session.getTemplateModel(sedModel);
            } else if (this.tplDocument != null) {
                session.getTemplateModel(this.tplDocument, this.newTemplateFileURL.getPath().toString());
            }
            tplOrgModel.rebuildContent(null);
        }
        finally {
            if (sedModel != null) {
                sedModel.releaseFromRead();
            }
        }
        RemoveTag rmTag = new RemoveTag(null, true);
        if (pageDirective != null) {
            jspNodeList = doc.getElementsByTagName("jsp:directive.page");
            if (jspNodeList == null || jspNodeList.getLength() <= 0) {
                session.clear();
                tplOrgModel = session.getTemplateModel((IStructuredModel)model);
                node = TemplateModelUtil.findTemplateNodeOf(tplOrgModel, false);
                if (node != null) {
                    Node domNode = node.getRefNode().getDomNode();
                    domNode.getParentNode().insertBefore(pageDirective, domNode);
                    domNode.getParentNode().insertBefore(doc.createTextNode(model.getStructuredDocument().getLineDelimiter()), domNode);
                }
            } else if (jspNodeList.getLength() > 1) {
                Node tplPageDNode = null;
                int i = 0;
                while (i < jspNodeList.getLength()) {
                    Node jspNode2 = jspNodeList.item(i);
                    if (!PageTemplateCommandUtil.isPageSpecificNode(jspNode2) && PageTemplateCommandUtil.isEncodingPageDirective(jspNode2)) {
                        tplPageDNode = jspNode2;
                        break;
                    }
                    ++i;
                }
                int removedDirective = 0;
                int i2 = 0;
                while (i2 < jspNodeList.getLength() && 1 < jspNodeList.getLength() - removedDirective) {
                    jspNode = jspNodeList.item(i2);
                    if (PageTemplateCommandUtil.isPageSpecificNode(jspNode)) {
                        if (PageTemplateCommandUtil.isSimilarElement(tplPageDNode, jspNode, false)) {
                            rmTag.removeNode(jspNode, true);
                        } else if (PageTemplateCommandUtil.isEncodingPageDirective(jspNode)) {
                            CommentImpl cm = (CommentImpl)doc.createComment(((IDOMElement)jspNode).getSource());
                            cm.setJSPTag(true);
                            jspNode.getParentNode().replaceChild((Node)cm, jspNode);
                        }
                        ++removedDirective;
                    }
                    ++i2;
                }
            }
        }
        if (pageDirective != null && (jspPageDirNodeList = doc.getElementsByTagName("jsp:directive.page")) != null && jspPageDirNodeList.getLength() == 1) {
            ArrayList<Node> tplMeta = new ArrayList<Node>();
            NodeList metaNodeList = doc.getElementsByTagName("META");
            if (metaNodeList != null && metaNodeList.getLength() > 1) {
                int i = 0;
                while (i < metaNodeList.getLength()) {
                    Node metaNode = metaNodeList.item(i);
                    if (!PageTemplateCommandUtil.isPageSpecificNode(metaNode)) {
                        tplMeta.add(metaNode);
                    }
                    ++i;
                }
                Element tplEncEle = PageTemplateCommandUtil.findEncodingMetaTag(tplMeta);
                Node jspPageDirNode = jspPageDirNodeList.item(0);
                String tplEncoding = TemplateEncodingUtil.getIANAEncoding(sedModel);
                if (PageTemplateCommandUtil.isPageSpecificNode(jspPageDirNode) && tplEncoding != null) {
                    ((Element)jspPageDirNode).setAttribute("contentType", tplEncEle.getAttribute("content"));
                    ((Element)jspPageDirNode).setAttribute("pageEncoding", tplEncoding);
                }
            }
        }
        ArrayList<Node> tplTagLib = new ArrayList<Node>();
        ArrayList<Node> pageTagLib = new ArrayList<Node>();
        jspNodeList = doc.getElementsByTagName("jsp:directive.taglib");
        if (jspNodeList != null && jspNodeList.getLength() > 1) {
            int i = 0;
            while (i < jspNodeList.getLength()) {
                jspNode = jspNodeList.item(i);
                if (PageTemplateCommandUtil.isPageSpecificNode(jspNode)) {
                    pageTagLib.add(jspNode);
                } else {
                    tplTagLib.add(jspNode);
                }
                ++i;
            }
            int j = 0;
            while (j < pageTagLib.size()) {
                IDOMElement jspEle = (IDOMElement)pageTagLib.get(j);
                Element tplEle = PageTemplateCommandUtil.findTaglibDirectiveWithSpecifiedPrefix(tplTagLib, jspEle.getAttribute("prefix"));
                if (tplEle != null) {
                    if (PageTemplateCommandUtil.isSimilarElement((Node)jspEle, tplEle, false)) {
                        rmTag.removeNode((Node)jspEle, true);
                    } else {
                        CommentImpl cm = (CommentImpl)doc.createComment(jspEle.getSource());
                        cm.setJSPTag(true);
                        jspEle.getParentNode().replaceChild((Node)cm, (Node)jspEle);
                    }
                }
                ++j;
            }
        }
        if (tldNodeList != null) {
            jspNodeList = doc.getElementsByTagName("jsp:directive.taglib");
            int i = tldNodeList.getLength() - 1;
            while (i >= 0) {
                Node tldNode = tldNodeList.item(i);
                Element activeNode = PageTemplateCommandUtil.findTaglibDirectiveWithSpecifiedPrefix(jspNodeList, ((Element)tldNode).getAttribute("prefix"));
                if (activeNode == null) {
                    doc.insertBefore(doc.createTextNode(model.getStructuredDocument().getLineDelimiter()), doc.getFirstChild());
                    doc.insertBefore(tldNode, doc.getFirstChild());
                }
                --i;
            }
        }
        if (useFacesNode != null && (prefix = PageTemplateCommandUtil.getJSFPrefix(model)) != null && prefix.length() > 0) {
            NodeList useFacesList = doc.getElementsByTagName(String.valueOf(prefix) + ":view");
            if (useFacesList == null || useFacesList.getLength() <= 0) {
                Element newUseFacesNode = doc.createElement(String.valueOf(prefix) + ":view");
                jspNodeList = doc.getElementsByTagName("jsp:directive.taglib");
                Element tldNode = PageTemplateCommandUtil.findTaglibDirectiveWithSpecifiedPrefix(jspNodeList, prefix);
                session.clear();
                TemplateModel tplModel = session.getTemplateModel((IStructuredModel)model);
                if (tldNode != null && !PageTemplateCommandUtil.isPageSpecificNode(tldNode)) {
                    List putNodes2 = TemplateModelUtil.collectPutNode(tplModel);
                    Node targetNode = putNodes2 != null && putNodes2.size() > 0 ? ((TplNode)putNodes2.get(putNodes2.size() - 1)).getRefNode().getDomNode() : null;
                    while (targetNode.getFirstChild() != null) {
                        newUseFacesNode.appendChild(targetNode.getFirstChild());
                    }
                    targetNode.appendChild(doc.createTextNode(model.getStructuredDocument().getLineDelimiter()));
                    targetNode.appendChild(newUseFacesNode);
                    targetNode.appendChild(doc.createTextNode(model.getStructuredDocument().getLineDelimiter()));
                } else {
                    TplNode templateNode = TemplateModelUtil.findTemplateNodeOf(tplModel, false);
                    Node templateEle = templateNode.getRefNode().getDomNode();
                    doc.insertBefore(newUseFacesNode, templateEle);
                    newUseFacesNode.appendChild(doc.createTextNode(model.getStructuredDocument().getLineDelimiter()));
                    newUseFacesNode.appendChild(templateEle);
                    newUseFacesNode.appendChild(doc.createTextNode(model.getStructuredDocument().getLineDelimiter()));
                }
                if (jspNodeList != null) {
                    int i = 0;
                    while (i < jspNodeList.getLength()) {
                        Node jspNode3 = jspNodeList.item(i);
                        if (PageTemplateCommandUtil.isPageSpecificNode(jspNode3) && "http://java.sun.com/jsf/core".equals(((Element)jspNode3).getAttribute("uri")) && PageTemplateCommandUtil.isContainer(newUseFacesNode, jspNode3)) {
                            rmTag.removeNode(jspNode3, true);
                            newUseFacesNode.getParentNode().insertBefore(jspNode3, newUseFacesNode);
                            newUseFacesNode.getParentNode().insertBefore(doc.createTextNode(model.getStructuredDocument().getLineDelimiter()), newUseFacesNode);
                        }
                        ++i;
                    }
                }
            } else if (useFacesList.getLength() > 1) {
                RemoveTag rmTagOnly = new RemoveTag(null);
                int numUseFaces = useFacesList.getLength() - 1;
                int i = 0;
                while (numUseFaces > 0) {
                    if (useFacesList.getLength() > i) {
                        Node newUseFacesNode;
                        if (!PageTemplateCommandUtil.isPageSpecificNode(newUseFacesNode = useFacesList.item(i++))) continue;
                        rmTagOnly.removeNode(newUseFacesNode, true);
                        --numUseFaces;
                        continue;
                    }
                    break;
                }
            }
        }
        session.clear();
        TemplateModel tplModel = session.getTemplateModel((IStructuredModel)model);
        if (tplModel != null && (putNodes = TemplateModelUtil.collectPutNode(tplModel)) != null) {
            EditModelQuery query = EditQueryUtil.getEditQuery((Node)model.getDocument());
            int i = 0;
            while (i < putNodes.size()) {
                Node domNode;
                TplPut putNode = (TplPut)putNodes.get(i);
                if (putNode != null && (domNode = putNode.getRefNode().getDomNode()) != null) {
                    Node curNode = domNode;
                    while (curNode != null) {
                        if (query != null && query.isRenderRoot(curNode)) break;
                        curNode = curNode.getParentNode();
                    }
                    if (curNode != null) {
                        Range range = ((DocumentRange)model.getDocument()).createRange();
                        range.setStart(domNode, 0);
                        range.collapse(true);
                        this.setRange(range);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    protected boolean canDoExecute() {
        IDOMModel model;
        HTMLCommandTarget target = this.getCommandTarget();
        IDOMModel iDOMModel = model = target != null ? target.getActiveModel() : null;
        if (model == null || !PageTemplateCommandUtil.isValidModel(model)) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)model.getDocument());
        if (query.isFragment((Document)model.getDocument()) && !query.acceptEditingAsComplete()) {
            return false;
        }
        TemplateModelSession session = new TemplateModelSession();
        TemplateModel newModel = null;
        if (this.newTemplateFileURL != null) {
            newModel = session.getTemplateModel(this.newTemplateFileURL.getPath());
        }
        if (newModel != null && !newModel.isTemplate()) {
            return false;
        }
        TemplateModel tplModel = session.getTemplateModel((IStructuredModel)model);
        return TemplateModelUtil.findTemplateNodeOf(tplModel) != null;
    }

    public Map getContentsMap() {
        return this.contentsMap;
    }

    public void setContentsMap(Map contentsMap) {
        this.contentsMap = contentsMap;
    }

    public FileURL getNewTemplateFileURL() {
        return this.newTemplateFileURL;
    }

    public void setNewTemplateFileURL(FileURL fileURL) {
        this.newTemplateFileURL = fileURL;
    }

    public void setNewTemplateFile(FileURL fileURL, IStructuredDocument document) {
        this.newTemplateFileURL = fileURL;
        this.tplDocument = document;
    }

    protected void afterEdit() {
        ReadOnlyNodeAdapter adapter;
        super.afterEdit();
        IDOMDocument doc = this.getCommandTarget().getActiveModel().getDocument();
        if (doc != null && (adapter = (ReadOnlyNodeAdapter)doc.getAdapterFor((Object)ReadOnlyNodeAdapter.ADAPTER_KEY)) != null) {
            adapter.setReadOnly(doc);
        }
    }

    protected void beforeEdit() {
        ReadOnlyNodeAdapter adapter;
        IDOMDocument doc = this.getCommandTarget().getActiveModel().getDocument();
        if (doc != null && (adapter = (ReadOnlyNodeAdapter)doc.getAdapterFor((Object)ReadOnlyNodeAdapter.ADAPTER_KEY)) != null) {
            adapter.removeReadOnly(doc);
        }
        super.beforeEdit();
    }

    protected boolean bufferModelEvent() {
        return true;
    }

    public int getInvisibleNodeDeletionVerbosity() {
        return 1;
    }
}

