/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.commands;

import com.ibm.etools.webedit.common.commands.RangeCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.PageTemplateCommentConstants;
import com.ibm.etools.webpage.template.internal.model.LinkUtil;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import com.ibm.etools.webpage.template.model.TplFragment;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import com.ibm.etools.webpage.template.readonly.ReadOnlyNodeAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class ReplaceFragmentCommand
extends RangeCommand
implements PageTemplateCommentConstants {
    private String page;
    private IFile file;

    public ReplaceFragmentCommand(String page) {
        super("");
        this.page = page;
    }

    public ReplaceFragmentCommand(IFile file) {
        super("");
        this.file = file;
    }

    protected void doExecute() {
        HTMLCommandTarget target = this.getCommandTarget();
        if (target == null) {
            return;
        }
        Node candidate = null;
        NodeList list = target.getSelectionMediator().getNodeList();
        Node focusedNode = target.getSelectionMediator().getFocusedNode();
        Range range = target.getSelectionMediator().getRange();
        if (list != null) {
            if (list.getLength() == 1) {
                candidate = list.item(0);
            }
        } else if (focusedNode != null) {
            candidate = focusedNode;
        } else if (range != null && range.getStartContainer() == range.getEndContainer()) {
            candidate = range.getStartContainer();
        }
        if (!this.isValidNode(candidate)) {
            return;
        }
        Node node = candidate;
        if (this.file != null) {
            FileURL fileURL = new FileURL(this.file.getLocation());
            IFile baseFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)target.getActiveModel())));
            if (baseFile.getProject().equals((Object)this.file.getProject())) {
                ((Element)node).setAttribute("page", LinkUtil.getResolvedNonPortalAwareURI(WebComponent.getComponent((IResource)baseFile), fileURL));
            } else {
                ((Element)node).setAttribute("page", fileURL.getURL());
            }
        } else {
            ((Element)node).setAttribute("page", this.page != null ? this.page : "");
        }
        TemplateModelSession session = new TemplateModelSession();
        TemplateModel tplModel = session.getTemplateModel((IStructuredModel)target.getActiveModel());
        TplNode tplNode = TemplateModelUtil.findTplNodeOf(tplModel, node);
        if (tplNode != null && tplNode.getNodeType() == 16) {
            IFile referedFile = ((TplFragment)tplNode).getReferedFile();
            String sseId = ModelManagerUtil.calculateSSEModelId((IFile)referedFile);
            IStructuredModel sedModel = referedFile != null ? this.getModelManager().getExistingModelForRead((Object)sseId) : null;
            try {
                if (sedModel != null) {
                    session.getTemplateModel(sedModel);
                }
                TemplateTaskReporter reporter = new TemplateTaskReporter();
                tplNode.rebuildContent(reporter, false);
            }
            finally {
                if (sedModel != null) {
                    sedModel.releaseFromRead();
                }
            }
        }
    }

    private IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    protected boolean isValidNode(Node node) {
        return node != null && node.getNodeType() == 1 && ((IDOMElement)node).isCommentTag() && node.getNodeName().equals("tpl:insert");
    }

    protected void afterEdit() {
        ReadOnlyNodeAdapter adapter;
        super.afterEdit();
        IDOMDocument doc = this.getCommandTarget().getActiveModel().getDocument();
        if (doc != null && (adapter = (ReadOnlyNodeAdapter)doc.getAdapterFor((Object)ReadOnlyNodeAdapter.ADAPTER_KEY)) != null) {
            adapter.setReadOnly(doc);
        }
    }

    protected void beforeEdit() {
        ReadOnlyNodeAdapter adapter;
        IDOMDocument doc = this.getCommandTarget().getActiveModel().getDocument();
        if (doc != null && (adapter = (ReadOnlyNodeAdapter)doc.getAdapterFor((Object)ReadOnlyNodeAdapter.ADAPTER_KEY)) != null) {
            adapter.removeReadOnly(doc);
        }
        super.beforeEdit();
    }
}

