/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.commands;

import com.ibm.etools.webedit.common.commands.InsertContainerCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.commands.utils.RangeNormalizer;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.extension.DesignTimeTagUtil;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.commands.PageTemplateCommandUtil;
import com.ibm.etools.webpage.template.commands.TplCommentFactory;
import java.text.MessageFormat;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class InsertContentAreaCommand
extends InsertContainerCommand {
    public static String CONTENT_TEXT = ResourceHandler._UI_Default_content_of__0__1;
    private TplCommentFactory tplFactory;
    private String areaName;
    private boolean expandContentArea = false;

    public InsertContentAreaCommand(String areaName) {
        super(null);
        this.tplFactory = new TplCommentFactory(areaName, true);
        this.areaName = areaName;
        this.setNodeFactory(this.tplFactory);
    }

    protected boolean canDoExecute() {
        IDOMModel model;
        HTMLCommandTarget target = this.getCommandTarget();
        IDOMModel iDOMModel = model = target != null ? target.getActiveModel() : null;
        if (model == null || !PageTemplateCommandUtil.isValidModel(model)) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)model.getDocument());
        if (query.isFragment((Document)model.getDocument()) && !query.acceptEditingAsComplete()) {
            return false;
        }
        if (this.getDomain() != null && this.getDomain().getModel() != model) {
            return false;
        }
        return super.canDoExecute();
    }

    protected Range doInsert(Document document, Range range, NodeFactory factory) {
        this.prepareRange(range);
        if (range != null && range.getCollapsed()) {
            String contentText = MessageFormat.format(CONTENT_TEXT, this.areaName);
            this.tplFactory.setTextSourceAsChild(contentText);
        } else {
            this.tplFactory.setTextSourceAsChild(null);
        }
        if (this.expandContentArea && InsertContentAreaCommand.isAllChildrenSelected(range)) {
            Node common = range.getCommonAncestorContainer();
            if (common.getNodeType() == 3) {
                common = common.getParentNode();
            }
            range.setStartBefore(common);
            range.setEndAfter(common);
        }
        return super.doInsert(document, range, factory);
    }

    protected void prepareRange(Range range) {
        Node node;
        if (range != null && range.getCollapsed() && (node = range.getStartContainer()) != null && this.isQuasiSolid(node)) {
            Node parent = node.getParentNode();
            int index = 0;
            Node n = parent.getFirstChild();
            while (n != null) {
                if (n == node) {
                    range.setStart(parent, index);
                    range.setEnd(parent, index + 1);
                    break;
                }
                ++index;
                n = n.getNextSibling();
            }
        }
    }

    protected boolean isQuasiSolid(Node node) {
        return node.getNodeType() != 3 && (this.getEditQuery().isSolidElement(node) || this.getEditQuery().isEmptyNode(node) || DesignTimeTagUtil.isBodyContentEmpty((Node)node));
    }

    public void setExpandContentArea(boolean expandContentArea) {
        this.expandContentArea = expandContentArea;
    }

    public static boolean isAllChildrenSelected(Range givenRange) {
        Node ancestor;
        Range range = givenRange.cloneRange();
        RangeNormalizer normalizer = new RangeNormalizer(range);
        if (!normalizer.isRangeNormalized()) {
            Node node = range.getStartContainer();
            int offset = range.getStartOffset();
            range.setStart(range.getEndContainer(), range.getEndOffset());
            range.setEnd(node, offset);
        }
        if ((ancestor = range.getCommonAncestorContainer()).getNodeType() == 3) {
            ancestor = ancestor.getParentNode();
        }
        Node startContainer = range.getStartContainer();
        int startOffset = range.getStartOffset();
        while (startContainer != ancestor) {
            if (startOffset != 0) {
                return false;
            }
            startOffset = InsertContentAreaCommand.getIndex(startContainer);
            startContainer = startContainer.getParentNode();
        }
        if (startOffset != 0) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)startContainer);
        Node endContainer = range.getCollapsed() ? range.getStartContainer() : range.getEndContainer();
        int endOffset = range.getCollapsed() ? range.getStartOffset() : range.getEndOffset();
        while (endContainer != ancestor) {
            if (endOffset < InsertContentAreaCommand.getEndOffset(endContainer, query)) {
                return false;
            }
            int index = endContainer.getParentNode().getChildNodes().getLength();
            Node n = endContainer.getLastChild();
            while (n != null) {
                if (n == endContainer) break;
                n = n.getPreviousSibling();
                --index;
            }
            endOffset = InsertContentAreaCommand.getIndex(endContainer) + 1;
            endContainer = endContainer.getParentNode();
        }
        return endOffset >= InsertContentAreaCommand.getEndOffset(endContainer, query);
    }

    private static int getIndex(Node node) {
        int result = 0;
        Node n = node.getFirstChild();
        while (n != null) {
            if (n == node) break;
            n = n.getNextSibling();
            ++result;
        }
        return result;
    }

    private static int getEndOffset(Node node, EditModelQuery query) {
        if (node.getNodeType() == 3) {
            return ((Text)node).getLength();
        }
        if (node.getNodeType() == 1 && query.isEmptyBlock((Element)node)) {
            return 0;
        }
        return node.getChildNodes().getLength();
    }
}

