/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.commands;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.commands.IApplyTemplateCustomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ApplyTemplateCustomizerRegistry {
    private static ApplyTemplateCustomizerRegistry registry;
    private List customizers = new ArrayList();
    private List customizersForNewWizard = new ArrayList();

    public static ApplyTemplateCustomizerRegistry getInstance() {
        if (registry == null) {
            registry = new ApplyTemplateCustomizerRegistry();
        }
        return registry;
    }

    private ApplyTemplateCustomizerRegistry() {
        this.registerTemplateActionCustomizers();
    }

    public void registerApplyTemplateCustomizer(IApplyTemplateCustomizer customizer) {
        if (customizer != null && !this.customizers.contains(customizer)) {
            this.customizers.add(customizer);
        }
    }

    public void unregisterApplyTemplateCustomizer(IApplyTemplateCustomizer customizer) {
        if (customizer != null && this.customizers != null) {
            this.customizers.remove(customizer);
        }
    }

    public List getCustomizers() {
        List customizers = this.customizers == null ? Collections.EMPTY_LIST : new ArrayList(this.customizers);
        return customizers;
    }

    public void registerApplyTemplateCustomizerForNewWizard(IApplyTemplateCustomizer customizer) {
        if (customizer != null && !this.customizersForNewWizard.contains(customizer)) {
            this.customizersForNewWizard.add(customizer);
        }
    }

    public void unregisterApplyTemplateCustomizerForNewWizard(IApplyTemplateCustomizer customizer) {
        if (customizer != null && this.customizersForNewWizard != null) {
            this.customizersForNewWizard.remove(customizer);
        }
    }

    public List getCustomizersForNewWizard() {
        List customizersForNewWizard = this.customizersForNewWizard == null ? Collections.EMPTY_LIST : new ArrayList(this.customizersForNewWizard);
        return customizersForNewWizard;
    }

    private void registerTemplateActionCustomizers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.etools.webpage.template", "TemplateActionCustomizer");
        int i = 0;
        while (i < elements.length) {
            String wizConValue = null;
            try {
                Object customizer;
                if (elements[i].getName().equals("action") && (customizer = elements[i].createExecutableExtension("class")) instanceof IApplyTemplateCustomizer) {
                    this.registerApplyTemplateCustomizer((IApplyTemplateCustomizer)customizer);
                    wizConValue = elements[i].getAttribute("wizard_contribution");
                    if (wizConValue != null && wizConValue.equals("true")) {
                        this.registerApplyTemplateCustomizerForNewWizard((IApplyTemplateCustomizer)customizer);
                    }
                }
            }
            catch (CoreException e) {
                Logger.log(e);
            }
            ++i;
        }
    }
}

