/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template;

import com.ibm.cic.licensing.common.LicenseCheck;
import com.ibm.etools.webedit.linkfixup.LinkStyleHandler;
import com.ibm.etools.webedit.linkfixup.LinkStyleModerator;
import com.ibm.etools.webpage.template.PageTemplateLinkStyleHandler;
import com.ibm.etools.webpage.template.SampleLocator;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexManager;
import com.ibm.etools.webpage.template.internal.sample.TemplateSampleLocator;
import com.ibm.etools.webpage.template.util.TemplateFacetUtil;
import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TemplatePlugin
extends AbstractUIPlugin {
    private static TemplatePlugin plugin;
    public static String ID;
    public static final String PREFER_JSPCOMMENT_PREFERENCE = "preferjspcomment";
    public static final String DOCROOT_PREFERENCE = "preferdocroot";
    public static final String READONLY_PROMPT_PREFERENCE = "prefreadonly";
    public static final String CREATE_TEMPLATE_PREFERENCE = "prefcreatetemplate";
    public static final String FRAME_COLOR_PREFERENCE = "framecolor";
    public static final String CONTEXTPATH_PREFERENCE = "runtimeContextPath";
    public static final String BROWSE_DOCROOT_LINK_PROMPT_PREFERENCE = "browseDocRoot";
    public static final boolean DEFAULT_PREFER_JSPCOMMENT = true;
    public static final boolean DEFAULT_PREFER_DOCROOT = true;
    public static final boolean DEFAULT_READONLY_PROMPT = true;
    public static final RGB DEFAULT_FRAME_COLOR;
    public static final boolean DEFAULT_PREFER_CONTEXTPATH = true;
    public static final String DEFAULT_BROWSE_DOCROOT_LINK_PROMPT = "prompt";

    static {
        ID = "com.ibm.etools.webpage.template";
        DEFAULT_FRAME_COLOR = new RGB(255, 0, 0);
    }

    public TemplatePlugin() {
        plugin = this;
    }

    public static TemplatePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public SampleLocator getSampleLocator() {
        return TemplateSampleLocator.getInstance();
    }

    public boolean getDefaultJSPCommentPreference() {
        return this.getPreferenceStore().getDefaultBoolean(PREFER_JSPCOMMENT_PREFERENCE);
    }

    public boolean getDefaultDocRootPreference() {
        return this.getPreferenceStore().getDefaultBoolean(DOCROOT_PREFERENCE);
    }

    public boolean getDefaultContextpathPreference() {
        return this.getPreferenceStore().getDefaultBoolean(CONTEXTPATH_PREFERENCE);
    }

    public boolean getDefaultReadOnlyPromptPreference() {
        return this.getPreferenceStore().getDefaultBoolean(READONLY_PROMPT_PREFERENCE);
    }

    public boolean getDefaultCreateTemplatePreference() {
        return this.getPreferenceStore().getDefaultBoolean(CREATE_TEMPLATE_PREFERENCE);
    }

    public RGB getDefaultFrameColorPreference() {
        RGB rgb = TemplatePlugin.str2RGB(this.getPreferenceStore().getDefaultString(FRAME_COLOR_PREFERENCE));
        return rgb != null ? rgb : DEFAULT_FRAME_COLOR;
    }

    private static RGB str2RGB(String color) {
        StringTokenizer st;
        if (color != null && color.startsWith("RGB {") && color.endsWith("}") && (st = new StringTokenizer(color.substring(5, color.length() - 1), ", ")).hasMoreTokens()) {
            int red = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                int green = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    int blue = Integer.parseInt(st.nextToken());
                    return new RGB(red, green, blue);
                }
            }
        }
        return null;
    }

    public boolean getJSPCommentPreference() {
        return this.getPreferenceStore().getBoolean(PREFER_JSPCOMMENT_PREFERENCE);
    }

    public boolean getDocRootPreference() {
        return this.getPreferenceStore().getBoolean(DOCROOT_PREFERENCE);
    }

    public boolean getContextpathPreference() {
        return this.getPreferenceStore().getBoolean(CONTEXTPATH_PREFERENCE);
    }

    public boolean getReadOnlyPromptPreference() {
        return this.getPreferenceStore().getBoolean(READONLY_PROMPT_PREFERENCE);
    }

    public boolean getCreateTemplatePreference() {
        return this.getPreferenceStore().getBoolean(CREATE_TEMPLATE_PREFERENCE);
    }

    public RGB getFrameColorPreference() {
        RGB rgb = TemplatePlugin.str2RGB(this.getPreferenceStore().getString(FRAME_COLOR_PREFERENCE));
        return rgb != null ? rgb : DEFAULT_FRAME_COLOR;
    }

    public void setJSPCommentPreference(boolean value) {
        this.getPreferenceStore().setValue(PREFER_JSPCOMMENT_PREFERENCE, value);
    }

    public void setDocRootPreference(boolean value) {
        this.getPreferenceStore().setValue(DOCROOT_PREFERENCE, value);
    }

    public void setContextpathPreference(boolean value) {
        this.getPreferenceStore().setValue(CONTEXTPATH_PREFERENCE, value);
    }

    public void setReadOnlyPromptPreference(boolean value) {
        this.getPreferenceStore().setValue(READONLY_PROMPT_PREFERENCE, value);
    }

    public void setCreateTemplatePreference(boolean value) {
        this.getPreferenceStore().setValue(CREATE_TEMPLATE_PREFERENCE, value);
    }

    public void setFrameColorPreference(RGB value) {
        if (value == null) {
            value = DEFAULT_FRAME_COLOR;
        }
        this.getPreferenceStore().setValue(FRAME_COLOR_PREFERENCE, value.toString());
    }

    public void addTemplateFacetAndNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (this.isTemplateNatureInstalled(project)) {
            return;
        }
        TemplateFacetUtil.installTemplateFacet(project);
    }

    public boolean isTemplateNatureInstalled(IProject project) throws CoreException {
        return project != null ? project.hasNature("com.ibm.etools.webpage.template.templatenature") : false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LicenseCheck.requestLicense((Plugin)this, (String)"com.ibm.etools.webedit.editor.feature", (String)"7.0.0");
        LinkStyleModerator.getInstance().registerLinkStyleHandler((LinkStyleHandler)new PageTemplateLinkStyleHandler());
    }

    public void stop(BundleContext context) throws Exception {
        TemplateRefIndexManager.getInstance().saveIndexes();
        super.stop(context);
    }
}

