/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template;

import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.internal.builder.RebuildMarkerUtil;
import com.ibm.etools.webpage.template.internal.builder.ReferenceMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class TemplateNature
implements IProjectNature {
    public static final String NATURE_ID = "com.ibm.etools.webpage.template.templatenature";
    public static final String BUILDER_ID = "com.ibm.etools.webpage.template.templatebuilder";
    private IProject project;
    private ReferenceMap referenceMap;

    public void configure() throws CoreException {
        this.addToBuildSpec(BUILDER_ID);
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec(BUILDER_ID);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IFile[] getTemplateFiles() {
        return TemplateNature.getTemplateFiles(this.getProject());
    }

    public static IFile[] getTemplateFiles(IProject project) {
        if (project == null) {
            return new IFile[0];
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return new IFile[0];
        }
        return TemplateNature.getTemplateFiles(component);
    }

    public static IFile[] getTemplateFiles(IVirtualComponent component) {
        if (component == null) {
            return new IFile[0];
        }
        IVirtualFolder container = component.getRootFolder();
        if (container == null) {
            return new IFile[0];
        }
        ArrayList templates = new ArrayList();
        TemplateNature.collectTemplateFiles((IVirtualContainer)container, templates);
        int size = templates.size();
        IFile[] templatesArray = new IFile[size];
        int i = 0;
        while (i < size) {
            templatesArray[i] = ((IVirtualFile)templates.get(i)).getUnderlyingFile();
            ++i;
        }
        return templatesArray;
    }

    private static void collectTemplateFiles(IVirtualContainer container, List templates) {
        if (container == null) {
            return;
        }
        IVirtualResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        if (members == null) {
            return;
        }
        int i = 0;
        while (i < members.length) {
            if (members[i].getType() == 16) {
                if (FileTypeHandler.isTemplate((IFile)members[i].getUnderlyingResource())) {
                    templates.add(members[i]);
                }
            } else if (members[i].getType() == 32) {
                TemplateNature.collectTemplateFiles((IVirtualContainer)members[i], templates);
            }
            ++i;
        }
    }

    public static void addNature(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = NATURE_ID;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void removeNature(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
        newNatures.remove(NATURE_ID);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, null);
    }

    public void setReferenceMap(ReferenceMap referenceMap) {
        this.referenceMap = referenceMap;
    }

    public void updateMarkers(Collection rebuildFiles) {
        if (this.referenceMap == null) {
            return;
        }
        RebuildMarkerUtil util = new RebuildMarkerUtil(this.referenceMap);
        util.rebuildMarker(rebuildFiles);
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand builderCommand = this.getBuilderCommand(description, builderID);
        if (builderCommand == null) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setBuilderCommand(description, command);
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    private ICommand getBuilderCommand(IProjectDescription description, String builderId) {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    private void setBuilderCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldBuilderCommand = this.getBuilderCommand(description, newCommand.getBuilderName());
        int linksbuilder_position = this.findLinksBuilder(oldCommands);
        if (linksbuilder_position == -1) {
            description = this.getProject().getDescription();
            oldCommands = description.getBuildSpec();
            oldBuilderCommand = this.getBuilderCommand(description, newCommand.getBuilderName());
            linksbuilder_position = this.findLinksBuilder(oldCommands);
        }
        ICommand[] newCommands = oldBuilderCommand == null ? this.addBuildSpecAfterLinksBuilder(oldCommands, linksbuilder_position, newCommand) : this.updateBuildSpec(oldCommands, linksbuilder_position, newCommand);
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }

    int findLinksBuilder(ICommand[] newCommands) {
        return this.findBuilder(newCommands, "com.ibm.etools.links.management.linksbuilder");
    }

    int findTemplateBuilder(ICommand[] newCommands) {
        return this.findBuilder(newCommands, BUILDER_ID);
    }

    int findValidationBuilder(ICommand[] newCommands) {
        return this.findBuilder(newCommands, "org.eclipse.wst.validation.validationbuilder");
    }

    int findSiteNavBuilder(ICommand[] newCommands) {
        return this.findBuilder(newCommands, "com.ibm.etools.siteedit.SiteNavBuilder");
    }

    int findBuilder(ICommand[] newCommands, String name) {
        int i = 0;
        while (i < newCommands.length) {
            if (name.equals(newCommands[i].getBuilderName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ICommand[] addBuildSpecAfterLinksBuilder(ICommand[] oldCommands, int linksbuilder_position, ICommand newCommand) {
        ICommand[] newCommands = new ICommand[oldCommands.length + 1];
        System.arraycopy(oldCommands, 0, newCommands, 0, linksbuilder_position + 1);
        newCommands[linksbuilder_position + 1] = newCommand;
        System.arraycopy(oldCommands, linksbuilder_position + 1, newCommands, linksbuilder_position + 2, oldCommands.length - (linksbuilder_position + 1));
        return newCommands;
    }

    public ICommand[] updateBuildSpec(ICommand[] oldCommands, int linksbuilder_position, ICommand newCommand) {
        ICommand[] newCommands;
        int templatebuilder_position = this.findTemplateBuilder(oldCommands);
        int validationbuilder_position = this.findValidationBuilder(oldCommands);
        int sitenavbuilder_position = this.findSiteNavBuilder(oldCommands);
        if (linksbuilder_position < templatebuilder_position && (validationbuilder_position == -1 || validationbuilder_position != -1 && templatebuilder_position < validationbuilder_position) && (sitenavbuilder_position == -1 || templatebuilder_position != -1 && templatebuilder_position < sitenavbuilder_position)) {
            oldCommands[templatebuilder_position] = newCommand;
            newCommands = oldCommands;
        } else if (linksbuilder_position > templatebuilder_position) {
            newCommands = new ICommand[oldCommands.length];
            System.arraycopy(oldCommands, 0, newCommands, 0, templatebuilder_position);
            System.arraycopy(oldCommands, templatebuilder_position + 1, newCommands, templatebuilder_position, linksbuilder_position - templatebuilder_position);
            newCommands[linksbuilder_position] = newCommand;
            System.arraycopy(oldCommands, linksbuilder_position + 1, newCommands, linksbuilder_position + 1, oldCommands.length - (linksbuilder_position + 1));
        } else {
            newCommands = new ICommand[oldCommands.length];
            System.arraycopy(oldCommands, 0, newCommands, 0, linksbuilder_position + 1);
            newCommands[linksbuilder_position + 1] = newCommand;
            System.arraycopy(oldCommands, linksbuilder_position + 1, newCommands, linksbuilder_position + 2, templatebuilder_position - (linksbuilder_position + 1));
            System.arraycopy(oldCommands, templatebuilder_position + 1, newCommands, templatebuilder_position + 1, oldCommands.length - (templatebuilder_position + 1));
        }
        return newCommands;
    }
}

