/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.util;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.wizards.tiles.TilesSampleDefinitionElement;
import com.ibm.etools.webpage.template.wizards.tiles.TilesTemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectRegionsUtil {
    public static IDOMModel getModelForRead(IFile file) {
        if (file == null) {
            return null;
        }
        IDOMModel model = null;
        String sseId = ModelManagerUtil.calculateSSEModelId((IFile)file);
        model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead((Object)sseId);
        if (model == null) {
            ModelManagerUtil mmu = new ModelManagerUtil(null, null);
            model = (IDOMModel)mmu.getModelForRead(file);
        }
        return model;
    }

    public static IDOMModel getModelForEdit(IFile file) {
        IDOMModel model = null;
        String sseId = ModelManagerUtil.calculateSSEModelId((IFile)file);
        model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForEdit((Object)sseId);
        if (model == null) {
            ModelManagerUtil mmu = new ModelManagerUtil(null, null);
            model = (IDOMModel)mmu.getModelForEdit(file);
        }
        return model;
    }

    public static IDOMModel getModelForRead(IPath fullPath) {
        IDOMModel model = null;
        if (model == null) {
            ModelManagerUtil mmu = new ModelManagerUtil(null, null);
            model = (IDOMModel)mmu.getModelForRead(fullPath);
        }
        return model;
    }

    public static IDOMModel getTempTemplateModelForRead(Object template) {
        if (template instanceof TilesDefinitionElement) {
            IDOMModel templateJspModel;
            TilesDefinitionElement element = (TilesDefinitionElement)template;
            IDOMModel iDOMModel = templateJspModel = element.getFile() != null ? SelectRegionsUtil.getModelForRead(element.getFile()) : null;
            if (templateJspModel == null && element instanceof TilesSampleDefinitionElement) {
                TilesSampleDefinitionElement ele = (TilesSampleDefinitionElement)element;
                IDOMModel sample = SelectRegionsUtil.getModelForRead(ele.getSampleLocation());
                try {
                    IFile file = ele.getFile();
                    while (true) {
                        if ((file = file.getParent().getFile((IPath)new Path("_" + file.getName()))).exists()) {
                            continue;
                        }
                        IStructuredModel structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                        if (structuredModel == null) break;
                        structuredModel.releaseFromRead();
                    }
                    templateJspModel = (IDOMModel)new ModelManagerUtil(null, null).getNewModelForRead(file);
                    templateJspModel.getStructuredDocument().set(sample.getStructuredDocument().get());
                    TilesTemplateURLFixup.convertSampleFromStaticToDynamic(element.getComponent(), templateJspModel, ele.getSampleLocation(), null, true);
                }
                finally {
                    sample.releaseFromRead();
                }
            }
            return templateJspModel;
        }
        if (template instanceof IPath) {
            IFile file = WebComponent.getFileForLocation((IPath)((IPath)template));
            if (file != null) {
                return SelectRegionsUtil.getModelForRead(file);
            }
            return SelectRegionsUtil.getModelForRead((IPath)template);
        }
        return null;
    }

    public static Node[] getSpecifiedNodes(Node rootNode, String specifiedNodeName) {
        NodeList children;
        ArrayList<Node> list = new ArrayList<Node>();
        if (rootNode == null || specifiedNodeName == null) {
            return null;
        }
        if (specifiedNodeName.equalsIgnoreCase(rootNode.getNodeName())) {
            list.add(rootNode);
        }
        if ((children = rootNode.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                Node[] foundItems = SelectRegionsUtil.getSpecifiedNodes(child, specifiedNodeName);
                List<Node> foundItemsList = Arrays.asList(foundItems);
                list.addAll(foundItemsList);
                ++i;
            }
        }
        Node[] ret = list.toArray(new Node[list.size()]);
        return ret;
    }

    public static String getHtmlTitle(IFile file) {
        IStructuredDocument flatModel;
        String strTitle = "";
        try {
            IModelManager mm = StructuredModelManager.getModelManager();
            flatModel = mm.createStructuredDocumentFor(file);
        }
        catch (Exception exception) {
            return strTitle;
        }
        strTitle = SelectRegionsUtil.getHtmlTitle(flatModel);
        return strTitle;
    }

    public static String getHtmlTitle(IStructuredDocument flatModel) {
        String strTitle = "";
        if (flatModel == null) {
            return strTitle;
        }
        IStructuredDocumentRegionList nodeList = flatModel.getRegionList();
        int nNode = nodeList.getLength();
        int i = 0;
        while (i < nNode) {
            IStructuredDocumentRegion node = nodeList.item(i);
            if (node.getType() == "XML_TAG_NAME" && SelectRegionsUtil.isSpecifiedNode(node, "title")) {
                ITextRegion r;
                String type;
                IStructuredDocumentRegion titleNode = nodeList.item(i + 1);
                Iterator it = titleNode.getRegions().iterator();
                if (!it.hasNext() || "XML_CONTENT" != (type = (r = (ITextRegion)it.next()).getType())) break;
                strTitle = titleNode.getText(r);
                break;
            }
            ++i;
        }
        return strTitle;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isSpecifiedNode(IStructuredDocumentRegion node, String tag) {
        it = node.getRegions().iterator();
        while (it.hasNext()) {
            r = (ITextRegion)it.next();
            type = r.getType();
            if ("XML_TAG_OPEN" == type || "XML_END_TAG_OPEN" == type) break;
        }
        if (it.hasNext()) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            r = (ITextRegion)it.next();
            type = r.getType();
            if ("XML_TAG_NAME" != type) continue;
            tagName = node.getText(r);
            return tagName != null && tagName.equalsIgnoreCase(tag) != false;
lbl14:
            // 2 sources

            ** while (it.hasNext())
        }
lbl15:
        // 1 sources

        return false;
    }

    public static boolean isFrameset(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        IDOMModel model = null;
        try {
            model = SelectRegionsUtil.getModelForRead(file);
            boolean bl = SelectRegionsUtil.isFrameset(model);
            return bl;
        }
        finally {
            if (model != null && model.getReferenceCountForRead() > 0) {
                model.releaseFromRead();
                model = null;
            }
        }
    }

    public static boolean isFrameset(IDOMModel model) {
        if (model == null) {
            return false;
        }
        IDOMDocument doc = model.getDocument();
        if (doc == null) {
            return false;
        }
        Element rootNode = doc.getDocumentElement();
        if (rootNode == null) {
            return false;
        }
        NodeList elements = rootNode.getElementsByTagName("FRAMESET");
        return elements != null && elements.getLength() > 0;
    }

    public static String getIANAEncoding(IDOMModel model) {
        if (model == null) {
            return null;
        }
        return ApplyTplUtil.getCharset((IStructuredModel)model);
    }

    public static boolean saveModel(IDOMModel model, IFile file) {
        try {
            if (file.exists()) {
                model.save(file, EncodingRule.IGNORE_CONVERSION_ERROR);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static IPath getTemplateLocation(Object template) {
        if (template == null) {
            return null;
        }
        if (template instanceof IPath) {
            return (IPath)template;
        }
        if (template instanceof TilesSampleDefinitionElement) {
            TilesSampleDefinitionElement defs = (TilesSampleDefinitionElement)((Object)template);
            return defs.getSampleLocation();
        }
        if (template instanceof TilesDefinitionElement) {
            TilesDefinitionElement def = (TilesDefinitionElement)template;
            return def.getFile() != null ? def.getFile().getLocation() : null;
        }
        return null;
    }

    public static IFile getTemplateFile(IVirtualComponent component, Object template) {
        if (template == null) {
            return null;
        }
        if (template instanceof IPath) {
            return WebComponent.getFileForLocation((IPath)((IPath)template));
        }
        if (template instanceof TilesDefinitionElement) {
            TilesDefinitionElement def = (TilesDefinitionElement)template;
            return def.getFile();
        }
        return null;
    }
}

