/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.util;

import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.util.TemplateEncodingUtil;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.selection.ui.viewer.TilesDefinitionImageItemProvider;
import com.ibm.etools.webpage.template.wizards.tiles.TilesDefinitionElementFactory;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ApplyTplUtil
extends TemplateEncodingUtil {
    public static boolean hasStaticTemplate(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        TemplateModelSession session = new TemplateModelSession();
        TemplateModel tplModel = session.getTemplateModel(file);
        TplNode templateNode = TemplateModelUtil.findTemplateNodeOf((TemplateModel)tplModel);
        return templateNode != null;
    }

    public static boolean hasDynamicTemplate(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        IDOMModel model = SelectRegionsUtil.getModelForRead(file);
        try {
            if ("TilesInstance".equals(TilesUtil.getTilesType((IDOMModel)model))) {
                return true;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
                model = null;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasTemplate(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        IDOMModel model = SelectRegionsUtil.getModelForRead(file);
        try {
            TemplateModelSession session = new TemplateModelSession();
            TemplateModel tplModel = session.getTemplateModel((IStructuredModel)model);
            TplNode templateNode = TemplateModelUtil.findTemplateNodeOf((TemplateModel)tplModel);
            if (templateNode != null) {
                return true;
            }
            if (!"TilesInstance".equals(TilesUtil.getTilesType((IDOMModel)model))) return false;
            return true;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
                model = null;
            }
        }
    }

    public static boolean isStaticTemplate(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        return FileTypeHandler.isTemplate((IFile)file);
    }

    public static boolean isDyamicTemplate(IFile file) {
        IDOMModel model = SelectRegionsUtil.getModelForRead(file);
        try {
            if ("TilesTemplate".equals(TilesUtil.getTilesType((IDOMModel)model))) {
                return true;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
                model = null;
            }
        }
        return false;
    }

    public static boolean isTemplate(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (FileTypeHandler.isTemplate((IFile)file)) {
            return true;
        }
        IDOMModel model = SelectRegionsUtil.getModelForRead(file);
        try {
            if ("TilesTemplate".equals(TilesUtil.getTilesType((IDOMModel)model))) {
                return true;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
                model = null;
            }
        }
        return false;
    }

    public static boolean checkEncoding(IDOMModel targetModel, IDOMModel templateFileModel) {
        if (targetModel == null || templateFileModel == null) {
            return false;
        }
        String targetFileEncoding = ApplyTplUtil.getCharset((IStructuredModel)targetModel);
        String templateFileEncoding = ApplyTplUtil.getCharset((IStructuredModel)templateFileModel);
        if (targetFileEncoding == null || templateFileEncoding == null) {
            return false;
        }
        return targetFileEncoding.equalsIgnoreCase(templateFileEncoding);
    }

    public static boolean checkJSPSyntax(IDOMModel targetModel, IDOMModel templateFileModel) {
        boolean templateSyntax;
        if (targetModel == null || templateFileModel == null) {
            return false;
        }
        boolean targetSyntax = targetModel.getDocument().isJSPType() && targetModel.getDocument().isJSPDocument();
        boolean bl = templateSyntax = templateFileModel.getDocument().isJSPType() && templateFileModel.getDocument().isJSPDocument();
        return targetSyntax == templateSyntax;
    }

    public static boolean checkHasContentArea(IPath templatePath) {
        if (templatePath == null) {
            return false;
        }
        TemplateModelSession session = new TemplateModelSession();
        TemplateModel tplModel = session.getTemplateModel(templatePath);
        if (tplModel == null) {
            return false;
        }
        return tplModel.isTemplate();
    }

    public static boolean isValidTemplate(Object template) {
        if (template instanceof IFile) {
            return FileTypeHandler.isTemplate((IFile)((IFile)template)) && ((IFile)template).exists();
        }
        if (template instanceof TilesDefinitionElement) {
            TilesDefinitionElement ele = (TilesDefinitionElement)template;
            IFile file = ele.getFile();
            return file != null && file.exists();
        }
        return false;
    }

    public static Object getTemplateOfInstance(IFile instance) {
        IFile template = TemplateTypeUtil.getTemplateFileOf((IFile)instance);
        if (template == null) {
            IDOMModel model = SelectRegionsUtil.getModelForRead(instance);
            try {
                TilesDefinitionElement ele;
                if ("TilesInstance".equals(TilesUtil.getTilesType((IDOMModel)model)) && (ele = TilesDefinitionElementFactory.createElementFromInstanceModel(model)).getDefinitionName() != null && ele.getFile() != null && ele.getFile().exists()) {
                    template = ele;
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return template;
    }

    public static Object getTemplateOfInstance(IDOMModel model) {
        String location = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        IFile file = WebComponent.getFileForLocation((IPath)new Path(location));
        Assert.isLegal((boolean)file.exists());
        Object template = ApplyTplUtil.getTemplateOfInstance(file);
        if (template == null && (template = TemplateTypeUtil.getTemplateFileOf((IFile)file)) instanceof IFile) {
            template = ((IFile)template).getLocation();
        }
        return template;
    }

    public static String getTemplateLabel(Object template) {
        return new TilesDefinitionImageItemProvider().getText(template);
    }

    public static String getTemplateLabelOfInstance(IDOMModel model) {
        Object template = ApplyTplUtil.getTemplateOfInstance(model);
        return ApplyTplUtil.getTemplateLabel(template);
    }
}

