/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles.areas;

import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.wizards.selecttpl.ModelPreviewWidget;
import com.ibm.etools.webpage.template.wizards.tiles.areas.IContentAreaDescriptor;
import com.ibm.etools.webpage.template.wizards.tiles.areas.IPutMapHolder;
import com.ibm.etools.webpage.template.wizards.tiles.areas.ITilesPutMap;
import com.ibm.etools.webpage.template.wizards.tiles.areas.TilesConfigContentAreaLabelProvider;
import com.ibm.etools.webpage.template.wizards.tiles.areas.TilesConfigOneAreaWidget;
import com.ibm.etools.webpage.template.wizards.tiles.areas.TilesFileConfigContentAreaTreeContentProvider;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class TilesConfigContentAreaWidget
implements ISelectionChangedListener,
IPutMapHolder,
ISelectionProvider {
    private final int DELAY_MSEC = 1000;
    private TreeViewer viewer;
    private IContentProvider contentProvider;
    private IBaseLabelProvider labelProvider;
    private ITilesPutMap putMap;
    private TilesConfigOneAreaWidget oneAreaWidget = new TilesConfigOneAreaWidget();
    private ModelPreviewWidget preview;
    private Object input;
    private IDOMModel selectedModel;
    private IDOMModel previewModel;
    private PreviewUpdater updater;
    private Composite widgetRoot;
    private List selectionListeners = new ArrayList();

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createContentAreaTable(composite);
        Composite columns = new Composite(composite, 0);
        columns.setLayout((Layout)new GridLayout(2, false));
        columns.setLayoutData((Object)new GridData(770));
        this.createConfigArea(columns);
        this.createPreview(columns);
        this.widgetRoot = composite;
        return composite;
    }

    protected void createContentAreaTable(Composite composite) {
        final Label label = new Label(composite, 0);
        label.setText(ResourceHandler._UI_Specify_Content_File_Name_Page_3);
        this.viewer = new TreeViewer(composite, 2820);
        TreeColumn column = new TreeColumn(this.viewer.getTree(), 16384);
        String columnLabel1 = ResourceHandler._UI_Specify_Content_File_Name_Page_4;
        String columnLabel2 = ResourceHandler._UI_Tiles_Config_Content_Area_Widget_0;
        String columnLabel3 = ResourceHandler._UI_Specify_Content_File_Name_Page_5;
        column.setText(columnLabel1);
        column.setWidth(200);
        TreeColumn column2 = new TreeColumn(this.viewer.getTree(), 16384);
        column2.setText(columnLabel2);
        column2.setWidth(100);
        TreeColumn column3 = new TreeColumn(this.viewer.getTree(), 16384);
        column3.setText(columnLabel3);
        column3.setWidth(300);
        this.viewer.getTree().setHeaderVisible(true);
        this.contentProvider = this.createContentProvider();
        this.viewer.setContentProvider(this.contentProvider);
        this.labelProvider = this.createLabelProvider();
        this.viewer.setLabelProvider(this.labelProvider);
        this.viewer.setInput(this.input);
        GridData data = new GridData(768);
        data.heightHint = 100;
        this.viewer.getTree().setLayoutData((Object)data);
        this.viewer.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = LegacyActionTools.removeMnemonics((String)label.getText());
                }
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void createConfigArea(Composite parent) {
        this.oneAreaWidget.createContents(parent);
        this.oneAreaWidget.addSelectionChangedListener(this);
    }

    protected Composite createPreview(Composite parent) {
        String label = ResourceHandler._UI_Specify_Content_File_Name_Page_9;
        String labelName = ResourceHandler._UI_Specify_Content_File_Name_Page_10;
        String shortcut = ResourceHandler._UI_Specify_Content_File_Name_Page_11;
        this.preview = new ModelPreviewWidget(label, labelName, shortcut);
        Composite composite1 = this.preview.createControls(parent, 250, 250, 66);
        return composite1;
    }

    @Override
    public ITilesPutMap getPutMap() {
        return this.putMap;
    }

    @Override
    public void setPutMap(ITilesPutMap putMap) {
        this.putMap = putMap;
        if (this.viewer != null) {
            if (this.contentProvider instanceof IPutMapHolder) {
                ((IPutMapHolder)this.contentProvider).setPutMap(putMap);
            }
            if (this.labelProvider instanceof IPutMapHolder) {
                ((IPutMapHolder)this.labelProvider).setPutMap(putMap);
            }
            this.viewer.setInput(this.input);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider().equals(this.oneAreaWidget)) {
            Object selection = ((StructuredSelection)event.getSelection()).getFirstElement();
            this.areaValueChanged(selection != null ? selection.toString() : null);
        } else if (event.getSelectionProvider().equals(this.viewer)) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            this.areaSelectionChanged(selection);
        }
    }

    protected void areaValueChanged(String value) {
        Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (element instanceof IContentAreaDescriptor) {
            IContentAreaDescriptor ele = (IContentAreaDescriptor)element;
            if (this.getPutMap() != null) {
                Map putValues = this.getPutMap().getPutValues(ModelManagerUtil.calculateSSEModelId((IFile)ele.getFile()));
                putValues.put(ele.getAreaName(), value);
                this.viewer.update(element, new String[]{"fileName"});
                if (this.preview != null) {
                    if (this.updater != null) {
                        this.updater.kill();
                    }
                    this.updater = new PreviewUpdater(1000);
                }
            }
        }
        this.fireSelectionChange();
    }

    protected void areaSelectionChanged(Object selection) {
        IFile selectedFile = null;
        String areaName = null;
        if (selection instanceof IContentAreaDescriptor) {
            selectedFile = ((IContentAreaDescriptor)selection).getFile();
            areaName = ((IContentAreaDescriptor)selection).getAreaName();
        }
        if (selectedFile != null && selectedFile.exists()) {
            this.setModel(SelectRegionsUtil.getModelForRead(selectedFile));
        } else {
            this.setModel(null);
        }
        boolean defs = this.putMap.getTemplate() instanceof TilesDefinitionElement;
        if (selectedFile != null) {
            if (defs) {
                this.oneAreaWidget.setArea(selectedFile, ComponentCore.createComponent((IProject)selectedFile.getProject()), ((TilesDefinitionElement)this.putMap.getTemplate()).getDefinitionName(), areaName);
            } else {
                this.oneAreaWidget.setArea(selectedFile, (IFile)this.putMap.getTemplate(), areaName);
            }
            if (areaName != null) {
                Map values = this.putMap.getPutValues(ModelManagerUtil.calculateSSEModelId((IFile)selectedFile));
                String value = values.get(areaName).toString();
                this.oneAreaWidget.setSelection((ISelection)new StructuredSelection((Object)value));
            } else {
                this.oneAreaWidget.setSelection(null);
            }
        }
        if (this.preview != null) {
            ArrayList<Node> focusedNodes = null;
            if (areaName != null) {
                Map map = null;
                if (defs) {
                    TilesDefinitionElement ele = (TilesDefinitionElement)this.putMap.getTemplate();
                    if (ele != null) {
                        TilesDefinitionUtil util = new TilesDefinitionUtil(ele.getComponent(), selectedFile);
                        try {
                            map = TilesConfigContentAreaWidget.getGetAreaMap(util, ele.getDefinitionName());
                        }
                        finally {
                            util.dispose();
                        }
                    }
                } else {
                    map = TilesConfigContentAreaWidget.getGetAreaMap((IFile)this.putMap.getTemplate());
                }
                if (map != null) {
                    Node node;
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    TilesUtil.ContentArea area = (TilesUtil.ContentArea)map.get(areaName);
                    if (area != null && (node = area.getNode()) != null) {
                        if (node.getNodeType() == 2) {
                            nodes.add(((Attr)node).getOwnerElement());
                        } else {
                            nodes.add(node);
                        }
                        focusedNodes = nodes;
                    }
                }
            }
            this.preview.setFocusedNodes(focusedNodes);
        }
        this.fireSelectionChange();
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    protected IContentProvider createContentProvider() {
        return new TilesFileConfigContentAreaTreeContentProvider(this.getPutMap());
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new TilesConfigContentAreaLabelProvider(this.getPutMap());
    }

    public void dispose() {
        this.oneAreaWidget.dispose();
        this.setModel(null);
        if (this.preview != null) {
            this.preview.setModel(null);
            this.preview.disposeThumbnail();
        }
    }

    protected static Map getGetAreaMap(TilesDefinitionUtil util, String defName) {
        if (util == null || defName == null) {
            return new HashMap();
        }
        return util.collectGetAreaMap(defName, true, true, true);
    }

    protected static Map getGetAreaMap(IFile template) {
        ModelManagerUtil util = new ModelManagerUtil(null, null);
        IDOMModel model = (IDOMModel)util.getModelForRead(template);
        try {
            Map map = TilesUtil.collectGetAreaMap((IDOMModel)model, (boolean)true, (boolean)true, (boolean)true);
            return map;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected void setModel(IDOMModel model) {
        IDOMModel oldModel = this.selectedModel;
        if (oldModel != model && this.preview != null) {
            IDOMModel oldPreviewModel = this.previewModel;
            this.previewModel = model != null ? this.getPutMap().createPreviewModel(model) : null;
            this.preview.setModel(this.previewModel);
            if (oldPreviewModel != null) {
                oldPreviewModel.releaseFromEdit();
            }
        }
        this.selectedModel = model;
        if (oldModel != null) {
            oldModel.releaseFromRead();
        }
    }

    protected void updatePreviewModel() {
        if (this.preview != null) {
            IDOMModel oldPreviewModel = this.previewModel;
            this.previewModel = this.selectedModel != null ? this.getPutMap().createPreviewModel(this.selectedModel) : null;
            this.preview.setModel(this.previewModel);
            if (oldPreviewModel != null) {
                oldPreviewModel.releaseFromEdit();
            }
        }
    }

    protected IDOMModel getModel() {
        return this.selectedModel;
    }

    public void aboutToShow() {
        this.viewer.expandAll();
        TreeItem[] elements = this.viewer.getTree().getItems();
        if (elements != null && elements.length > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(elements[0].getData()));
            this.fireSelectionChange();
        }
    }

    public TilesConfigOneAreaWidget getTilesConfigOneAreaWidget() {
        return this.oneAreaWidget;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
            return new StructuredSelection((Object)this.viewer.getSelection());
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
            this.viewer.setSelection(selection);
        }
    }

    protected void fireSelectionChange() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    public void setEnbleWidget(boolean enabled) {
        TilesConfigContentAreaWidget.setEnable((Control)this.widgetRoot, enabled);
        if (enabled) {
            this.aboutToShow();
        }
    }

    private static void setEnable(Control control, boolean enabled) {
        control.setEnabled(enabled);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                TilesConfigContentAreaWidget.setEnable(children[i], enabled);
                ++i;
            }
        }
    }

    public class PreviewUpdater
    implements Runnable {
        private int delayMSec = 0;
        private boolean killFrag;

        public PreviewUpdater(int delayMSec) {
            this.delayMSec = delayMSec;
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                dsp.timerExec(this.delayMSec, (Runnable)this);
            }
        }

        public void kill() {
            this.killFrag = true;
        }

        @Override
        public void run() {
            if (this.killFrag) {
                return;
            }
            Display dsp = Display.getCurrent();
            Control ctrl = TilesConfigContentAreaWidget.this.oneAreaWidget.getControl();
            if (dsp != null && !dsp.isDisposed() && ctrl != null && !ctrl.isDisposed()) {
                BusyIndicator.showWhile((Display)dsp, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TilesConfigContentAreaWidget.this.updatePreviewModel();
                    }
                });
            }
        }
    }
}

