/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles.areas;

import com.ibm.etools.tiles.TilesPlugin;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.tiles.ITilesConfigContentAreaConstants;
import com.ibm.etools.webpage.template.tiles.util.TilesConfigContentAreaUtil;
import com.ibm.etools.webpage.template.wizards.tiles.areas.IContentAreaDescriptor;
import com.ibm.etools.webpage.template.wizards.tiles.areas.IPutMapHolder;
import com.ibm.etools.webpage.template.wizards.tiles.areas.ITilesPutMap;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class TilesConfigContentAreaLabelProvider
implements ITableLabelProvider,
IPutMapHolder,
ITilesConfigContentAreaConstants {
    ITilesPutMap putMap;
    Image defaultImage;
    Map mapInDef;
    public static final String PROP_AREANAME = "areaName";
    public static final String PROP_AREATYPE = "areaType";
    public static final String PROP_FILENAME = "fileName";

    public TilesConfigContentAreaLabelProvider(ITilesPutMap putInfo) {
        this.putMap = putInfo;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof IContentAreaDescriptor && ((IContentAreaDescriptor)element).getType() == 1) {
            IContentAreaDescriptor ele = (IContentAreaDescriptor)element;
            Map values = this.putMap.getPutValues(ModelManagerUtil.calculateSSEModelId((IFile)ele.getFile()));
            String value = values.get(ele.getAreaName()).toString();
            IStatus status = TilesConfigContentAreaUtil.validate(value, ele.getFile(), ele.getAreaName(), this.getMapInDefinition(ele.getFile()));
            if (status.getSeverity() == 1) {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            if (status.getSeverity() == 2) {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            if (status.getSeverity() == 4) {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            if (this.defaultImage == null) {
                String iconPathStr = "icons/palette/small16/tiles/put_pal.gif";
                URL url = TilesPlugin.getDefault().getBundle().getEntry(iconPathStr);
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                this.defaultImage = desc.createImage();
            }
            return this.defaultImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IContentAreaDescriptor && ((IContentAreaDescriptor)element).getType() == 1) {
            IContentAreaDescriptor ele = (IContentAreaDescriptor)element;
            if (columnIndex == 0) {
                return ele.getAreaName();
            }
            Map values = this.putMap.getPutValues(ModelManagerUtil.calculateSSEModelId((IFile)ele.getFile()));
            String value = values.get(ele.getAreaName()).toString();
            if (columnIndex == 1) {
                return TilesConfigContentAreaLabelProvider.getTypeLabel(value);
            }
            return TilesConfigContentAreaLabelProvider.getValueLabel(value);
        }
        if (columnIndex == 0) {
            return element.toString();
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
            this.defaultImage = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        if (element instanceof IContentAreaDescriptor && ((IContentAreaDescriptor)element).getType() == 1) {
            if (PROP_AREANAME.equals(property)) {
                return true;
            }
            if (PROP_FILENAME.equals(property)) {
                return true;
            }
            if (PROP_AREATYPE.equals(property)) {
                return true;
            }
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    @Override
    public ITilesPutMap getPutMap() {
        return this.putMap;
    }

    @Override
    public void setPutMap(ITilesPutMap putInfo) {
        if (this.putMap != putInfo) {
            this.mapInDef = null;
        }
        this.putMap = putInfo;
    }

    protected Map getMapInDefinition(IFile instanceFile) {
        Object template;
        if (this.mapInDef == null && (template = this.putMap.getTemplate()) instanceof TilesDefinitionElement) {
            TilesDefinitionElement ele = (TilesDefinitionElement)template;
            TilesDefinitionUtil util = new TilesDefinitionUtil(ele.getComponent(), instanceFile);
            try {
                this.mapInDef = util.lookupPutAreaMap(ele.getDefinitionName());
            }
            finally {
                util.dispose();
            }
        }
        return this.mapInDef;
    }

    public static String getTypeLabel(String value) {
        int type = TilesConfigContentAreaUtil.getType(value);
        if (type == 2 || type == 3) {
            return ResourceHandler._UI_Tiles_Config_Content_Area_Label_Provider_0;
        }
        if (type == 4) {
            return ResourceHandler._UI_Tiles_Config_Content_Area_Label_Provider_1;
        }
        if (type == 1) {
            String nestedValue = TilesConfigContentAreaUtil.getPutDefaultContent(value);
            if (nestedValue != null) {
                nestedValue = TilesConfigContentAreaLabelProvider.getTypeLabel(nestedValue);
                return NLS.bind((String)ResourceHandler._UI_Tiles_Config_Content_Area_Label_Provider_5, (Object)nestedValue);
            }
            return ResourceHandler._UI_Tiles_Config_Content_Area_Label_Provider_2;
        }
        if (type == 5) {
            return ResourceHandler._UI_Tiles_Config_Content_Area_Label_Provider_3;
        }
        if (type == 6) {
            return ResourceHandler._UI_Tiles_Config_Content_Area_Label_Provider_4;
        }
        return "";
    }

    public static String getValueLabel(String value) {
        String nestedValue;
        int type = TilesConfigContentAreaUtil.getType(value);
        if (type == 2 || type == 3) {
            IPath path = TilesConfigContentAreaUtil.getFilePath(value);
            return path != null ? path.toString() : "";
        }
        if (type == 4) {
            return TilesConfigContentAreaUtil.getDirectText(value);
        }
        if (type == 5) {
            return TilesConfigContentAreaUtil.getDefinition(value);
        }
        if (type == 6) {
            Object[] adds = TilesConfigContentAreaUtil.getPutListContent(value);
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < adds.length) {
                if (i != 0) {
                    buf.append(", ");
                }
                Object[] addInfo = (Object[])adds[i];
                buf.append(addInfo[0]);
                ++i;
            }
            return buf.toString();
        }
        if (type == 1 && (nestedValue = TilesConfigContentAreaUtil.getPutDefaultContent(value)) != null) {
            return TilesConfigContentAreaLabelProvider.getValueLabel(nestedValue);
        }
        return "";
    }
}

