/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesFacetUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.commands.CommandLabel;
import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.InsertHeadObjectCommand;
import com.ibm.etools.webedit.common.commands.JSPRootTaglibDirectiveCommand;
import com.ibm.etools.webedit.common.commands.proxy.HTMLEditDomainCommandProxy;
import com.ibm.etools.webedit.common.commands.utils.AttributeList;
import com.ibm.etools.webedit.common.commands.utils.HeadElementModifier;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.extension.override.CommandExtensionContext;
import com.ibm.etools.webedit.extension.override.DefaultCommandExtensionContext;
import com.ibm.etools.webedit.internal.extension.OverrideActionRegistry;
import com.ibm.etools.webedit.internal.nodemodelprovider.VirtualModelNodeProvider;
import com.ibm.etools.webedit.linkfixup.LinkFixup;
import com.ibm.etools.webedit.linkfixup.ModelUtil;
import com.ibm.etools.webedit.util.HTMLTaglibDirectiveUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerEncodingHelperForSave;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.internal.tiles.commands.AddCharsetCommand;
import com.ibm.etools.webpage.template.internal.tiles.commands.TilesConvertSampleCommand;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.wizards.tiles.TilesSampleDefinitionElement;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.CodedStreamCreator;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class TilesTemplateURLFixup
implements ITilesConstants {
    public static IPath performFixup(IVirtualComponent component, IPath srcLocation, String recommendedEncoding, Shell shell) {
        IFile orgFile = WebComponent.getFileForLocation((IPath)srcLocation);
        if (orgFile != null && orgFile.getProject().equals((Object)component.getProject())) {
            return srcLocation;
        }
        TilesTemplateURLFixup fixupper = new TilesTemplateURLFixup();
        return fixupper.internalPerformFixup(component, srcLocation, recommendedEncoding, shell);
    }

    private IPath internalPerformFixup(IVirtualComponent component, IPath srcLocation, String recommendedEncoding, Shell shell) {
        if (recommendedEncoding == null) {
            recommendedEncoding = ContentTypeEncodingPreferences.getUserPreferredCharsetName((String)ContentTypeIdForHTML.ContentTypeID_HTML);
        }
        if (recommendedEncoding != null && !TemplateURLFixup.canConvertEncodingTo(srcLocation, recommendedEncoding)) {
            srcLocation = TemplateURLFixup.getEnSample(srcLocation);
        }
        IFile orgFile = WebComponent.getFileForLocation((IPath)srcLocation);
        IStructuredDocument document = this.getStructuredDocument(srcLocation);
        if (document != null) {
            IDOMModel model;
            IModelManager modelManager;
            IStructuredModel docModel;
            IFile newFile;
            block11: {
                URIResolver resolver;
                Display display;
                LinkFixup lf = new LinkFixup();
                lf.setDoCopy(true);
                lf.setDoFixup(true);
                if (orgFile != null && orgFile.getProject().exists()) {
                    lf.setValidateLinkInNewProjectForDocRootRelative(true);
                }
                IProject orgProject = orgFile != null ? orgFile.getProject() : component.getProject();
                IProject newProject = component.getProject();
                newFile = TilesTemplateURLFixup.getFixuppedFile(component, srcLocation, true);
                if (shell == null && PlatformUI.isWorkbenchRunning() && (display = Display.getCurrent()) != null) {
                    shell = display.getActiveShell();
                }
                if ((resolver = (URIResolver)orgProject.getAdapter(URIResolver.class)) == null) {
                    resolver = new ProjectResolver(orgProject);
                }
                resolver.setFileBaseLocation(srcLocation.toString());
                docModel = ModelUtil.getModel((IStructuredDocument)document, (URIResolver)resolver, (String)orgProject.toString());
                IFile virtualFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(newFile.getLocation().removeLastSegments(1).append(srcLocation.lastSegment()));
                VirtualModelNodeProvider.getInstance().addVirtualModel(virtualFile, docModel);
                boolean ret = lf.performFixup(virtualFile, docModel, orgProject, srcLocation, newProject, newFile.getLocation(), shell, true, null);
                VirtualModelNodeProvider.getInstance().removeVirualModel(virtualFile);
                modelManager = StructuredModelManager.getModelManager();
                model = null;
                if (ret) break block11;
                return null;
            }
            try {
                model = (IDOMModel)modelManager.getExistingModelForEdit(newFile);
                if (model == null) {
                    model = (IDOMModel)new ModelManagerUtil(null, null).getNewModelForEdit(newFile);
                }
                String content = docModel.getStructuredDocument().getText();
                model.getStructuredDocument().set(content);
                TilesTemplateURLFixup.convertSampleFromStaticToDynamic(component, model, srcLocation, recommendedEncoding, false);
                ModelManagerEncodingHelperForSave.save((IStructuredModel)model, (IFile)newFile, null);
            }
            catch (IOException e) {
                Logger.log((Throwable)e);
            }
            catch (CoreException ce) {
                Logger.log((Throwable)ce);
            }
            return newFile.getLocation();
        }
        return null;
    }

    public static IFile getFixuppedFile(IVirtualComponent component, IPath srcLocation, boolean createFolder) {
        IContainer baseFolder;
        block11: {
            WebComponent webComponent = new WebComponent(component);
            baseFolder = null;
            try {
                IContainer webBaseFolder = webComponent.getCSSFolder();
                if (webBaseFolder == null) break block11;
                if (!webBaseFolder.exists() && createFolder) {
                    try {
                        ((IFolder)webBaseFolder).create(true, true, null);
                    }
                    catch (CoreException coreException) {}
                }
                baseFolder = webBaseFolder;
            }
            finally {
                if (webComponent != null) {
                    webComponent.dispose();
                }
            }
        }
        if (baseFolder != null) {
            String name = srcLocation.lastSegment();
            int extIndex = name.lastIndexOf(46);
            if (extIndex > 0) {
                name = name.substring(0, extIndex);
            }
            while (true) {
                IFile file;
                if (!(file = baseFolder.getFile((IPath)new Path(String.valueOf(name) + ".jsp"))).exists()) {
                    return file;
                }
                name = String.valueOf(name) + "_";
            }
        }
        return null;
    }

    protected IStructuredDocument getStructuredDocument(IPath srcLocation) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        try {
            IFile file = WebComponent.getFileForLocation((IPath)srcLocation);
            if (file != null) {
                return modelManager.createStructuredDocumentFor(file);
            }
            FileInputStream contentStream = null;
            File subFile = srcLocation.toFile();
            contentStream = new FileInputStream(subFile);
            return modelManager.createStructuredDocumentFor(srcLocation.toString(), (InputStream)contentStream, null);
        }
        catch (IOException ioe) {
            Logger.log((Throwable)ioe);
        }
        catch (CoreException ce) {
            Logger.log((Throwable)ce);
        }
        return null;
    }

    private static HTMLCommand getTaglibInsertCommand(IVirtualComponent component, HTMLEditDomain domain, IDOMModel model) {
        boolean isStandardSyntax;
        JSPRootTaglibDirectiveCommand cmd = null;
        boolean bl = isStandardSyntax = !HTMLTaglibDirectiveUtil.isJSPDocuments((IDOMModel)model);
        if (isStandardSyntax) {
            InsertHeadObjectCommand taglibCmd = new InsertHeadObjectCommand();
            taglibCmd.setCommandTarget((HTMLCommandTarget)domain);
            String[] taglib = TilesUtil.getTilesTaglibURIAndPrefixToInsert((HTMLEditDomain)domain, (IProject)component.getProject(), (IDOMModel)model);
            taglibCmd.getDirectiveTaglibFilter(taglib[0], taglib[1]);
            cmd = taglibCmd;
        } else {
            JSPRootTaglibDirectiveCommand taglibCmd;
            Element jspRoot = HTMLTaglibDirectiveUtil.getJSPRootElement((IDOMModel)model);
            String[] taglib = TilesUtil.getTilesTaglibURIAndPrefixToInsert((HTMLEditDomain)domain, (IProject)component.getProject(), (IDOMModel)model);
            cmd = taglibCmd = new JSPRootTaglibDirectiveCommand(CommandLabel.LABEL_INSERT_HEAD_TAG, jspRoot, taglib[1], taglib[0]);
        }
        return cmd;
    }

    private void convertLinksToAbsolute(IProject project, IDOMModel model, IPath srcLocation) {
        IFile virtualFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(srcLocation.removeLastSegments(1).append(srcLocation.lastSegment()));
        if (virtualFile == null) {
            virtualFile = ResourcesPlugin.getWorkspace().getRoot().getProject(UUID.randomUUID().toString()).getFile(UUID.randomUUID().toString());
        }
        VirtualModelNodeProvider.getInstance().addVirtualModel(virtualFile, (IStructuredModel)model);
        EnumSet<ProviderArguments> args = EnumSet.of(ProviderArguments.FORCE_CONTRACT);
        args.add(ProviderArguments.LINKSTYLE_ABSOLUTE);
        SpecializedType linkType = ReferenceManager.getReferenceManager().getLinkType("web.commonlink");
        LinkNode virtualNode = ReferenceManager.getReferenceManager().getLinkNode((IResource)virtualFile);
        SharedModel shared = new SharedModel("web.node.webpage", (Object)model, virtualNode);
        Collection links = ReferenceManager.getReferenceManager().parseLinksOnly(Collections.singleton(linkType.getId()), shared, null);
        RefactoringSupport support = new RefactoringSupport();
        for (ILink link : links) {
            String linkText = ReferenceManager.getReferenceManager().expandLinkText(linkType, link.getLinkText(), link.getContainer().getResource(), args);
            String quoteChar = AbstractWebProvider.getQuoteChar((String)linkText);
            linkText = AbstractWebProvider.trimQuotes((String)linkText);
            linkText = URIUtil.makeAbsoluteURI((String)("file:////" + srcLocation.toString()), (String)linkText);
            if (linkText.indexOf("file/") >= 0) {
                linkText = "file:///" + linkText.split("file/")[1];
            }
            linkText = ReferenceManager.getReferenceManager().contractLinkText(link, linkText, args);
            if (quoteChar != null) {
                linkText = String.valueOf(quoteChar) + linkText + quoteChar;
            }
            support.createLinkTextReplaceEdits(link, linkText);
        }
        HashMap<IFile, IStructuredDocument> docMap = new HashMap<IFile, IStructuredDocument>();
        docMap.put(virtualFile, model.getStructuredDocument());
        Change change = support.createDocumentChange("Convert links", docMap);
        if (change != null) {
            change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            PerformChangeOperation op = new PerformChangeOperation(change);
            try {
                op.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        VirtualModelNodeProvider.getInstance().removeVirualModel(virtualFile);
    }

    public static void convertSampleFromStaticToDynamic(IVirtualComponent component, IDOMModel model, IPath srcLocation, String recommendedEncoding, boolean withFixupLink) {
        HTMLCommand taglibCmd;
        NodeList nodes;
        boolean hasRecommendedEncoding;
        boolean bl = hasRecommendedEncoding = recommendedEncoding != null;
        if (recommendedEncoding == null) {
            try {
                CodedStreamCreator readerForEncode = new CodedStreamCreator();
                readerForEncode.set(srcLocation.toString(), model.getStructuredDocument().get());
                EncodingMemento memento = readerForEncode.getCurrentEncodingMemento();
                recommendedEncoding = memento.getDetectedCharsetName();
            }
            catch (IOException ioe) {
                Logger.log((Throwable)ioe);
            }
            catch (CoreException ce) {
                Logger.log((Throwable)ce);
            }
        }
        HTMLEditDomainCommandProxy domain = new HTMLEditDomainCommandProxy(model);
        Range range = ((DocumentRange)model.getDocument()).createRange();
        range.setStart((Node)model.getDocument(), 0);
        range.setEnd((Node)model.getDocument(), 0);
        domain.getSelectionMediator().setRange(range);
        CompoundHTMLCommand command = new CompoundHTMLCommand("");
        command.setCommandTarget((HTMLCommandTarget)domain);
        if (withFixupLink) {
            TilesTemplateURLFixup fixupper = new TilesTemplateURLFixup();
            fixupper.convertLinksToAbsolute(component.getProject(), model, srcLocation);
        }
        if ((nodes = model.getDocument().getElementsByTagName("jsp:directive.page")) == null || nodes.getLength() <= 0 || hasRecommendedEncoding) {
            InsertHeadObjectCommand headCmd = new InsertHeadObjectCommand();
            headCmd.setCommandTarget((HTMLCommandTarget)domain);
            HeadElementModifier modifier = new HeadElementModifier();
            AttributeList changeAttrs = new AttributeList();
            changeAttrs.pushAttribute("language", "java");
            HeadElementModifier headElementModifier = modifier;
            headElementModifier.getClass();
            HeadElementModifier.DirectivePageFilter filter = new HeadElementModifier.DirectivePageFilter(headElementModifier, (Document)model.getDocument(), changeAttrs, recommendedEncoding, 1);
            headCmd.setElementFilter((HeadElementModifier.ElementFilter)filter);
            command.append((HTMLCommand)headCmd);
        }
        if (hasRecommendedEncoding) {
            AddCharsetCommand charCmd = new AddCharsetCommand("");
            charCmd.setCharsetName(recommendedEncoding);
            charCmd.setCommandTarget((HTMLCommandTarget)domain);
            command.append((HTMLCommand)charCmd);
        }
        if ((taglibCmd = TilesTemplateURLFixup.getTaglibInsertCommand(component, (HTMLEditDomain)domain, model)) != null) {
            command.append(taglibCmd);
        }
        TilesConvertSampleCommand convCmd = new TilesConvertSampleCommand("");
        convCmd.setCommandTarget((HTMLCommandTarget)domain);
        command.append((HTMLCommand)convCmd);
        DefaultCommandExtensionContext context = new DefaultCommandExtensionContext((HTMLCommandTarget)domain, (HTMLCommand)command, "command.import.sampletemplate.dynamic");
        HTMLCommand extendedCommand = OverrideActionRegistry.generateExtendedCommand((HTMLCommand)command, (CommandExtensionContext)context, (String)"command.import.sampletemplate.dynamic");
        extendedCommand.setCommandTarget((HTMLCommandTarget)domain);
        domain.execCommand((Command)extendedCommand);
    }

    public static TilesDefinitionElement performFixupAndRegisterSampleTemplate(TilesSampleDefinitionElement ele, String ianaEncoding, Shell shell) {
        try {
            TilesFacetUtil.installTilesFacet((IVirtualComponent)ele.getComponent());
        }
        catch (CoreException ce) {
            Logger.log((Throwable)ce);
            return null;
        }
        IPath fixuppedTemplate = TilesTemplateURLFixup.performFixup(ele.getComponent(), ele.getSampleLocation(), ianaEncoding, shell);
        IFile templateFile = WebComponent.getFileForLocation((IPath)fixuppedTemplate);
        TilesDefinitionUtil util = new TilesDefinitionUtil(ele.getComponent());
        try {
            util.register(ele.getDefinitionName(), TilesDefinitionUtil.getWebFilePath((IVirtualComponent)ele.getComponent(), (IFile)templateFile), null);
        }
        finally {
            util.dispose();
        }
        return new TilesDefinitionElement(ele.getDefinitionName(), templateFile);
    }

    public static String getDefaultDynamicPageTemplateName(IVirtualComponent component, IPath basePath) {
        String candidate = "templateName";
        String fileExt = basePath.getFileExtension();
        String templateName = basePath.lastSegment();
        candidate = templateName = templateName.substring(0, templateName.lastIndexOf(fileExt) - 1);
        if (component == null) {
            return candidate;
        }
        TilesDefinitionUtil util = new TilesDefinitionUtil(component);
        List<String> definitions = Arrays.asList(util.getDefinitions());
        util.dispose();
        while (definitions.contains(candidate)) {
            candidate = String.valueOf(candidate) + "_";
        }
        return candidate;
    }
}

