/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles;

import com.ibm.etools.tiles.util.TilesFacetUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.tiles.commands.TilesReplaceTemplateCommand;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.ErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.pages.operations.AbstractReplaceTemplateToMuliPageOperation;
import com.ibm.etools.webpage.template.wizards.tiles.TilesDefinitionElementFactory;
import com.ibm.etools.webpage.template.wizards.tiles.TilesSampleDefinitionElement;
import com.ibm.etools.webpage.template.wizards.tiles.TilesTemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TilesReplaceTemplateToMultiPageOperation
extends AbstractReplaceTemplateToMuliPageOperation {
    public TilesReplaceTemplateToMultiPageOperation(ContentMappingTemplateDataModel dataModel) {
        super(dataModel);
    }

    @Override
    public void doConfigComponent(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        TilesFacetUtil.installTilesFacet((IVirtualComponent)component, (IProgressMonitor)monitor);
    }

    @Override
    protected HTMLCommand generateCommand(HTMLCommandTarget commandTarget, Map map, IPath newTemplateFile) {
        Object template = this.getDataModel().getTemplate();
        if (template instanceof TilesDefinitionElement) {
            String definition = ((TilesDefinitionElement)template).getDefinitionName();
            TilesReplaceTemplateCommand command = new TilesReplaceTemplateCommand(ResourceHandler._UI_Tiles_Replace_Template_To_MultiPage_Operation_0);
            command.setDefinitionName(definition);
            command.setMap(map);
            command.setCommandTarget(commandTarget);
            return command;
        }
        return null;
    }

    @Override
    protected Object fixupTemplate(IVirtualComponent component, Object template, String ianaEncoding, Shell shell) {
        if ("".equals(ianaEncoding)) {
            ianaEncoding = null;
        }
        if (template instanceof TilesSampleDefinitionElement) {
            TilesSampleDefinitionElement ele = (TilesSampleDefinitionElement)((Object)template);
            return TilesTemplateURLFixup.performFixupAndRegisterSampleTemplate(ele, ianaEncoding, shell);
        }
        return template;
    }

    @Override
    protected ITemplateErrorInfo canChange(IDOMModel targetFileModel, IDOMModel templateFileModel, Map specifiedMapping) {
        String[] putAreaNames;
        ErrorInfo ret = new ErrorInfo();
        if (targetFileModel == null || templateFileModel == null) {
            ret.setUnexpactedError(true);
            return ret;
        }
        IDOMModel currentTemplateModel = null;
        try {
            TilesDefinitionElement ele = TilesDefinitionElementFactory.createElementFromInstanceModel(targetFileModel);
            IFile currentTemplateFile = ele.getFile();
            if (currentTemplateFile == null || !currentTemplateFile.exists()) {
                ret.setMappingError(true);
                ErrorInfo errorInfo = ret;
                return errorInfo;
            }
            currentTemplateModel = SelectRegionsUtil.getModelForRead(currentTemplateFile);
            ret.setSyntaxError(!ApplyTplUtil.checkJSPSyntax(currentTemplateModel, templateFileModel));
            ret.setEncodingError(!ApplyTplUtil.checkEncoding(currentTemplateModel, templateFileModel));
        }
        finally {
            if (currentTemplateModel != null) {
                currentTemplateModel.releaseFromRead();
                currentTemplateModel = null;
            }
        }
        if (specifiedMapping == null) {
            ret.setUnexpactedError(true);
        }
        if ((putAreaNames = TilesUtil.collectPutAreaNames((IDOMModel)targetFileModel)) == null) {
            ret.setMappingError(true);
        } else {
            List<String> contentAreasList = Arrays.asList(putAreaNames);
            if (contentAreasList != null && specifiedMapping != null) {
                Set keyset = specifiedMapping.keySet();
                if (keyset == null) {
                    ret.setMappingError(true);
                } else {
                    Iterator keyIt = keyset.iterator();
                    while (keyIt.hasNext()) {
                        if (contentAreasList.contains(keyIt.next())) continue;
                        ret.setMappingError(true);
                        break;
                    }
                }
            }
        }
        return ret;
    }
}

