/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles;

import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.tiles.ITilesConfigContentAreaConstants;
import com.ibm.etools.webpage.template.tiles.commands.TilesApplyTemplateCommand;
import com.ibm.etools.webpage.template.tiles.util.TilesConfigContentAreaUtil;
import com.ibm.etools.webpage.template.tiles.util.TilesNewFileUtil;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.ErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.tiles.ITilesPutMapInfo;
import com.ibm.etools.webpage.template.wizards.tiles.StaticToDynamicContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.tiles.TilesReplaceTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NodeList;

public class StaticToDynamicReplaceTemplateToMultiPageOperation
extends TilesReplaceTemplateToMultiPageOperation
implements ITilesConfigContentAreaConstants {
    private List newFiles = new ArrayList();

    public StaticToDynamicReplaceTemplateToMultiPageOperation(ContentMappingTemplateDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected HTMLCommand generateCommand(HTMLCommandTarget commandTarget, Map map, IPath newTemplateFile) {
        Object template = this.getDataModel().getTemplate();
        if (template instanceof TilesDefinitionElement) {
            String definition = ((TilesDefinitionElement)template).getDefinitionName();
            TilesApplyTemplateCommand command = new TilesApplyTemplateCommand(definition);
            command.setPutMap(map);
            command.setCommandTarget(commandTarget);
            return command;
        }
        return null;
    }

    @Override
    protected Map preReplaceTemplate(final HTMLCommandTarget target, Map map, IProgressMonitor monitor) {
        Object template = this.getDataModel().getFixuppedTemplate();
        if (template instanceof TilesDefinitionElement) {
            final Map contentsMap = this.getContentsMap(target.getActiveModel(), map);
            if (((ITilesPutMapInfo)((Object)this.getDataModel())).getPutValues(target.getActiveModel().getBaseLocation()) == null) {
                ((ITilesPutMapInfo)((Object)this.getDataModel())).setDefaultPutValues(target.getActiveModel().getBaseLocation(), contentsMap, this.newFiles);
            }
            final Map putMap = ((ITilesPutMapInfo)((Object)this.getDataModel())).getPutValues(target.getActiveModel().getBaseLocation());
            boolean newFile = false;
            for (Object key : putMap.keySet()) {
                Object putValue = putMap.get(key);
                if (TilesConfigContentAreaUtil.getType(putValue.toString()) != 3) continue;
                newFile = true;
                break;
            }
            if (newFile) {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        Iterator it = putMap.keySet().iterator();
                        IFile baseFile = WebComponent.getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)target.getActiveModel())));
                        while (it.hasNext()) {
                            Object key = it.next();
                            Object putValue = putMap.get(key);
                            if (TilesConfigContentAreaUtil.getType(putValue.toString()) != 3) continue;
                            IFile file = TilesDefinitionUtil.getWebFile((IFile)baseFile, (IPath)TilesConfigContentAreaUtil.getFilePath(putValue.toString()));
                            TilesNewFileUtil.createNewContentFile(target, StaticToDynamicReplaceTemplateToMultiPageOperation.this.getDataModel().getFixuppedTemplate(), monitor, file, target.getActiveModel(), (NodeList)contentsMap.get(key));
                        }
                    }
                };
                try {
                    op.run(monitor);
                }
                catch (InvocationTargetException ite) {
                    Logger.log((Throwable)ite);
                }
                catch (InterruptedException interruptedException) {}
            }
            return putMap;
        }
        return map;
    }

    public Map getContentsMap(IDOMModel sourceModel, Map map) {
        if (this.getDataModel() instanceof StaticToDynamicContentMappingTemplateDataModel) {
            StaticToDynamicContentMappingTemplateDataModel sddm = (StaticToDynamicContentMappingTemplateDataModel)this.getDataModel();
            return sddm.getSelectedAreaInfo(sourceModel, map);
        }
        return null;
    }

    @Override
    protected ITemplateErrorInfo canChange(IDOMModel targetFileModel, IDOMModel templateFileModel, Map specifiedMapping) {
        TemplateModelSession session;
        TemplateModel instanceTPL;
        List putNodeList;
        ErrorInfo ret = new ErrorInfo();
        if (targetFileModel == null || templateFileModel == null) {
            ret.setUnexpactedError(true);
            return ret;
        }
        ret.setSyntaxError(!ApplyTplUtil.checkJSPSyntax(targetFileModel, templateFileModel));
        ret.setEncodingError(!ApplyTplUtil.checkEncoding(targetFileModel, templateFileModel));
        if (specifiedMapping == null) {
            ret.setUnexpactedError(true);
        }
        if ((putNodeList = TemplateTypeUtil.collectPutNode((TemplateModel)(instanceTPL = (session = new TemplateModelSession()).getTemplateModel((IStructuredModel)targetFileModel)))) == null) {
            ret.setMappingError(true);
        } else {
            ArrayList<String> contentAreasList = new ArrayList<String>(0);
            for (TplPut putNode : putNodeList) {
                String key = putNode.getName();
                if (key == null) continue;
                contentAreasList.add(key);
            }
            if (contentAreasList != null && specifiedMapping != null) {
                Set keyset = specifiedMapping.keySet();
                if (keyset == null) {
                    ret.setMappingError(true);
                } else {
                    for (Object key : keyset) {
                        Object value;
                        if (contentAreasList.contains(key) || (value = ((StaticToDynamicContentMappingTemplateDataModel)this.getDataModel()).getSelectedArea(targetFileModel, specifiedMapping, key.toString())) != null) continue;
                        ret.setMappingError(true);
                    }
                }
            }
        }
        return ret;
    }
}

