/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.selecttpl;

import com.ibm.etools.webpage.template.FileTypeHandler;
import org.eclipse.core.resources.IFile;

public class TemplateUtil {
    private static final String ALL_FILES_EXT = "*.*";

    public static boolean checkTemplateExtensionHTPL(IFile file) {
        if (file == null) {
            return false;
        }
        String fileExtension = FileTypeHandler.getFileType((IFile)file);
        if (fileExtension == null) {
            return false;
        }
        return TemplateUtil.TemplateExtensionValiderHTPL(fileExtension);
    }

    public static boolean checkTemplateExtension(IFile file) {
        if (file == null) {
            return false;
        }
        String fileExtension = FileTypeHandler.getFileType((IFile)file);
        if (fileExtension == null) {
            return false;
        }
        return TemplateUtil.TemplateExtensionValider(fileExtension);
    }

    public static boolean checkTemplateExtensionHTPL(String fileName) {
        if (fileName == null) {
            return false;
        }
        String fileExtension = FileTypeHandler.getFileType((String)fileName);
        if (fileExtension == null) {
            return false;
        }
        return TemplateUtil.TemplateExtensionValiderHTPL(fileExtension);
    }

    public static boolean checkTemplateExtension(String fileName) {
        if (fileName == null) {
            return false;
        }
        String fileExtension = FileTypeHandler.getFileType((String)fileName);
        if (fileExtension == null) {
            return false;
        }
        return TemplateUtil.TemplateExtensionValider(fileExtension);
    }

    private static boolean TemplateExtensionValiderHTPL(String fileExtension) {
        return fileExtension.compareToIgnoreCase("htpl") == 0;
    }

    private static boolean TemplateExtensionValider(String fileExtension) {
        return fileExtension.compareToIgnoreCase("htpl") == 0 || fileExtension.compareToIgnoreCase("jtpl") == 0;
    }

    private static String generateFilterString(String[] extensions) {
        if (extensions == null || extensions.length == 0) {
            return null;
        }
        String ret = new String();
        int i = 0;
        while (i < extensions.length) {
            if (i != 0) {
                ret = String.valueOf(ret) + ";";
            }
            ret = String.valueOf(ret) + "*." + extensions[i];
            ++i;
        }
        return ret;
    }

    public static String[] getTemplateExtension() {
        String[] extensions = new String[]{"htpl", "jtpl"};
        return new String[]{TemplateUtil.generateFilterString(extensions), ALL_FILES_EXT};
    }

    public static String[] getHTPLOnlyTemplateExtension() {
        String[] extensions = new String[]{"htpl"};
        return new String[]{TemplateUtil.generateFilterString(extensions), ALL_FILES_EXT};
    }
}

