/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.selecttpl;

import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.internal.wizards.parts.HTMLPreviewControl;
import com.ibm.etools.webpage.template.wizards.selecttpl.AbstractPreviewDialog;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ModelPreviewWidget {
    private static final String MEMU_ORGSIZE = ResourceHandler._UI_MENU_ORG_SIZE;
    protected String previewLabel;
    protected String previewName;
    protected String previewShortcut;
    protected HTMLPreviewControl preview;
    protected Label previewTitle;
    protected Menu orgSizeMenu;
    protected MenuItem[] orgSizeMenuItems;
    private static String[] menuLabels = new String[]{MEMU_ORGSIZE};

    public ModelPreviewWidget(String label, String previewName, String previewShortcut) {
        this.previewLabel = label;
        this.previewName = previewName;
        this.previewShortcut = previewShortcut;
    }

    public Composite createControls(Composite parent, int previewWidth, int previewHeight, int previewStyle) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.previewTitle = new Label(composite, 0);
        this.previewTitle.setLayoutData((Object)new GridData(768));
        this.previewTitle.setText(this.previewLabel);
        this.preview = new HTMLPreviewControl(composite, 2048);
        GridData gdPreview = new GridData(previewStyle);
        gdPreview.widthHint = previewWidth;
        gdPreview.heightHint = previewHeight;
        this.preview.setLayoutData(gdPreview);
        this.preview.setName(this.previewName);
        this.preview.setShortCut(this.previewShortcut);
        this.preview.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                ModelPreviewWidget.this.fireOrgSizeMenu((TypedEvent)event);
            }
        });
        this.orgSizeMenu = new Menu((Control)this.preview.getParent());
        this.orgSizeMenuItems = new MenuItem[menuLabels.length];
        int i = 0;
        while (i < menuLabels.length) {
            this.orgSizeMenuItems[i] = new MenuItem(this.orgSizeMenu, 8);
            this.orgSizeMenuItems[i].setText(menuLabels[i]);
            this.orgSizeMenuItems[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ModelPreviewWidget.this.fireOrgSizeMenu((TypedEvent)event);
                }
            });
            ++i;
        }
        this.preview.setMenu(this.orgSizeMenu);
        return composite;
    }

    public void setModel(IDOMModel model) {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.preview.setModel(model);
        }
    }

    protected void fireOrgSizeMenu(TypedEvent e) {
        if (e.widget == null || this.preview == null) {
            return;
        }
        final ImageData imageData = this.preview.getImageData();
        if (imageData == null) {
            return;
        }
        Cursor wait = new Cursor((Device)this.preview.getDisplay(), 1);
        Image image = null;
        try {
            this.preview.setCursor(wait);
            image = new Image((Device)this.preview.getDisplay(), imageData);
        }
        finally {
            this.preview.setCursor(null);
            if (!wait.isDisposed()) {
                wait.dispose();
            }
        }
        final Image previewImage = image;
        AbstractPreviewDialog imageDialog = new AbstractPreviewDialog(this.preview.getShell(), image, this.previewName){

            @Override
            protected void paint(Graphics graphics) {
                graphics.drawImage(previewImage, 0, 0, imageData.width, imageData.height, 0, 0, imageData.width, imageData.height);
                ModelPreviewWidget.this.preview.drawFocusedNodeForPage(graphics);
            }
        };
        imageDialog.open();
        if (!image.isDisposed()) {
            image.dispose();
        }
    }

    public void setEnable(boolean enable) {
        if (this.previewTitle != null && this.preview != null) {
            this.previewTitle.setEnabled(enable);
            this.preview.setEnabled(enable);
        }
    }

    public void setFocusedNodes(List nodes) {
        if (this.preview == null) {
            return;
        }
        this.preview.setFocusedNodes(nodes);
    }

    public void disposeThumbnail() {
        if (this.preview != null) {
            this.preview.disposeThumbnail();
        }
    }

    public void updateLabels(String label, String name) {
        if (this.previewTitle != null && !this.previewTitle.isDisposed()) {
            this.previewTitle.setText(label);
            this.previewLabel = label;
        }
        if (this.preview != null && !this.preview.isDisposed()) {
            this.preview.setName(name);
            this.previewName = name;
        }
    }

    public void updateLabels(String label, String name, String shortcut) {
        if (this.previewTitle != null && !this.previewTitle.isDisposed()) {
            this.previewTitle.setText(label);
            this.previewLabel = label;
            Point newSize = this.previewTitle.computeSize(-1, -1);
            GridData data = (GridData)this.previewTitle.getLayoutData();
            data.widthHint = newSize.x;
        }
        if (this.preview != null && !this.preview.isDisposed()) {
            this.preview.setName(name);
            this.previewName = name;
            this.preview.setShortCut(shortcut);
            this.previewShortcut = shortcut;
        }
    }
}

