/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.selecttpl;

import com.ibm.iwt.thumbnail.ImageDialog;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractPreviewDialog
extends ImageDialog {
    private Image image = null;
    private String title;
    private int DEFAULT_IMAGE_SIZE_WIDTH = 500;
    private int DEFAULT_IMAGE_SIZE_HEIGHT = 500;
    private MyFigure label;
    private LayeredPane pane;

    public AbstractPreviewDialog(Shell shell, Image anImage, String title) {
        super(shell, anImage, title);
        this.title = title;
        this.image = anImage;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected final String getTitle() {
        return this.title;
    }

    protected final MyFigure getImageFigure() {
        return this.label;
    }

    protected Control createDialogArea(Composite parent) {
        int imageWidth;
        Composite contentComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        if (this.image != null && (imageWidth = this.image.getImageData().width) < 200) {
            layout.marginWidth += (200 - imageWidth) / 2;
        }
        contentComposite.setLayout((Layout)layout);
        contentComposite.setLayoutData((Object)new GridData(1808));
        FigureCanvas canvas = new FigureCanvas(contentComposite);
        GridData gdCanvas = new GridData(1808);
        gdCanvas.widthHint = this.DEFAULT_IMAGE_SIZE_WIDTH;
        gdCanvas.heightHint = this.DEFAULT_IMAGE_SIZE_HEIGHT;
        canvas.setLayoutData((Object)gdCanvas);
        canvas.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.result == null) {
                    e.result = AbstractPreviewDialog.this.getTitle();
                }
            }
        });
        canvas.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MyFigure figure = AbstractPreviewDialog.this.getImageFigure();
                figure.setIsFocused(true);
                figure.repaint();
            }

            public void focusLost(FocusEvent e) {
                MyFigure figure = AbstractPreviewDialog.this.getImageFigure();
                figure.setIsFocused(false);
                figure.repaint();
            }
        });
        canvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FigureCanvas source = (FigureCanvas)e.getSource();
                ScrollBar verticalBar = source.getVerticalBar();
                ScrollBar horizontalBar = source.getHorizontalBar();
                int destY = verticalBar != null ? verticalBar.getSelection() : 0;
                int destX = horizontalBar != null ? horizontalBar.getSelection() : 0;
                switch (e.keyCode) {
                    case 0x1000002: {
                        if (verticalBar == null) break;
                        source.scrollSmoothTo(destX, destY + verticalBar.getIncrement());
                        break;
                    }
                    case 0x1000001: {
                        if (verticalBar == null) break;
                        source.scrollSmoothTo(destX, destY - verticalBar.getIncrement());
                        break;
                    }
                    case 0x1000003: {
                        if (horizontalBar == null) break;
                        source.scrollSmoothTo(destX - horizontalBar.getIncrement(), destY);
                        break;
                    }
                    case 0x1000004: {
                        if (horizontalBar == null) break;
                        source.scrollSmoothTo(destX + horizontalBar.getIncrement(), destY);
                        break;
                    }
                    case 0x1000007: {
                        if (verticalBar != null) {
                            destY = verticalBar.getMinimum();
                        }
                        if (horizontalBar != null) {
                            destX = horizontalBar.getMinimum();
                        }
                        source.scrollSmoothTo(destX, destY);
                        break;
                    }
                    case 0x1000008: {
                        if (verticalBar != null) {
                            destY = verticalBar.getMaximum();
                        }
                        if (horizontalBar != null) {
                            destX = horizontalBar.getMaximum();
                        }
                        source.scrollSmoothTo(destX, destY);
                        break;
                    }
                    case 0x1000006: {
                        if (verticalBar == null) break;
                        source.scrollSmoothTo(destX, destY + verticalBar.getPageIncrement());
                        break;
                    }
                    case 0x1000005: {
                        if (verticalBar == null) break;
                        source.scrollSmoothTo(destX, destY - verticalBar.getPageIncrement());
                    }
                }
            }
        });
        this.pane = new LayeredPane();
        this.pane.setLayoutManager((LayoutManager)new XYLayout());
        this.label = new MyFigure();
        this.pane.add((IFigure)this.label);
        this.pane.setConstraint((IFigure)this.label, (Object)new Rectangle(0, 0, 1, 1));
        canvas.setContents((IFigure)this.pane);
        return contentComposite;
    }

    protected final void setPaneSize() {
        if (this.pane != null && this.image != null) {
            this.pane.setConstraint((IFigure)this.label, (Object)new Rectangle(0, 0, this.image.getBounds().width, this.image.getBounds().height));
        }
    }

    protected abstract void paint(Graphics var1);

    private class MyFigure
    extends Label {
        private boolean isFocused;

        private MyFigure() {
        }

        protected final boolean isFocused() {
            return this.isFocused;
        }

        protected final void setIsFocused(boolean isFocused) {
            this.isFocused = isFocused;
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            AbstractPreviewDialog.this.paint(graphics);
            AbstractPreviewDialog.this.setPaneSize();
            if (this.isFocused) {
                this.redrawFocus(graphics);
            }
        }

        private void redrawFocus(Graphics graphics) {
            Rectangle rec = this.getBounds();
            graphics.drawFocus(rec);
        }
    }
}

