/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.testpreview;

import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgCommonParts;
import com.ibm.etools.webpage.template.wizards.selecttpl.ModelPreviewWidget;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractPreviewControl
implements IMsgCommonParts {
    public static final int DELAY_MSEC = 2000;
    private Text previewLabel;
    private ModelPreviewWidget previewSource;
    private ModelPreviewWidget previewResult;
    private final String sourceLabel;
    private final String sourceName;
    private final String sourceShortCut;
    private final String resultLabel;
    private final String resultName;
    private final String resultShortCut;

    AbstractPreviewControl(String sLabel, String sName, String sShortCut, String rLabel, String rName, String rShortCut) {
        this.sourceLabel = sLabel;
        this.sourceName = sName;
        this.sourceShortCut = sShortCut;
        this.resultLabel = rLabel;
        this.resultName = rName;
        this.resultShortCut = rShortCut;
    }

    public void createControls(Composite parent) {
        this.createViewAndButton(parent);
        this.createPreview(parent);
    }

    private void createViewAndButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Control selectPane = this.createSelectPane(composite);
        GridData gdSelectPane = new GridData(1808);
        selectPane.setLayoutData((Object)gdSelectPane);
        this.createButton(composite);
    }

    protected abstract void createButton(Composite var1);

    protected abstract Control createSelectPane(Composite var1);

    private void createPreview(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        composite.setLayoutData((Object)new GridData(776));
        Label separator = new Label(composite, 258);
        GridData gdSep = new GridData(768);
        gdSep.horizontalSpan = 2;
        separator.setLayoutData((Object)gdSep);
        this.previewLabel = new Text(composite, 8);
        GridData gdLabel = new GridData(768);
        gdLabel.horizontalSpan = 2;
        this.previewLabel.setLayoutData((Object)gdLabel);
        this.previewLabel.setText(APPLY_TPL_PREVIEW_LABEL_NAME);
        this.previewLabel.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.result == null) {
                    e.result = APPLY_TPL_PREVIEW_LABEL_NAME;
                }
            }
        });
        this.previewSource = new ModelPreviewWidget(this.getSourcePreviewLabel(), this.getSourcePreviewName(), this.getSourcePreviewShortcut());
        this.previewSource.createControls(composite, 200, 200, 64);
        this.previewResult = new ModelPreviewWidget(this.getResultPreviewLabel(), this.getResultPreviewName(), this.getResultPreviewShortCut());
        this.previewResult.createControls(composite, 200, 200, 64);
    }

    protected String getSourcePreviewLabel() {
        return this.sourceLabel;
    }

    protected String getSourcePreviewName() {
        return this.sourceName;
    }

    protected String getSourcePreviewShortcut() {
        return this.sourceShortCut;
    }

    protected String getResultPreviewLabel() {
        return this.resultLabel;
    }

    protected String getResultPreviewName() {
        return this.resultName;
    }

    protected String getResultPreviewShortCut() {
        return this.resultShortCut;
    }

    protected void updatePreviewLabel(String sourcePreviewLabel, String sourcePreviewName, String resultPreviewLabel, String resultPreviewName) {
        this.previewSource.updateLabels(sourcePreviewLabel, sourcePreviewName);
        this.previewResult.updateLabels(resultPreviewLabel, resultPreviewName);
        Composite previewCompo = this.previewLabel.getParent();
        if (previewCompo != null && !previewCompo.isDisposed()) {
            previewCompo.layout();
        }
    }

    protected ModelPreviewWidget getPrevSource() {
        return this.previewSource;
    }

    protected ModelPreviewWidget getPrevResult() {
        return this.previewResult;
    }

    protected void setEnablePreview(boolean enable, boolean resultEnable) {
        this.previewLabel.setEnabled(enable);
        this.previewSource.setEnable(enable);
        this.previewResult.setEnable(enable && resultEnable);
        if (!enable) {
            this.previewSource.setModel(null);
            this.previewResult.setModel(null);
        }
    }

    public void disposeThumbnail() {
        if (this.previewSource != null) {
            this.previewSource.disposeThumbnail();
        }
        if (this.previewResult != null) {
            this.previewResult.disposeThumbnail();
        }
    }
}

