/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.testpreview;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.dialog.CannotApplyTPLDialog;
import com.ibm.etools.webpage.template.dialog.IMsgReplaceTemplateErrorInfo;
import com.ibm.etools.webpage.template.internal.wizards.WizardMessageHolder;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.ITestPreviewDataModel;
import com.ibm.etools.webpage.template.wizards.pages.composer.IApplyTplComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgCommonParts;
import com.ibm.etools.webpage.template.wizards.pages.testpreview.AbstractPreviewWithTestButton;
import com.ibm.etools.webpage.template.wizards.pages.testpreview.ErrorInfoValidationUtil;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class AbstractApplyTPLPreview
extends AbstractPreviewWithTestButton
implements IMsgCommonParts {
    protected String selectPaneLabel = APPLY_TPL_TREE_LABEL;
    protected Object selectedObjCache;
    protected boolean checkStateCache;
    protected MyUpdatePreview runnable;
    protected Map applyErrorList = new HashMap();
    private IFile displayedSourceFile;

    protected AbstractApplyTPLPreview() {
        super(APPLY_TPL_PREVIEW_SOURCE_PREVIEW, APPLY_TPL_PREVIEW_SOURCE_PREVIEW_NAME, APPLY_TPL_PREVIEW_SOURCE_PREVIEW_SHORTCUT, APPLY_TPL_PREVIEW_RESULT_PREVIEW, APPLY_TPL_PREVIEW_RESULT_PREVIEW_NAME, APPLY_TPL_PREVIEW_RESULT_PREVIEW_SHORTCUT, SHOW_ERROR_PAGES_BUTTON, SHOW_ERROR_PAGES_BUTTON_TOOLTIP, TEST_APPLY_BUTTON, TEST_APPLY_BUTTON_TOOLTIP);
    }

    protected void showApplyErrorMsg(Object selectedObj, IFile selectedFile) {
        Object obj;
        WizardMessageHolder result = new WizardMessageHolder();
        if (selectedFile != null && (obj = this.applyErrorList.get(selectedFile)) instanceof ITemplateErrorInfo) {
            result.updateMessage(ErrorInfoValidationUtil.generateWizardMessage((ITemplateErrorInfo)obj));
        }
        this.setMessageToPage(result.getMessageType(), result.getMessage(), selectedObj);
    }

    protected abstract void setMessageToPage(int var1, String var2, Object var3);

    @Override
    protected void fireShowErrorButtonPressed() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Shell shell = window.getShell();
        if (shell == null) {
            return;
        }
        Collection cl = this.applyErrorList.values();
        boolean hasError = false;
        ITemplateErrorInfo[] infoArray = null;
        if (cl != null && cl.size() != 0) {
            infoArray = cl.toArray(new ITemplateErrorInfo[cl.size()]);
            int i = 0;
            while (i < infoArray.length) {
                ITemplateErrorInfo info = infoArray[i];
                if (info.hasSomeError() && !info.isFileTemplateError()) {
                    hasError = true;
                    break;
                }
                ++i;
            }
        }
        if (hasError) {
            CannotApplyTPLDialog.openError(shell, IMsgReplaceTemplateErrorInfo.TITLE_ERROR_PAGES, IMsgReplaceTemplateErrorInfo.MSG_COULDNOT_APPLY, infoArray);
        } else {
            MessageDialog.openInformation((Shell)shell, (String)IMsgReplaceTemplateErrorInfo.TITLE_ERROR_PAGES, (String)IMsgReplaceTemplateErrorInfo.MSG_CAN_APPLY_ALL_PAGES);
        }
    }

    protected abstract void fireCheckPressed(CheckStateChangedEvent var1);

    protected abstract void fireUpdateFrag(CheckStateChangedEvent var1);

    protected void fireSelectionChanged(IFile file, boolean doApply, boolean doUpdateSource) {
        if (file != null && file.exists()) {
            this.setEnablePreview(true, doApply);
            ITestPreviewDataModel tplProxy = this.getDataModel();
            this.updatePreview(file, doApply, tplProxy, doUpdateSource);
        } else {
            if (this.runnable != null) {
                this.runnable.kill();
                this.runnable = null;
            }
            this.setEnablePreview(false, false);
            this.displayedSourceFile = null;
        }
    }

    protected final void updatePreview(IFile file, boolean doApplyTemplate, ITestPreviewDataModel dataModel, boolean doUpdateSource) {
        if (this.runnable != null) {
            this.runnable.kill();
            this.runnable = null;
        }
        this.runnable = new MyUpdatePreview(2000);
        this.runnable.init(file, doApplyTemplate, dataModel, doUpdateSource);
    }

    protected void doApplyTest(IFile selectedFile) {
        if (selectedFile == null || !selectedFile.exists()) {
            return;
        }
        ITestPreviewDataModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return;
        }
        IPath tplPath = dataModel.getTemplateLocation();
        if (tplPath == null) {
            return;
        }
        IDOMModel instanceModel = null;
        try {
            instanceModel = SelectRegionsUtil.getModelForRead(selectedFile);
            if (TemplateURLFixup.isSample(tplPath)) {
                IWizard iWiz = this.getWiz();
                if (iWiz instanceof IApplyTplComposeInfo) {
                    IApplyTplComposeInfo wizard = (IApplyTplComposeInfo)iWiz;
                    IDOMModel masterPageModel = wizard.getSourceFileModel();
                    dataModel.setMasterEncoding(WizardFileUtil.getIANAEncoding((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)masterPageModel))));
                }
            } else {
                dataModel.setMasterEncoding(WizardFileUtil.getIANAEncoding(tplPath));
            }
            ITemplateErrorInfo errorInfo = dataModel.getErrorInfo(instanceModel);
            errorInfo.setErrorFileModelProxy(new FileModelProxy(selectedFile));
            if (errorInfo.hasSomeMessage()) {
                this.applyErrorList.put(selectedFile, errorInfo);
            } else {
                this.applyErrorList.remove(selectedFile);
            }
        }
        finally {
            if (instanceModel != null) {
                instanceModel.releaseFromRead();
                instanceModel = null;
            }
        }
    }

    public abstract void doApplyTestToAll(IProgressMonitor var1) throws InterruptedException;

    public void refleshViewer() {
    }

    protected abstract ITestPreviewDataModel getDataModel();

    protected abstract void setValidateMessage(int var1, String var2);

    protected abstract IWizard getWiz();

    protected IFile getDisplayedSourceFile() {
        return this.displayedSourceFile;
    }

    protected class MyUpdatePreview
    implements Runnable {
        private int delayMSec = 0;
        private IFile file;
        private boolean doApplyTemplate;
        private ITestPreviewDataModel dataModel;
        private boolean doUpdateSource;
        private boolean killFrag;

        public MyUpdatePreview(int delayMSec) {
            this.delayMSec = delayMSec;
        }

        public void init(IFile file, boolean doApplyTemplate, ITestPreviewDataModel dataModel, boolean doUpdateSource) {
            this.file = file;
            this.doApplyTemplate = doApplyTemplate;
            this.dataModel = dataModel;
            this.doUpdateSource = doUpdateSource;
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                dsp.timerExec(this.delayMSec, (Runnable)this);
            }
        }

        public void kill() {
            this.killFrag = true;
        }

        @Override
        public void run() {
            if (this.killFrag) {
                return;
            }
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                BusyIndicator.showWhile((Display)dsp, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MyUpdatePreview.this.doUpdatePreview();
                    }
                });
            }
            AbstractApplyTPLPreview.this.displayedSourceFile = this.file;
        }

        protected void doUpdatePreview() {
            IDOMModel sourceModel = null;
            try {
                sourceModel = SelectRegionsUtil.getModelForRead(this.file);
                if (sourceModel == null) {
                    return;
                }
                if (this.doUpdateSource) {
                    AbstractApplyTPLPreview.this.getPrevSource().setModel(sourceModel);
                }
                if (this.doApplyTemplate) {
                    AbstractApplyTPLPreview.this.getPrevResult().setModel(this.dataModel.getPreviewModel(sourceModel));
                    ITemplateErrorInfo errorInfo = this.dataModel.getErrorInfo(sourceModel);
                    if (errorInfo.hasSomeMessage()) {
                        errorInfo.setErrorFileModelProxy(new FileModelProxy(this.file));
                        AbstractApplyTPLPreview.this.applyErrorList.put(this.file, errorInfo);
                        AbstractApplyTPLPreview.this.showApplyErrorMsg(AbstractApplyTPLPreview.this.selectedObjCache, this.file);
                    } else {
                        AbstractApplyTPLPreview.this.applyErrorList.remove(this.file);
                    }
                }
            }
            finally {
                if (sourceModel != null) {
                    sourceModel.releaseFromRead();
                    sourceModel = null;
                }
            }
        }
    }
}

