/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.selectmaster;

import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.dialog.SelectFileDialog;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgCommonParts;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FileSelectionWidget {
    protected String labelText;
    protected IVirtualComponent component;
    protected Control fileSelectionControl;
    protected Composite rootComposite;
    protected Object selectedObj;

    public void initWidget(String labelText, IVirtualComponent component) {
        this.labelText = labelText;
        this.component = component;
    }

    public void createControls(Composite parent) {
        this.rootComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.rootComposite.setLayout((Layout)layout);
        this.rootComposite.setLayoutData((Object)new GridData(1808));
        this.fileSelectionControl = this.createFileSelectionArea(this.rootComposite);
    }

    protected final Control createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gdLabel = new GridData(768);
        label.setLayoutData((Object)gdLabel);
        if (this.labelText != null) {
            label.setText(this.labelText);
        }
        return label;
    }

    protected Control createFileSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Composite labelAndTextCompo = new Composite(composite, 0);
        GridLayout labelAndTextLayout = new GridLayout();
        labelAndTextLayout.marginHeight = 0;
        labelAndTextLayout.marginWidth = 0;
        labelAndTextCompo.setLayout((Layout)labelAndTextLayout);
        labelAndTextCompo.setLayoutData((Object)new GridData(768));
        this.createLabel(labelAndTextCompo);
        Text text = new Text(labelAndTextCompo, 2056);
        text.setText("");
        GridData gdText = new GridData(768);
        text.setLayoutData((Object)gdText);
        Button button = new Button(composite, 8);
        button.setText(IMsgCommonParts.BROWSE_2);
        GridData gdButton = new GridData(8);
        button.setLayoutData((Object)gdButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWidget.this.fireSelectButton();
            }
        });
        return text;
    }

    protected void fireSelectButton() {
        Object selectedObj;
        if (this.component == null) {
            return;
        }
        SelectFileDialog dialog = new SelectFileDialog(this.rootComposite.getShell(), this.component);
        dialog.setAllowMultiple(false);
        dialog.setTitle("");
        dialog.setMessage("");
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    String type = FileTypeHandler.getFileType((IFile)((IFile)element));
                    return "html".equals(type) || "jsp".equals(type);
                }
                return element instanceof IContainer;
            }
        });
        if (dialog.open() == 0 && (selectedObj = dialog.getResult()[0]) instanceof IFile && this.fileSelectionControl instanceof Text) {
            IFile selectedFile = (IFile)selectedObj;
            this.selectedObj = selectedFile;
            String str = selectedFile.getProjectRelativePath().toString();
            ((Text)this.fileSelectionControl).setText(str);
        }
    }

    protected final Control getFileSelectionControl() {
        return this.fileSelectionControl;
    }

    public Text getFileSelectionText() {
        Control ret = this.getFileSelectionControl();
        if (ret instanceof Text) {
            return (Text)ret;
        }
        return null;
    }

    public Object getSelectedObj() {
        return this.selectedObj;
    }

    public void setSelectedObj(Object selectedObj) {
        this.selectedObj = selectedObj;
    }

    protected final String getLabelText() {
        return this.labelText;
    }
}

