/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.replacetpl;

import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.internal.wizards.ApplyTemplateValidationFacade;
import com.ibm.etools.webpage.template.internal.wizards.WizardMessageHolder;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.pages.composer.IReplaceTemplateComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgWizPageCommon;
import com.ibm.etools.webpage.template.wizards.pages.replacetpl.WizPageReplaceTPLSelectSource;
import com.ibm.etools.webpage.template.wizards.selecttpl.AbstractTemplateSelectionWidget;
import com.ibm.etools.webpage.template.wizards.tiles.TilesTemplateLastSelectionUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateLastSelectionUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardsInfopopIDConstant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WizPageReplaceTplSelectTpl
extends WizardPage
implements IMsgWizPageCommon {
    private IReplaceTemplateComposeInfo wizard;
    private IVirtualComponent component;
    private AbstractTemplateSelectionWidget selectPT;
    private boolean init = false;
    private boolean initSelect = false;
    private Object templateCache;

    public WizPageReplaceTplSelectTpl() {
        super(COMMON_SELECT_PT_TITLE);
        this.setTitle(COMMON_SELECT_PT_TITLE);
        this.setDescription(REPLACE_PT_WIZ_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        Object tilesSelection;
        Object selection;
        this.wizard = (IReplaceTemplateComposeInfo)this.getWizard();
        this.component = this.wizard.getComponent();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gData = new GridData(256);
        composite.setLayoutData((Object)gData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, WizardsInfopopIDConstant.SELECT_TPL_FOR_REPLACE_ID);
        boolean wizType = this.isHTPLOnly(this.wizard.getTargetFilesProxy());
        this.selectPT = new AbstractTemplateSelectionWidget(this.getShell(), this.component, wizType){

            @Override
            protected void templateSelected(Object selection) {
                WizPageReplaceTplSelectTpl.this.setTemplate(selection);
            }
        };
        this.selectPT.createControls(composite);
        this.selectPT.setAutoSelection(true);
        String wizardType = wizType ? "htpl" : "jtpl";
        IFile initialTpl = TemplateLastSelectionUtil.getLastSelection(this.component, wizardType);
        IPath iPath = selection = initialTpl == null ? null : initialTpl.getLocation();
        if (!wizType && (tilesSelection = TilesTemplateLastSelectionUtil.getLastSelection(this.wizard.getComponent())) != null) {
            selection = tilesSelection;
        }
        this.selectPT.setAndValidateInitialSelection(selection);
        this.setControl((Control)composite);
    }

    protected void setTemplate(Object template) {
        if (template == null) {
            this.wizard.setTemplate(null);
            this.setPageComplete(false);
            if (this.initSelect) {
                this.setMessage(SELECT_PT_EMPTY_MSG, 3);
            }
            this.initSelect = true;
            return;
        }
        if (this.wizard != null) {
            if (!template.equals(this.templateCache)) {
                this.templateCache = template;
                this.wizard.setTemplate(template);
            }
            this.setPageComplete(true);
        } else {
            this.wizard.setTemplate(null);
            this.setPageComplete(false);
        }
        this.validatePage();
    }

    private boolean isHTPLOnly(FileModelProxy[] files) {
        if (files == null) {
            return true;
        }
        int i = 0;
        while (i < files.length) {
            String type;
            FileModelProxy proxy = files[i];
            String src = proxy.getSrc();
            if (src != null && ("html".equals(type = FileTypeHandler.getFileType((String)src)) || "htpl".equals(type))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private WizardMessageHolder getValidateResult() {
        WizardMessageHolder result = new WizardMessageHolder();
        if (this.wizard == null) {
            result.setMessage(SELECT_PT_EMPTY_MSG, 3);
        } else if (this.wizard.getTemplateDataModel() == null || this.wizard.getTemplateDataModel().getTemplate() == null) {
            result.updateMessage(SELECT_PT_EMPTY_MSG, 3);
        } else if (this.getNextPage() instanceof WizPageReplaceTPLSelectSource) {
            result.updateMessage(ApplyTemplateValidationFacade.getInstance().validateForApply(this.wizard.getTemplateDataModel().getTemplate(), this.component));
        } else {
            result.updateMessage(ApplyTemplateValidationFacade.getInstance().validateForApply(this.wizard.getTemplateDataModel().getTemplate(), this.wizard.getSourceFileModel()));
        }
        return result;
    }

    private void validatePage() {
        WizardMessageHolder result = this.getValidateResult();
        if (result.getMessage() == WizardMessageHolder.MISSING_TEMPLATE) {
            result.setMessage(SELECT_PT_EMPTY_MSG, 3);
        }
        this.setMessage(result.getMessage(), result.getMessageType());
        this.setPageComplete(result.getMessageType() < 3);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            WizardMessageHolder result;
            IPath initialTemplatePath = this.wizard.getInitialTemplate();
            if (initialTemplatePath != null && !this.init) {
                this.selectPT.setInitialTemplateFile(initialTemplatePath);
                this.init = true;
            }
            if (!this.isPageComplete() && (result = this.getValidateResult()) != null && result.getMessage() != WizardMessageHolder.MISSING_TEMPLATE) {
                this.selectPT.setInitialTemplateFile(null);
            }
            this.setMessage(null);
        }
        super.setVisible(visible);
    }
}

