/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.replacetpl;

import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.common.utils.ValidateEditUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.dialog.ReplaceTPLTargetSelectionDialog;
import com.ibm.etools.webpage.template.dialog.TableMessageDialog;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.StaticContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.TemplateWizardDataModel;
import com.ibm.etools.webpage.template.wizards.pages.composer.IReplaceTemplateComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.composer.ISelectTplComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.composer.ReplaceTemplateComposer;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgWizPageCommon;
import com.ibm.etools.webpage.template.wizards.pages.replacetpl.WizPageReplaceTPLMapping;
import com.ibm.etools.webpage.template.wizards.pages.replacetpl.WizPageReplaceTPLSelectSource;
import com.ibm.etools.webpage.template.wizards.pages.replacetpl.WizPageReplaceTPLTest;
import com.ibm.etools.webpage.template.wizards.pages.replacetpl.WizPageReplaceTplSelectTpl;
import com.ibm.etools.webpage.template.wizards.selecttpl.TemplateFileManager;
import com.ibm.etools.webpage.template.wizards.tiles.DynamicContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.tiles.ITilesPutMapInfo;
import com.ibm.etools.webpage.template.wizards.tiles.SpecifyContentFileNamePage;
import com.ibm.etools.webpage.template.wizards.tiles.StaticToDynamicContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.tiles.StaticToDynamicReplaceTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardIconUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardsImageDescriptorUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ReplaceTPLWizard
extends Wizard
implements IReplaceTemplateComposeInfo,
IMsgWizPageCommon {
    private WizPageReplaceTplSelectTpl pageSelectPT;
    private WizPageReplaceTPLSelectSource pageSelectSource;
    private WizPageReplaceTPLMapping pageMapping;
    private WizPageReplaceTPLTest pageTest;
    private SpecifyContentFileNamePage specifyContentFileNamePage;
    protected IVirtualComponent component;
    protected FileModelProxy[] targetFilesProxyArray;
    protected FileModelProxy[] invalidFilesProxyArray;
    protected boolean hasRealizedPage = false;
    private ContentMappingTemplateDataModel dataModel;
    private IDOMModel selectedSourceFileModel = null;
    private IPath initialTemplate;
    private List replaceErrorFilesList;

    public ReplaceTPLWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WINDOW_TITLE_REPLACE_TEMPLATE);
        ImageDescriptor desc = WizardsImageDescriptorUtil.createWizbanImageDescriptor("replace_template_wizban.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean init(IVirtualComponent component, IFile[] selectedFiles) {
        return this.init(component, FileModelProxy.createFileModelProxies(selectedFiles));
    }

    protected boolean init(IVirtualComponent component, FileModelProxy[] selectedFiles) {
        this.component = component;
        ArrayList<FileModelProxy> validFilesList = new ArrayList<FileModelProxy>();
        ArrayList<FileModelProxy> invalidFilesList = new ArrayList<FileModelProxy>();
        if (selectedFiles != null) {
            int i = 0;
            while (i < selectedFiles.length) {
                FileModelProxy proxy = selectedFiles[i];
                Object template = proxy.getTemplate();
                if (template == null) {
                    invalidFilesList.add(proxy);
                } else {
                    validFilesList.add(proxy);
                }
                ++i;
            }
        }
        boolean isErrorDialog = validFilesList.size() <= 0;
        Object existingTemplate = null;
        for (FileModelProxy proxy : validFilesList) {
            Object template = proxy.getTemplate();
            if (existingTemplate == null) {
                existingTemplate = template;
                continue;
            }
            if (existingTemplate.equals(template)) continue;
            invalidFilesList.addAll(0, validFilesList);
            validFilesList.removeAll(validFilesList);
            break;
        }
        this.targetFilesProxyArray = validFilesList.toArray(new FileModelProxy[validFilesList.size()]);
        this.invalidFilesProxyArray = invalidFilesList.toArray(new FileModelProxy[invalidFilesList.size()]);
        int i = 0;
        while (i < this.targetFilesProxyArray.length) {
            if (this.targetFilesProxyArray[i].isRealized()) {
                this.hasRealizedPage = true;
                break;
            }
            ++i;
        }
        return this.openDialog(isErrorDialog);
    }

    protected final boolean openDialog(boolean isErrorDialog) {
        ArrayList<FileModelProxy> validFilesList = new ArrayList<FileModelProxy>(Arrays.asList(this.targetFilesProxyArray));
        ArrayList<FileModelProxy> invalidFilesList = new ArrayList<FileModelProxy>(Arrays.asList(this.invalidFilesProxyArray));
        if (this.targetFilesProxyArray.length < 1 && isErrorDialog) {
            MessageDialog.openError((Shell)this.getShell(), (String)WINDOW_TITLE_REPLACE_TEMPLATE, (String)ResourceHandler._UI_All_the_files_you_selected_have_no_page_template__Select_different_pages_to_replace_page_template__If_you_want_to_apply_a_page_template_to_the_pages__select___Apply_Template______from_context_menu__1);
            return false;
        }
        if (this.targetFilesProxyArray.length < 1) {
            Object[] ret = ReplaceTPLTargetSelectionDialog.openDialog(this.getShell(), WINDOW_TITLE_REPLACE_TEMPLATE, ResourceHandler._UI_The_files_selected_use_different_page_templates__You_can_only_replace_one_page_template_at_a_time__Select_the_page_template_you_want_to_replace__2, this.invalidFilesProxyArray);
            if (ret == null) {
                return false;
            }
            List<Object> retList = Arrays.asList(ret);
            validFilesList = new ArrayList(0);
            validFilesList.addAll(retList);
            int i = 0;
            while (i < ret.length) {
                invalidFilesList.remove(ret[i]);
                ++i;
            }
            this.targetFilesProxyArray = validFilesList.toArray(new FileModelProxy[validFilesList.size()]);
            this.invalidFilesProxyArray = invalidFilesList.toArray(new FileModelProxy[invalidFilesList.size()]);
            i = 0;
            while (i < this.targetFilesProxyArray.length) {
                if (this.targetFilesProxyArray[i].isRealized()) {
                    this.hasRealizedPage = true;
                    break;
                }
                ++i;
            }
            return true;
        }
        if (this.invalidFilesProxyArray.length > 0) {
            return this.openQuestionDialog();
        }
        return true;
    }

    private boolean openQuestionDialog() {
        final WizardIconUtil iconUtil = new WizardIconUtil();
        String dialogMsg = ResourceHandler._UI_Some_files_you_selected_have_no_page_templates__Do_you_replace_the_current_page_template_of_the_following_files_which_have_a_page_template_among_the_files_you_selected__3;
        TableMessageDialog dialog = TableMessageDialog.getQuestionDialog(this.getShell(), WINDOW_TITLE_REPLACE_TEMPLATE, dialogMsg, dialogMsg);
        dialog.create();
        dialog.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (iconUtil != null) {
                    iconUtil.dispose();
                }
            }
        });
        dialog.createColumn("", null, true, 0, 10, 0);
        int i = 0;
        while (i < this.targetFilesProxyArray.length) {
            FileModelProxy proxy = this.targetFilesProxyArray[i];
            TableItem tableItem = dialog.createNewTableItem();
            if (proxy.isRealized()) {
                tableItem.setImage(iconUtil.getRealizeIcon());
            } else {
                tableItem.setImage(iconUtil.getUnRealizeIcon());
            }
            String title = proxy.getTitle();
            String src = proxy.getSrc();
            tableItem.setText(String.valueOf(title) + " (" + src + ")");
            ++i;
        }
        dialog.getTable().setHeaderVisible(false);
        dialog.getTable().setLinesVisible(false);
        TableColumn[] columns = dialog.getTable().getColumns();
        if (columns != null) {
            int i2 = 0;
            while (i2 < columns.length) {
                TableColumn column = columns[i2];
                column.pack();
                ++i2;
            }
            int areaWidth = dialog.getTable().getClientArea().width;
            int i3 = 0;
            while (i3 < columns.length) {
                TableColumn column = columns[i3];
                if (column.getWidth() < areaWidth) {
                    column.setWidth(areaWidth);
                }
                ++i3;
            }
        }
        return dialog.open() == 0;
    }

    public void addPages() {
        boolean needSelectTPLPage = false;
        boolean needSelectMasterSourcePage = false;
        boolean needMappingPage = false;
        boolean needTestPage = false;
        if (this.dataModel == null) {
            needSelectTPLPage = true;
        }
        if (this.hasRealizedPage) {
            needSelectMasterSourcePage = true;
            needMappingPage = true;
            needTestPage = true;
        }
        if (this.targetFilesProxyArray != null && this.targetFilesProxyArray.length == 1) {
            needSelectMasterSourcePage = false;
            needTestPage = false;
        }
        if (this.targetFilesProxyArray != null && this.targetFilesProxyArray.length > 0) {
            this.setSourceFileModel(this.targetFilesProxyArray[0].getFile());
            this.targetFilesProxyArray[0].setApplyTemplateFlag(true);
        }
        if (needSelectTPLPage) {
            this.pageSelectPT = new WizPageReplaceTplSelectTpl();
            this.addPage((IWizardPage)this.pageSelectPT);
        }
        if (needSelectMasterSourcePage) {
            this.pageSelectSource = new WizPageReplaceTPLSelectSource();
            this.addPage((IWizardPage)this.pageSelectSource);
        }
        if (needMappingPage) {
            this.pageMapping = new WizPageReplaceTPLMapping();
            this.addPage((IWizardPage)this.pageMapping);
        }
        if (needTestPage) {
            this.pageTest = new WizPageReplaceTPLTest();
            this.addPage((IWizardPage)this.pageTest);
        }
        this.specifyContentFileNamePage = new SpecifyContentFileNamePage(){

            @Override
            protected void initializePage() {
                TemplateWizardDataModel dm = ((ISelectTplComposeInfo)this.getWizard()).getTemplateDataModel();
                if (dm instanceof ITilesPutMapInfo) {
                    ITilesPutMapInfo tdm = (ITilesPutMapInfo)((Object)dm);
                    if (this.getWizard() instanceof ISelectTplComposeInfo) {
                        ISelectTplComposeInfo info = (ISelectTplComposeInfo)this.getWizard();
                        FileModelProxy[] proxy = info.getTargetFilesProxy();
                        ArrayList newFiles = new ArrayList();
                        int i = 0;
                        while (i < proxy.length) {
                            String id;
                            if (proxy[i].isRealized() && proxy[i].isApplyTemplateFlag() && tdm.getPutValues(id = ModelManagerUtil.calculateSSEModelId((IFile)proxy[i].getFile())) == null) {
                                IDOMModel sourceModel = (IDOMModel)new ModelManagerUtil(null, null).getModelForRead(proxy[i].getFile());
                                try {
                                    ContentMappingTemplateDataModel cdm = (ContentMappingTemplateDataModel)dm;
                                    Map contentsMap = ((StaticToDynamicReplaceTemplateToMultiPageOperation)cdm.getMultiPageOperation()).getContentsMap(sourceModel, cdm.getMappingData());
                                    tdm.setDefaultPutValues(id, contentsMap, newFiles);
                                }
                                finally {
                                    if (sourceModel != null) {
                                        sourceModel.releaseFromRead();
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    this.setPutMap(tdm);
                } else {
                    this.setPutMap(null);
                }
            }
        };
        this.addPage((IWizardPage)this.specifyContentFileNamePage);
    }

    public boolean performFinish() {
        FileModelProxy[] proxies = this.getTargetFilesProxy();
        ArrayList<IFile> filesList = new ArrayList<IFile>(0);
        if (proxies != null) {
            int i = 0;
            while (i < proxies.length) {
                IFile file;
                FileModelProxy proxy = proxies[i];
                if (proxy.isApplyTemplateFlag() && (file = proxy.getFile()) != null && file.exists()) {
                    filesList.add(file);
                }
                ++i;
            }
            IFile[] fileArray = filesList.toArray(new IFile[filesList.size()]);
            if (!ValidateEditUtil.handleValidateReadOnly((IFile[])fileArray)) {
                return true;
            }
        }
        ReplaceTemplateComposer op = new ReplaceTemplateComposer(this);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Logger.log((Throwable)e);
            Throwable th = e.getTargetException();
            String msg = th.getMessage();
            if (msg != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)WINDOW_TITLE_REPLACE_TEMPLATE, (String)msg);
            }
            return true;
        }
        catch (Exception exception) {
            Logger.log((Throwable)exception);
            if (exception.getMessage() != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)WINDOW_TITLE_REPLACE_TEMPLATE, (String)exception.getMessage());
            }
            return true;
        }
        return true;
    }

    public void dispose() {
        TemplateFileManager templateFileManager;
        if (this.dataModel != null) {
            this.dataModel.releaseAllModel();
        }
        if (this.selectedSourceFileModel != null) {
            this.selectedSourceFileModel.releaseFromRead();
            this.selectedSourceFileModel = null;
        }
        if ((templateFileManager = TemplateFileManager.getInstance()) != null) {
            templateFileManager.initialize();
        }
        super.dispose();
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == null) {
            return false;
        }
        if (currentPage.getNextPage() != null) {
            return false;
        }
        return super.canFinish();
    }

    @Override
    public IVirtualComponent getComponent() {
        return this.component;
    }

    @Override
    public ContentMappingTemplateDataModel getContentMappingTemplateDataModel() {
        return this.dataModel;
    }

    @Override
    public TemplateWizardDataModel getTemplateDataModel() {
        return this.dataModel;
    }

    public void setInitialTemplate(IPath templatePath) {
        this.initialTemplate = templatePath;
    }

    @Override
    public IPath getInitialTemplate() {
        return this.initialTemplate;
    }

    @Override
    public FileModelProxy[] getInvalidFilesProxy() {
        return this.invalidFilesProxyArray;
    }

    @Override
    public FileModelProxy[] getTargetFilesProxy() {
        return this.targetFilesProxyArray;
    }

    @Override
    public IDOMModel getSourceFileModel() {
        return this.selectedSourceFileModel;
    }

    @Override
    public void setSourceFileModel(IFile file) {
        if (file == null || this.component == null) {
            return;
        }
        if (this.selectedSourceFileModel != null) {
            this.selectedSourceFileModel.releaseFromRead();
            this.selectedSourceFileModel = null;
        }
        this.selectedSourceFileModel = SelectRegionsUtil.getModelForRead(file);
        if (this.dataModel != null) {
            this.dataModel.setSourceModel(this.selectedSourceFileModel);
        }
    }

    @Override
    public List getReplaceErrorFiles() {
        return this.replaceErrorFilesList;
    }

    @Override
    public void setReplaceErrorFiles(List errorFilesList) {
        this.replaceErrorFilesList = errorFilesList;
    }

    @Override
    public void setTemplate(Object template) {
        if (this.dataModel != null) {
            this.dataModel.releaseAllModel();
            this.dataModel = null;
        }
        if (template instanceof IPath) {
            this.dataModel = new StaticContentMappingTemplateDataModel((IPath)template);
        } else if (template instanceof TilesDefinitionElement) {
            String type = TilesUtil.getTilesType((IDOMModel)this.selectedSourceFileModel);
            if ("TilesInstance".equals(type)) {
                this.dataModel = new DynamicContentMappingTemplateDataModel((TilesDefinitionElement)template);
            } else if (TemplateTypeUtil.isInstance((IStructuredModel)this.selectedSourceFileModel)) {
                this.dataModel = new StaticToDynamicContentMappingTemplateDataModel((TilesDefinitionElement)template);
            } else if (this.selectedSourceFileModel == null) {
                this.dataModel = new DynamicContentMappingTemplateDataModel((TilesDefinitionElement)template);
            }
        }
        if (this.dataModel != null) {
            this.dataModel.setSourceModel(this.selectedSourceFileModel);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == this.specifyContentFileNamePage && !(this.dataModel instanceof StaticToDynamicContentMappingTemplateDataModel)) {
            nextPage = super.getNextPage(nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage prevPage = super.getPreviousPage(page);
        if (prevPage == this.specifyContentFileNamePage && !(this.dataModel instanceof StaticToDynamicContentMappingTemplateDataModel)) {
            prevPage = super.getPreviousPage(prevPage);
        }
        return prevPage;
    }
}

