/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.operations;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.commands.ApplyTemplateCommand;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import com.ibm.etools.webpage.template.wizards.model.ApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.IApplyTemplateDataModelConstant;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.newfile.instance.GenericUtil;
import com.ibm.etools.webpage.template.wizards.pages.operations.AbstractApplyTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class StaticApplyTemplateToMultiPageOperation
extends AbstractApplyTemplateToMultiPageOperation
implements IApplyTemplateDataModelConstant {
    public StaticApplyTemplateToMultiPageOperation(ApplyTemplateDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected Object fixupTemplate(IVirtualComponent component, Object template, String ianaEncoding, Shell shell) {
        if ("".equals(ianaEncoding)) {
            ianaEncoding = null;
        }
        return TemplateURLFixup.performLinkFixup(component, (IPath)template, ianaEncoding, shell);
    }

    @Override
    protected boolean validate(IDOMModel model, IFile file, TemplateModelSession session, ITemplateErrorInfo errorInfo, boolean templateSyntax, String ianaEncoding, Map contentsMap) {
        boolean destSyntax;
        TplNode templateNode;
        if (model == null) {
            errorInfo.setUnexpactedError(true);
            return false;
        }
        boolean errorFound = false;
        TemplateModel templateModel = session.getTemplateModel(file);
        if (templateModel != null && (templateNode = TemplateModelUtil.findTemplateNodeOf((TemplateModel)templateModel)) != null) {
            errorInfo.setFileTemplateError(true);
            errorFound = true;
        }
        if (templateSyntax != (destSyntax = WizardFileUtil.isXMLSyntaxJSP(file.getLocation()))) {
            errorInfo.setSyntaxError(true);
            errorFound = true;
        }
        if (contentsMap == null || contentsMap.size() <= 0) {
            errorInfo.setMappingError(true);
            errorFound = true;
        }
        if (!this.checkEncoding(ianaEncoding, file)) {
            errorInfo.setEncodingError(true);
            errorFound = true;
        }
        return !errorFound;
    }

    @Override
    protected HTMLCommand generateCommand(HTMLCommandTarget target, Map contentsMap) {
        ApplyTemplateCommand applyCommand = new ApplyTemplateCommand();
        FileURL templateFileURL = new FileURL((IPath)this.getDataModel().getFixuppedTemplate());
        applyCommand.setNewTemplateFileURL(templateFileURL);
        applyCommand.setContentsMap(contentsMap);
        applyCommand.setCommandTarget(target);
        List commandsForApply = GenericUtil.createCommandsForApply((HTMLCommand)applyCommand, templateFileURL.getPath(), target.getActiveModel());
        CompoundHTMLCommand compCommand = new CompoundHTMLCommand(applyCommand.getLabel(), commandsForApply);
        compCommand.setCommandTarget(target);
        return compCommand;
    }

    @Override
    protected void preApplyTemplate(HTMLCommandTarget target, Map contentsMap) {
    }

    @Override
    public void doConfigComponent(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        TemplatePlugin.getDefault().addTemplateFacetAndNature(component.getProject(), monitor);
    }
}

