/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.operations;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.proxy.HTMLEditDomainCommandProxy;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.extension.override.CommandExtensionContext;
import com.ibm.etools.webedit.internal.extension.OverrideActionRegistry;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.wizards.model.ApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.ErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.IApplyTemplateDataModelConstant;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.TemplateCommandExtensionContext;
import com.ibm.etools.webpage.template.wizards.model.TemplateForCommands;
import com.ibm.etools.webpage.template.wizards.pages.operations.IApplyTemplateToMultipageOperation;
import com.ibm.etools.webpage.template.wizards.util.NodeListImpl;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.html.core.internal.modelquery.DocumentQuery;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public abstract class AbstractApplyTemplateToMultiPageOperation
implements IApplyTemplateToMultipageOperation,
IApplyTemplateDataModelConstant {
    private ArrayList IErrorFileList = null;
    private ApplyTemplateDataModel dataModel;

    public AbstractApplyTemplateToMultiPageOperation(ApplyTemplateDataModel dataModel) {
        this.dataModel = dataModel;
    }

    protected ApplyTemplateDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public int checkMapping(IDOMModel model) {
        boolean noMap = false;
        if (model == null || this.dataModel == null) {
            return 2;
        }
        Map selectedAreaInfo = this.dataModel.getSelectedAreaInfo();
        noMap = selectedAreaInfo == null;
        HashMap area = this.getArea(selectedAreaInfo);
        noMap = area == null;
        Map contentsMap = selectedAreaInfo;
        boolean[] exactMatch = new boolean[]{true};
        if (!(noMap || (contentsMap = this.getContentsMap(model, area, exactMatch)) != null && contentsMap.size() > 0)) {
            return 2;
        }
        return exactMatch[0] ? 0 : 1;
    }

    protected HashMap getArea(Map selectedAreaInfo) {
        HashMap area = new HashMap();
        if (area == null) {
            return null;
        }
        for (String key : selectedAreaInfo.keySet()) {
            List originalList = (List)selectedAreaInfo.get(key);
            if (originalList == null) continue;
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            int num = originalList.size();
            int i = 0;
            while (i < num) {
                block10: {
                    Node originalNode = (Node)originalList.get(i);
                    if (originalNode != null) {
                        ArrayList<Object> al = new ArrayList<Object>();
                        String tag = originalNode.getNodeName();
                        al.add(tag);
                        Node child = originalNode;
                        if (child.getParentNode() == null) {
                            al.add(new Integer(1));
                            al.add(new Integer(0));
                            list.add(al);
                        } else {
                            Node parent = child.getParentNode();
                            while (parent != null) {
                                int idx;
                                ArrayList nodes = AbstractApplyTemplateToMultiPageOperation.getNodesByTagName(parent, tag);
                                if (nodes != null && (idx = AbstractApplyTemplateToMultiPageOperation.getNodeIndex(nodes, child)) >= 0) {
                                    al.add(new Integer(nodes.size()));
                                    al.add(new Integer(idx));
                                    if (parent.getNodeType() == 1 && !(tag = ((Element)parent).getTagName()).startsWith("tpl:")) {
                                        al.add(tag);
                                    }
                                    child = parent;
                                    parent = child.getParentNode();
                                    continue;
                                }
                                break block10;
                            }
                            list.add(al);
                        }
                    }
                }
                ++i;
            }
            if (list.size() <= 0) continue;
            int depth = this.getCommonPathDepth(list);
            Integer dep = new Integer(depth);
            list.add(dep);
            area.put(key, list);
        }
        if (area.size() > 0) {
            return area;
        }
        return null;
    }

    private static ArrayList getNodesByTagName(Node parent, String tag) {
        EditModelQuery query;
        if (tag.equals("#document") && parent.getNodeType() == 9 && (query = EditQueryUtil.getEditQuery((Node)parent)).isFragment((Document)parent)) {
            ArrayList<Node> list = new ArrayList<Node>();
            list.add(parent);
            return list;
        }
        NodeList nl = parent.getChildNodes();
        if (nl == null) {
            return null;
        }
        int num = nl.getLength();
        if (num <= 0) {
            return null;
        }
        ArrayList<Node> al = new ArrayList<Node>();
        int i = 0;
        while (i < num) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && n.getNodeName() != null && n.getNodeName().equalsIgnoreCase(tag)) {
                al.add(n);
            }
            ++i;
        }
        if (al.size() == 0) {
            return null;
        }
        return al;
    }

    private static int getNodeIndex(ArrayList al, Node n) {
        int num = al.size();
        int i = 0;
        while (i < num) {
            if (al.get(i) == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getCommonPathDepth(ArrayList origList) {
        ArrayList list = new ArrayList(origList);
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof ArrayList && o2 instanceof ArrayList) {
                    int size1 = ((ArrayList)o1).size();
                    int size2 = ((ArrayList)o2).size();
                    return size1 - size2;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
        int lnum = list.size();
        if (lnum <= 0) {
            return 0;
        }
        ArrayList al0 = (ArrayList)list.get(0);
        if (al0 == null || al0.size() <= 0) {
            return 0;
        }
        int num = al0.size();
        if (lnum == 1) {
            return num;
        }
        int depth = 0;
        int ii = 0;
        block0: while (ii < num) {
            int i = num - ii - 1;
            Object o0 = al0.get(i);
            int idx0 = 0;
            int size0 = 0;
            if (o0 == null) break;
            if (o0 instanceof Integer) {
                idx0 = (Integer)o0;
                if (!((o0 = al0.get(--i)) instanceof Integer)) break;
                size0 = (Integer)o0;
                o0 = al0.get(--i);
            }
            if (idx0 < 0 || size0 < 0 || !(o0 instanceof String)) break;
            int k = 1;
            while (k < lnum) {
                ArrayList alk = (ArrayList)list.get(k);
                if (alk == null || alk.size() <= 0) {
                    depth = 0;
                    break block0;
                }
                int numk = alk.size();
                int j = numk - ii - 1;
                if (j < 2) break block0;
                Object ok = alk.get(j);
                int idxk = 0;
                int sizek = 0;
                if (ok == null) break block0;
                if (ok instanceof Integer) {
                    idxk = (Integer)ok;
                    if (!((ok = alk.get(--j)) instanceof Integer)) break block0;
                    sizek = (Integer)ok;
                    ok = alk.get(--j);
                }
                if (idxk != idx0 || sizek != size0 || !(ok instanceof String) || !((String)ok).equalsIgnoreCase((String)o0)) break block0;
                ++k;
            }
            depth = ii;
            ii += 3;
        }
        return depth;
    }

    public HashMap getContentsMap(IDOMModel model, Map area, boolean[] exactMatch) {
        IDOMDocument doc;
        if (model == null || this.dataModel == null) {
            return null;
        }
        if (area == null) {
            area = this.getArea(this.dataModel.getSelectedAreaInfo());
        }
        if ((doc = model.getDocument()) == null) {
            return null;
        }
        HashMap<String, NodeListImpl> contentsMap = new HashMap<String, NodeListImpl>();
        if (area == null) {
            return contentsMap;
        }
        for (String key : area.keySet()) {
            List can;
            ArrayList list = (ArrayList)area.get(key);
            if (list == null || list.size() <= 0 || (can = this.dataModel.getCanMapping(key)) == null) continue;
            int lnum = list.size() - 1;
            int depth = 0;
            Object dep = list.get(lnum);
            if (dep instanceof Integer) {
                depth = (Integer)dep;
            }
            NodeListImpl retNodes = new NodeListImpl();
            int k = 0;
            block1: while (k < lnum) {
                ArrayList al = (ArrayList)list.get(k);
                if (al == null || al.size() <= 0) {
                    retNodes = null;
                    break;
                }
                int num = al.size();
                Object n = doc;
                int i = num - 1;
                while (i >= 0) {
                    Object o = al.get(i);
                    int idx = 0;
                    int size = 0;
                    if (o == null) {
                        retNodes = null;
                        break block1;
                    }
                    if (o instanceof Integer) {
                        idx = (Integer)o;
                        if ((o = al.get(--i)) instanceof Integer) {
                            size = (Integer)o;
                            o = al.get(--i);
                        } else {
                            retNodes = null;
                            break block1;
                        }
                    }
                    if (idx < 0 || size < 0) {
                        retNodes = null;
                        break block1;
                    }
                    if (!(o instanceof String)) {
                        retNodes = null;
                        break block1;
                    }
                    ArrayList nodes = null;
                    Node child = n.getFirstChild();
                    nodes = child != null ? (child.getNodeType() == 1 && ((Element)child).getTagName().startsWith("tpl:") ? AbstractApplyTemplateToMultiPageOperation.getNodesByTagName(child, (String)o) : AbstractApplyTemplateToMultiPageOperation.getNodesByTagName((Node)n, (String)o)) : null;
                    if (nodes == null || nodes.size() != size || nodes.size() <= idx) {
                        retNodes = null;
                        break block1;
                    }
                    n = (Node)nodes.get(idx);
                    if (n == null || !n.getNodeName().equalsIgnoreCase((String)o)) {
                        retNodes = null;
                        break block1;
                    }
                    --i;
                }
                Object type = can.get(k);
                if (ApplyTemplateDataModel.isSelf(type)) {
                    retNodes.add((Node)n);
                } else if (ApplyTemplateDataModel.isChildren(type)) {
                    if (n instanceof Document) {
                        Document document = (Document)n;
                        EditModelQuery query = EditQueryUtil.getEditQuery((Node)document);
                        DocumentQuery.InsertionTarget target = query.getPageInsertionTarget(document);
                        Node startSibling = target.getRef();
                        while (startSibling != null) {
                            retNodes.add(startSibling);
                            startSibling = startSibling.getNextSibling();
                        }
                    } else {
                        retNodes.addAll(n.getChildNodes());
                    }
                    if ((retNodes == null || retNodes.getLength() <= 0) && depth > 6) {
                        depth -= 6;
                    }
                }
                ++k;
            }
            if ((retNodes == null || retNodes.getLength() <= 0) && depth > 0) {
                Node nn = AbstractApplyTemplateToMultiPageOperation.getCommonNode((Document)doc, list, depth);
                if (nn == null) {
                    return null;
                }
                Integer check = AbstractApplyTemplateToMultiPageOperation.checkCanMapping(this.dataModel, nn, key, model);
                while (!ApplyTemplateDataModel.isValid(check)) {
                    if ((nn = nn.getParentNode()) == null) break;
                    check = AbstractApplyTemplateToMultiPageOperation.checkCanMapping(this.dataModel, nn, key, model);
                }
                if (nn != null) {
                    retNodes = new NodeListImpl();
                    if (ApplyTemplateDataModel.isSelf(check)) {
                        exactMatch[0] = false;
                        retNodes.add(nn);
                    } else if (ApplyTemplateDataModel.isChildren(check)) {
                        EditModelQuery query;
                        exactMatch[0] = false;
                        retNodes.addAll(nn.getChildNodes());
                        if (retNodes.getLength() <= 0 && ((query = EditQueryUtil.getEditQuery((Node)nn)).isRenderRoot(nn) || query.isHeadCorrespondent(nn))) {
                            exactMatch[0] = false;
                            retNodes.add(nn);
                        }
                    }
                }
            }
            if (retNodes != null && retNodes.getLength() > 0) {
                contentsMap.put(key, retNodes);
                continue;
            }
            return null;
        }
        return contentsMap;
    }

    private static Node getCommonNode(Document doc, ArrayList list, int depth) {
        ArrayList al = (ArrayList)list.get(0);
        if (al == null || al.size() <= 0) {
            return null;
        }
        int num = al.size();
        if ((depth += 3) > num) {
            depth = num;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)doc);
        Node n = doc;
        int ii = 0;
        while (ii < depth) {
            int i = num - ii - 1;
            Object o = al.get(i);
            int idx = 0;
            int size = 0;
            if (o == null) break;
            if (o instanceof Integer) {
                idx = (Integer)o;
                if (!((o = al.get(--i)) instanceof Integer)) break;
                size = (Integer)o;
                o = al.get(--i);
            }
            if (idx < 0 || size < 0 || !(o instanceof String)) break;
            ArrayList nodes = null;
            Node child = n.getFirstChild();
            nodes = child != null ? (child.getNodeType() == 1 && ((Element)child).getTagName().startsWith("tpl:") ? AbstractApplyTemplateToMultiPageOperation.getNodesByTagName(child, (String)o) : AbstractApplyTemplateToMultiPageOperation.getNodesByTagName(n, (String)o)) : null;
            if (nodes == null || nodes.size() != size || nodes.size() <= idx) {
                if (!((String)o).equalsIgnoreCase(query.getBodyElementName(doc)) && !((String)o).equalsIgnoreCase(query.getHeadElementName(doc)) && !((String)o).equalsIgnoreCase(query.getHtmlElementName(doc)) && n.getNodeType() != 9) break;
                return null;
            }
            Node nn = (Node)nodes.get(idx);
            if (nn == null) {
                if (!((String)o).equalsIgnoreCase(query.getBodyElementName(doc)) && !((String)o).equalsIgnoreCase(query.getHeadElementName(doc)) && !((String)o).equalsIgnoreCase(query.getHtmlElementName(doc)) && n.getNodeType() != 9) break;
                return null;
            }
            n = nn;
            ii += 3;
        }
        return n;
    }

    private static Integer checkCanMapping(ApplyTemplateDataModel dataModel, Node selectedNode, String selectedContentArea, IDOMModel originalModel) {
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)selectedNode);
        if (query.isRenderRoot(selectedNode) || query.isHeadCorrespondent(selectedNode)) {
            return CANCONTAIN_CHILDREN;
        }
        return dataModel.checkCanMapping(selectedNode, selectedContentArea, originalModel);
    }

    @Override
    public void doApplyTemplate(IVirtualComponent component, ArrayList fileList, Shell shell, IProgressMonitor monitor) {
        if (component == null || this.dataModel == null) {
            return;
        }
        IPath path = this.dataModel.getTemplateLocation();
        String ianaEncoding = null;
        if (TemplateURLFixup.isSample(path)) {
            IDOMModel model = this.dataModel.getCopyModel();
            if (model != null) {
                ianaEncoding = SelectRegionsUtil.getIANAEncoding(model);
            }
        } else {
            ianaEncoding = WizardFileUtil.getIANAEncoding(path);
        }
        Object fixuppedTemplate = this.fixupTemplate(component, this.dataModel.getTemplate(), ianaEncoding, shell);
        this.dataModel.setFixuppedTemplate(fixuppedTemplate);
        if (this.dataModel.getFixuppedTemplate() == null) {
            return;
        }
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        IPath location = SelectRegionsUtil.getTemplateLocation(this.dataModel.getFixuppedTemplate());
        boolean templateSyntax = WizardFileUtil.isXMLSyntaxJSP(location);
        this.IErrorFileList = new ArrayList();
        Map selectedAreaInfo = this.dataModel.getSelectedAreaInfo();
        HashMap area = this.getArea(selectedAreaInfo);
        int targetSize = fileList.size();
        int i = 0;
        while (i < targetSize) {
            if (fileList.get(i) instanceof IFile) {
                IFile iFile = (IFile)fileList.get(i);
                this.doApplyTemplate(iFile, area, monitor, templateSyntax, ianaEncoding);
            }
            ++i;
        }
    }

    protected void doApplyTemplate(IFile iFile, Map area, IProgressMonitor monitor, boolean templateSyntax, String ianaEncoding) {
        ErrorInfo errorInfo = new ErrorInfo();
        TemplateModelSession session = new TemplateModelSession();
        if (monitor.isCanceled()) {
            errorInfo.setErrorFileModelProxy(new FileModelProxy(iFile));
            this.IErrorFileList.add(errorInfo);
            return;
        }
        monitor.subTask(iFile.getProjectRelativePath().toString());
        IDOMModel model = null;
        boolean[] exactMatch = new boolean[]{true};
        try {
            HTMLCommand command;
            boolean errorFound;
            model = SelectRegionsUtil.getModelForEdit(iFile);
            Map contentsMap = this.dataModel.getSelectedAreaInfo();
            if (contentsMap != null && area != null) {
                contentsMap = this.getContentsMap(model, area, exactMatch);
            }
            boolean bl = errorFound = !this.validate(model, iFile, session, errorInfo, templateSyntax, ianaEncoding, contentsMap);
            if (errorFound) {
                if (model != null) {
                    model.releaseFromEdit();
                    model = null;
                }
                if (this.IErrorFileList == null) {
                    this.IErrorFileList = new ArrayList();
                }
                errorInfo.setErrorFileModelProxy(new FileModelProxy(iFile));
                this.IErrorFileList.add(errorInfo);
                monitor.worked(1);
                return;
            }
            HTMLEditDomainCommandProxy commandTarget = new HTMLEditDomainCommandProxy(model);
            Range range = ((DocumentRange)model.getDocument()).createRange();
            range.setStart((Node)model.getDocument(), 0);
            range.collapse(true);
            commandTarget.getSelectionMediator().setRange(range);
            this.preApplyTemplate((HTMLCommandTarget)commandTarget, contentsMap);
            HTMLCommand baseCommand = command = this.generateCommand((HTMLCommandTarget)commandTarget, contentsMap);
            while (baseCommand instanceof CompoundHTMLCommand) {
                baseCommand = (HTMLCommand)((CompoundHTMLCommand)baseCommand).getCommandList().get(0);
            }
            command = OverrideActionRegistry.generateExtendedCommand((HTMLCommand)command, (CommandExtensionContext)new TemplateCommandExtensionContext((HTMLCommandTarget)commandTarget, baseCommand, new TemplateForCommands(this.getDataModel().getFixuppedTemplate()), "pagetemplate.applytemplate"), (String)"pagetemplate.applytemplate");
            command.setCommandTarget((HTMLCommandTarget)commandTarget);
            try {
                command.execute();
            }
            catch (Exception e) {
                Logger.log((Throwable)e);
                if (this.IErrorFileList == null) {
                    this.IErrorFileList = new ArrayList();
                }
                errorInfo.setErrorFileModelProxy(new FileModelProxy(iFile));
                errorInfo.setCommandError(true);
                this.IErrorFileList.add(errorInfo);
                model.releaseFromEdit();
                model = null;
                monitor.worked(1);
                if (model != null && model.getReferenceCountForEdit() > 0) {
                    model.releaseFromEdit();
                    model = null;
                }
                if (session != null) {
                    session.clearModel(iFile);
                }
                return;
            }
            if (model.getReferenceCountForEdit() != 1) {
                model.releaseFromEdit();
                model = null;
                monitor.worked(1);
                return;
            }
            try {
                model.save(iFile, EncodingRule.IGNORE_CONVERSION_ERROR);
            }
            catch (Exception e) {
                Logger.log((Throwable)e);
                if (this.IErrorFileList == null) {
                    this.IErrorFileList = new ArrayList();
                }
                errorInfo.setErrorFileModelProxy(new FileModelProxy(iFile));
                errorInfo.setUnexpactedError(true);
                this.IErrorFileList.add(errorInfo);
            }
            model.releaseFromEdit();
            model = null;
            monitor.worked(1);
        }
        finally {
            if (model != null && model.getReferenceCountForEdit() > 0) {
                model.releaseFromEdit();
                model = null;
            }
            if (session != null) {
                session.clearModel(iFile);
            }
        }
    }

    protected abstract void preApplyTemplate(HTMLCommandTarget var1, Map var2);

    protected abstract HTMLCommand generateCommand(HTMLCommandTarget var1, Map var2);

    protected abstract boolean validate(IDOMModel var1, IFile var2, TemplateModelSession var3, ITemplateErrorInfo var4, boolean var5, String var6, Map var7);

    protected abstract Object fixupTemplate(IVirtualComponent var1, Object var2, String var3, Shell var4);

    protected boolean checkEncoding(String destEncoding, IFile file) {
        return file != null && this.checkEncoding(destEncoding, file.getLocation());
    }

    protected boolean checkEncoding(String destEncoding, IPath path) {
        return path != null && this.checkEncoding(destEncoding, WizardFileUtil.getIANAEncoding(path));
    }

    protected boolean checkEncoding(String destEncoding, String encoding) {
        return destEncoding != null && destEncoding.equalsIgnoreCase(encoding);
    }

    @Override
    public Map getContentsMap(IDOMModel model) {
        boolean[] exactMatch;
        HashMap areaMap = this.getArea(this.dataModel.getSelectedAreaInfo());
        Map nodeListForPreview = this.getContentsMap(model, areaMap, exactMatch = new boolean[]{true});
        if (nodeListForPreview == null) {
            nodeListForPreview = Collections.EMPTY_MAP;
        }
        HashMap mapping = new HashMap(nodeListForPreview);
        for (Map.Entry entry : nodeListForPreview.entrySet()) {
            String contentAreaName = (String)entry.getKey();
            NodeList contentAreaValue = (NodeList)entry.getValue();
            ArrayList<Node> nodes = null;
            if (contentAreaValue != null && contentAreaValue.getLength() > 0) {
                nodes = new ArrayList<Node>(contentAreaValue.getLength());
                int i = 0;
                while (i < contentAreaValue.getLength()) {
                    nodes.add(contentAreaValue.item(i));
                    ++i;
                }
            }
            mapping.put(contentAreaName, nodes);
        }
        return mapping;
    }

    @Override
    public List getErrorFileList() {
        ArrayList<IFile> errorFiles = new ArrayList<IFile>();
        if (this.IErrorFileList != null) {
            for (Object obj : this.IErrorFileList) {
                IFile errorFile;
                FileModelProxy proxy;
                ITemplateErrorInfo info;
                if (!(obj instanceof ITemplateErrorInfo) || (info = (ITemplateErrorInfo)obj) == null || (proxy = info.getErrorFileModelProxy()) == null || (errorFile = proxy.getFile()) == null) continue;
                errorFiles.add(errorFile);
            }
        }
        return errorFiles;
    }
}

