/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.fixtpl;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.commands.PageTemplateCommandUtil;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.pages.composer.ReplaceTemplateComposer;
import com.ibm.etools.webpage.template.wizards.pages.fixtpl.WizPageFixTPLMapping;
import com.ibm.etools.webpage.template.wizards.pages.fixtpl.WizPageFixTPLSelectSource;
import com.ibm.etools.webpage.template.wizards.pages.fixtpl.WizPageFixTPLTest;
import com.ibm.etools.webpage.template.wizards.pages.replacetpl.ReplaceTPLWizard;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardsImageDescriptorUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FixTPLWizard
extends ReplaceTPLWizard {
    private WizPageFixTPLSelectSource pageSelectSource;
    protected WizPageFixTPLMapping pageMapping;
    private WizPageFixTPLTest pageTest;

    public FixTPLWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(ResourceHandler._UI_Fix_Unmatched_Content_Area_1);
        ImageDescriptor desc = WizardsImageDescriptorUtil.createWizbanImageDescriptor("conflict_template_wizban.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    @Override
    public void addPages() {
        boolean needSelectMasterSourcePage = true;
        boolean needMappingPage = true;
        boolean needTestPage = true;
        if (this.targetFilesProxyArray != null && this.targetFilesProxyArray.length == 1) {
            needSelectMasterSourcePage = false;
            needTestPage = false;
            this.setSourceFileModel(this.targetFilesProxyArray[0].getFile());
            this.targetFilesProxyArray[0].setApplyTemplateFlag(true);
        }
        if (needSelectMasterSourcePage) {
            this.pageSelectSource = new WizPageFixTPLSelectSource();
            this.addPage((IWizardPage)this.pageSelectSource);
        }
        if (needMappingPage) {
            this.pageMapping = new WizPageFixTPLMapping();
            this.addPage((IWizardPage)this.pageMapping);
        }
        if (needTestPage) {
            this.pageTest = new WizPageFixTPLTest();
            this.addPage((IWizardPage)this.pageTest);
        }
    }

    @Override
    public boolean init(IVirtualComponent component, IFile[] selectedFiles) {
        this.component = component;
        ArrayList<FileModelProxy> validFilesList = new ArrayList<FileModelProxy>();
        ArrayList<FileModelProxy> invalidFilesList = new ArrayList<FileModelProxy>();
        IPath tplPath = null;
        int i = 0;
        while (i < selectedFiles.length) {
            IPath path;
            IDOMModel model = this.getModelForEdit(selectedFiles[i]);
            IPath iPath = path = TemplateTypeUtil.getTemplateFileOf((IStructuredModel)model) != null ? TemplateTypeUtil.getTemplateFileOf((IStructuredModel)model).getFullPath() : null;
            if (model != null && PageTemplateCommandUtil.isValidModel((IDOMModel)model)) {
                FileModelProxy proxy = new FileModelProxy(selectedFiles[i]);
                TemplateModelSession session = new TemplateModelSession();
                TemplateModel tplModel = session.getTemplateModel((IStructuredModel)model);
                model.releaseFromEdit();
                if (TemplateModelUtil.findTemplateNodeOf((TemplateModel)tplModel) == null) {
                    invalidFilesList.add(proxy);
                } else if (tplPath == null) {
                    tplPath = path;
                    validFilesList.add(proxy);
                } else if (!tplPath.equals((Object)path)) {
                    invalidFilesList.add(proxy);
                } else {
                    validFilesList.add(proxy);
                }
            }
            ++i;
        }
        this.targetFilesProxyArray = validFilesList.toArray(new FileModelProxy[validFilesList.size()]);
        this.invalidFilesProxyArray = invalidFilesList.toArray(new FileModelProxy[invalidFilesList.size()]);
        if (this.targetFilesProxyArray.length < 1) {
            if (selectedFiles.length == 1) {
                String msg = NLS.bind((String)ResourceHandler._UI__0__does_not_have_a_page_template__1, (Object)selectedFiles[0].getName());
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ResourceHandler._UI_Fix_Unmatched_Content_Area_1, (String)msg);
            } else {
                Integer int_l = new Integer(selectedFiles.length);
                String msg_2 = NLS.bind((String)ResourceHandler._UI_These__0__files_do_not_have_page_templates__2, (Object)int_l);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ResourceHandler._UI_Fix_Unmatched_Content_Area_1, (String)msg_2);
            }
            return false;
        }
        if (this.invalidFilesProxyArray.length > 0) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ResourceHandler._UI_Fix_Unmatched_Content_Area_1, (String)ResourceHandler._UI_Invalid_selection__5);
            return false;
        }
        IFile targetFile = this.targetFilesProxyArray[0].getFile();
        Object template = ApplyTplUtil.getTemplateOfInstance(targetFile);
        if (template instanceof IFile) {
            template = ((IFile)template).getLocation();
        }
        this.setTemplate(template);
        this.setSourceFileModel(targetFile);
        return true;
    }

    @Override
    public boolean performFinish() {
        ReplaceTemplateComposer op = new ReplaceTemplateComposer(this);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (Exception exception) {
            Logger.log((Throwable)exception);
            if (exception.getMessage() != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler._UI_Fix_Unmatched_Content_Area_1, (String)exception.getMessage());
            }
            return true;
        }
        return true;
    }

    private IDOMModel getModelForEdit(IFile file) {
        ModelManagerUtil mmu = new ModelManagerUtil(null, null);
        IStructuredModel structuredModel = mmu.getModelForEdit(file);
        if (!ModelManagerUtil.isHTMLFamily((IStructuredModel)structuredModel) && structuredModel != null) {
            structuredModel.releaseFromEdit();
            return null;
        }
        return (IDOMModel)structuredModel;
    }
}

