/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.composer;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.pages.composer.IApplyTplComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgComposer;
import com.ibm.etools.webpage.template.wizards.pages.operations.IApplyTemplateToMultipageOperation;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateLastSelectionUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class ApplyTplComposer
extends WorkspaceModifyOperation
implements IMsgComposer {
    private IApplyTplComposeInfo info;

    public ApplyTplComposer(IApplyTplComposeInfo info) {
        this.info = info;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(PROGRESS_STATE_APPLY_TEMPLATE, 3000);
            if (this.info == null) {
                return;
            }
            IApplyTemplateToMultipageOperation applyTemplate = this.info.getApplyTemplateDataModel().getMultiPageOperation();
            applyTemplate.doConfigComponent(this.info.getComponent(), monitor);
            this.processApplyTemplate(applyTemplate, monitor);
            IFile tplFile = SelectRegionsUtil.getTemplateFile(this.info.getComponent(), this.info.getTemplateDataModel().getFixuppedTemplate());
            if (FileTypeHandler.getFileType((IFile)tplFile).equalsIgnoreCase("htpl")) {
                TemplateLastSelectionUtil.setLastSelection(tplFile, "htpl");
                TemplateLastSelectionUtil.setLastSelection(tplFile, "jtpl");
            } else if (FileTypeHandler.getFileType((IFile)tplFile).equalsIgnoreCase("jtpl")) {
                TemplateLastSelectionUtil.setLastSelection(tplFile, "jtpl");
            }
        }
        finally {
            monitor.done();
        }
    }

    private void processApplyTemplate(IApplyTemplateToMultipageOperation applyTemplate, IProgressMonitor monitor) {
        ArrayList<IFile> selectedFiles = new ArrayList<IFile>(0);
        FileModelProxy[] proxies = this.info.getTargetFilesProxy();
        int i = 0;
        while (i < proxies.length) {
            IFile file;
            FileModelProxy proxy = proxies[i];
            if (proxy.isApplyTemplateFlag() && (file = proxy.getFile()) != null && file.exists() && !selectedFiles.contains(file)) {
                selectedFiles.add(file);
            }
            ++i;
        }
        IFile sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)this.info.getSourceFileModel())));
        if (sourceFile != null && selectedFiles.remove(sourceFile)) {
            selectedFiles.add(0, sourceFile);
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2000);
        try {
            subMonitor.beginTask(PROGRESS_STATE_APPLY_TEMPLATE, selectedFiles.size());
            applyTemplate.doApplyTemplate(this.info.getComponent(), selectedFiles, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IProgressMonitor)subMonitor);
            this.info.setApplyErrorFiles(applyTemplate.getErrorFileList());
        }
        finally {
            subMonitor.done();
        }
    }
}

