/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.model;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.ITestPreviewDataModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class TemplateWizardDataModel {
    private IDOMModel modelForPreview;
    protected boolean updateModelForPreview = true;
    private int uniqueIndex = 0;
    private Object fixuppedTemplate;
    private String masterEncoding;
    private PreviewDataModel previewDataModel;

    protected abstract IDOMModel createPreviewModel();

    public IDOMModel getModelForPreview() {
        if (this.updateModelForPreview) {
            IDOMModel model = this.createPreviewModel();
            if (this.modelForPreview != null) {
                this.modelForPreview.releaseFromEdit();
                this.modelForPreview = null;
            }
            this.modelForPreview = model;
            this.updateModelForPreview = false;
        }
        return this.modelForPreview;
    }

    public void releaseAllModel() {
        if (this.modelForPreview != null) {
            this.modelForPreview.releaseFromEdit();
            this.modelForPreview = null;
        }
        if (this.previewDataModel != null) {
            this.previewDataModel.dispose();
            this.previewDataModel = null;
        }
    }

    protected String assignNewLocation(IDOMModel model, String extension) {
        if (model == null) {
            return null;
        }
        String newLocation = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        int extIndex = newLocation.lastIndexOf(46);
        if (extIndex > 0) {
            String ext = extension != null ? extension : newLocation.substring(extIndex);
            String id = newLocation.substring(0, extIndex);
            id = String.valueOf(id) + Integer.toString(this.uniqueIndex);
            newLocation = id = String.valueOf(id) + ext;
        } else {
            newLocation = String.valueOf(newLocation) + Integer.toString(this.uniqueIndex);
        }
        ++this.uniqueIndex;
        return newLocation;
    }

    protected IDOMModel createCopyModel(IDOMModel originalModel) {
        if (originalModel == null) {
            return null;
        }
        int i = 0;
        while (i < 100) {
            try {
                String newLocation;
                String newID = newLocation = this.assignNewLocation(originalModel, null);
                IDOMModel copyTargetModel = (IDOMModel)originalModel.copy(newID);
                IFile newModelFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(newLocation));
                copyTargetModel.setBaseLocation(newModelFile == null ? newLocation : newModelFile.getFullPath().toString());
                IProject baseModelProject = originalModel.getResolver() != null ? originalModel.getResolver().getProject() : null;
                copyTargetModel.setResolver((URIResolver)new ProjectResolver(baseModelProject));
                copyTargetModel.getResolver().setFileBaseLocation(newLocation);
                return copyTargetModel;
            }
            catch (ResourceAlreadyExists resourceAlreadyExists) {
            }
            catch (ResourceInUse resourceInUse) {}
            ++i;
        }
        return null;
    }

    public abstract boolean hasDefaultMap(String var1);

    public abstract Object getTemplate();

    public abstract IPath getTemplateLocation();

    public Object getFixuppedTemplate() {
        return this.fixuppedTemplate;
    }

    public void setFixuppedTemplate(Object fixuppedTemplate) {
        this.fixuppedTemplate = fixuppedTemplate;
    }

    public void setMasterEncoding(String enc) {
        this.masterEncoding = enc;
    }

    public String getMasterEncoding() {
        return this.masterEncoding;
    }

    protected abstract ITemplateErrorInfo getErrorInfo(IDOMModel var1);

    protected abstract IDOMModel createPreviewModel(IDOMModel var1);

    public ITestPreviewDataModel getTestPreviewModel() {
        if (this.previewDataModel == null) {
            this.previewDataModel = new PreviewDataModel();
        }
        return this.previewDataModel;
    }

    private class PreviewDataModel
    implements ITestPreviewDataModel {
        IDOMModel currentPreviewModel;

        private PreviewDataModel() {
        }

        @Override
        public IDOMModel getPreviewModel(IDOMModel source) {
            if (this.currentPreviewModel != null) {
                this.currentPreviewModel.releaseFromEdit();
                this.currentPreviewModel = null;
            }
            this.currentPreviewModel = TemplateWizardDataModel.this.createPreviewModel(source);
            return this.currentPreviewModel;
        }

        @Override
        public ITemplateErrorInfo getErrorInfo(IDOMModel model) {
            return TemplateWizardDataModel.this.getErrorInfo(model);
        }

        @Override
        public IPath getTemplateLocation() {
            return TemplateWizardDataModel.this.getTemplateLocation();
        }

        @Override
        public Object getTemplate() {
            return TemplateWizardDataModel.this.getTemplate();
        }

        @Override
        public void setMasterEncoding(String encoding) {
            TemplateWizardDataModel.this.setMasterEncoding(encoding);
        }

        public void dispose() {
            if (this.currentPreviewModel != null) {
                this.currentPreviewModel.releaseFromEdit();
            }
            this.currentPreviewModel = null;
        }
    }
}

