/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.contentareamapping;

import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.wizards.contentareamapping.MappingTableActionTarget;
import com.ibm.etools.webpage.template.wizards.contentareamapping.MappingTableEditAction;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class ContentAreaMappingTable
implements ICellEditorListener,
MappingTableActionTarget {
    public static final String CONTENT_NONE = ResourceHandler._UI___Nowhere___1;
    public static final String CONTENT_NOTFIXED = ResourceHandler._UI___Not_Fixed___2;
    private static final String MENU_EDIT = ResourceHandler._UI__Edit;
    private static final String MAPPINGTABLE_CONTEXT_MENU_ID = "MappingTableEditor";
    private Table table;
    private TableEditor tableEditor;
    private CellEditor cellEditor = null;
    private CellEditor editor1 = null;
    private int fColumnNumber;
    private int maxColumn = 2;
    private List availableAreas;
    private boolean allowDuplicateSelection = false;
    MappingTableEditAction editAction = new MappingTableEditAction(MENU_EDIT, this);
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ContentAreaMappingTable.this.disableCellEditor();
        }
    };

    public Table createTable(Composite page) {
        this.table = new Table(page, 68096);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        int[] columnWidths = new int[]{160, 160};
        String[] columnTitles = new String[]{ResourceHandler._UI_Current_Content_Area_Name_2, ResourceHandler._UI_New_Content_Area_Name_3};
        int i = 0;
        while (i < columnWidths.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setWidth(columnWidths[i]);
            if (i < columnTitles.length) {
                tableColumn.setText(columnTitles[i]);
            }
            ++i;
        }
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                ContentAreaMappingTable.this.handleMouseDown(event);
            }

            public void mouseDoubleClick(MouseEvent event) {
            }
        });
        this.tableEditor = new TableEditor(this.table);
        MenuManager manager = new MenuManager(MAPPINGTABLE_CONTEXT_MENU_ID, MAPPINGTABLE_CONTEXT_MENU_ID);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ContentAreaMappingTable.this.internalMenuAboutToShow(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
        return this.table;
    }

    public void setLayoutData(GridData gridData) {
        this.table.setLayoutData((Object)gridData);
    }

    public void setTableData(ContentMappingTemplateDataModel dataModel) {
        this.table.removeAll();
        List currentAreas = dataModel.getAreasInSourceModel(dataModel.getSourceModel());
        this.availableAreas = dataModel.getAreasInTemplate();
        this.editor1 = null;
        int i = 0;
        while (i < currentAreas.size()) {
            String[] stringLine;
            stringLine = new String[]{(String)currentAreas.get(i), dataModel.getDefaultMapFor(stringLine[0])};
            if (stringLine[1] == null) {
                stringLine[1] = CONTENT_NOTFIXED;
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(stringLine);
            this.notifyValueChanged(stringLine[0], stringLine[1], false);
            ++i;
        }
    }

    public void allowDuplicateSelection(boolean allow) {
        this.allowDuplicateSelection = allow;
    }

    public String getErrorMessage() {
        TableItem[] items = this.table.getItems();
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            String value = items[i].getText(1);
            if (value.equals(CONTENT_NOTFIXED)) {
                return ResourceHandler._UI_One_or_more_content_areas_are_not_fixed__2;
            }
            if (!this.allowDuplicateSelection && !CONTENT_NONE.equals(value) && values.contains(value)) {
                return ResourceHandler._UI_You_cannot_assign_the_same_content_area_to_several_current_content_areas;
            }
            values.add(value);
            ++i;
        }
        return null;
    }

    public boolean canComplete() {
        return this.getErrorMessage() == null;
    }

    private void handleMouseDown(MouseEvent event) {
        boolean cellEditorActivated = this.isCellEditorActive();
        this.disableCellEditor();
        if (event.button != 1) {
            return;
        }
        TableItem[] items = this.table.getSelection();
        if (items.length == 1) {
            TableItem tableItem = items[0];
            int columns = this.table.getColumnCount();
            int i = 0;
            while (i < columns) {
                Rectangle bounds = tableItem.getBounds(i);
                if (bounds.contains(event.x, event.y)) {
                    this.fColumnNumber = i;
                    if (this.fColumnNumber == 0 && !cellEditorActivated) {
                        this.fColumnNumber = 1;
                    }
                    this.activateCellEditor(tableItem, this.fColumnNumber);
                    return;
                }
                ++i;
            }
        }
    }

    private void disableCellEditor() {
        if (this.cellEditor != null) {
            this.applyEditorValue();
            this.deactivateCellEditor();
        }
    }

    public void cancelEditor() {
        this.deactivateCellEditor();
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }

    public void applyEditorValue() {
        int columnToEdit = this.tableEditor.getColumn();
        if (columnToEdit < 0 || this.cellEditor == null) {
            return;
        }
        boolean modified = false;
        TableItem ti = this.tableEditor.getItem();
        if (ti != null) {
            String newText = (String)this.cellEditor.getValue();
            String oldText = ti.getText(columnToEdit);
            boolean bl = (newText == null ? oldText == null : newText.equals(oldText)) ? false : (modified = true);
            if (modified) {
                ti.setText(columnToEdit, newText);
            }
        }
        this.deactivateCellEditor();
        if (modified) {
            this.notifyTableEdited();
            this.notifyValueChanged(ti.getText(0), ti.getText(1), true);
        }
    }

    private void deactivateCellEditor() {
        this.tableEditor.setEditor(null, null, this.tableEditor.getColumn());
        if (this.cellEditor != null) {
            this.cellEditor.removeListener((ICellEditorListener)this);
            this.cellEditor.getControl().removeFocusListener(this.focusListener);
            this.cellEditor.deactivate();
            this.cellEditor = null;
        }
    }

    private void activateCellEditor(TableItem item, int columnToEdit) {
        if (columnToEdit < 0 || columnToEdit >= this.maxColumn) {
            return;
        }
        this.cellEditor = this.getCellEditor(columnToEdit);
        if (this.cellEditor == null) {
            return;
        }
        this.cellEditor.setValue((Object)item.getText(columnToEdit));
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.table.showSelection();
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableEditor.grabHorizontal = layout.grabHorizontal;
        this.tableEditor.minimumWidth = item.getBounds((int)columnToEdit).width;
        this.tableEditor.setEditor(control, item, columnToEdit);
        this.cellEditor.setFocus();
        this.cellEditor.addListener((ICellEditorListener)this);
        this.cellEditor.getControl().addFocusListener(this.focusListener);
    }

    protected CellEditor getCellEditor(int columnToEdit) {
        CellEditor ret = null;
        switch (columnToEdit) {
            case 1: {
                if (this.editor1 == null) {
                    this.editor1 = this.createEditor1();
                }
                ret = this.editor1;
            }
        }
        return ret;
    }

    private CellEditor createEditor1() {
        String[] s = new String[this.availableAreas.size() + 1];
        int i = 0;
        while (i < this.availableAreas.size()) {
            s[i] = (String)this.availableAreas.get(i);
            ++i;
        }
        s[s.length - 1] = CONTENT_NONE;
        ComboBoxCellEditor ret = new ComboBoxCellEditor((Composite)this.table, s, 8){

            protected Object doGetValue() {
                CCombo comboBox = (CCombo)this.getControl();
                int index = comboBox.getSelectionIndex();
                if (index == -1) {
                    return comboBox.getText();
                }
                return comboBox.getItem(index);
            }

            protected void doSetValue(Object value) {
                if (value instanceof String) {
                    CCombo comboBox = (CCombo)this.getControl();
                    int index = comboBox.indexOf(value.toString());
                    String v = value.toString();
                    if (index < 0 && v.length() > 0) {
                        comboBox.setText(v);
                    } else {
                        super.doSetValue((Object)new Integer(index));
                    }
                } else {
                    super.doSetValue(value);
                }
            }

            protected Control createControl(Composite parent) {
                CCombo comboBox = (CCombo)super.createControl(parent);
                return comboBox;
            }
        };
        return ret;
    }

    protected boolean isCellEditorActive() {
        return this.cellEditor != null && this.cellEditor.isActivated();
    }

    private void notifyValueChanged(String key, String value, boolean byUser) {
        if (CONTENT_NONE.equals(value) || CONTENT_NOTFIXED.equals(value)) {
            value = null;
        }
        this.notifyTableValueChanged(key, value, byUser);
    }

    protected abstract void notifyTableValueChanged(String var1, String var2, boolean var3);

    protected abstract void notifyTableEdited();

    protected void internalMenuAboutToShow(IMenuManager mgr) {
        int[] sels = this.table.getSelectionIndices();
        this.editAction.setEnabled(sels.length == 1);
        mgr.add((IAction)this.editAction);
    }

    @Override
    public void doEdit() {
        this.disableCellEditor();
        TableItem[] items = this.table.getSelection();
        if (items.length == 1) {
            TableItem tableItem = items[0];
            this.fColumnNumber = 1;
            this.activateCellEditor(tableItem, this.fColumnNumber);
        }
    }
}

