/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.tiles.util;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.proxy.HTMLEditDomainCommandProxy;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.extension.override.CommandExtensionContext;
import com.ibm.etools.webedit.internal.extension.OverrideActionRegistry;
import com.ibm.etools.webedit.internal.nodemodelprovider.VirtualModelNodeProvider;
import com.ibm.etools.webedit.linkfixup.LinkFixup;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerEncodingHelperForSave;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webedit.viewer.utils.HeaderModifier;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.tiles.TilesOverrideActionConstants;
import com.ibm.etools.webpage.template.tiles.commands.TilesNewFileGenerationCommand;
import com.ibm.etools.webpage.template.wizards.model.TemplateCommandExtensionContext;
import com.ibm.etools.webpage.template.wizards.model.TemplateForCommands;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class TilesNewFileUtil
implements TilesOverrideActionConstants {
    public static final String TILES_DEFAULT_CONTENT_FOLDER = "tilesContent";
    protected static final String UNDERBAR = "_";

    public static IFile retrieveDefaultFileFor(IVirtualComponent component, String instanceFileName, String getAreaName, List quasiExistList) {
        int i = 1;
        IFile file = TilesNewFileUtil.retrieveDefaultFileFor(component, instanceFileName, getAreaName, i++);
        while (file.exists() || quasiExistList != null && quasiExistList.contains(file)) {
            file = TilesNewFileUtil.retrieveDefaultFileFor(component, instanceFileName, getAreaName, i++);
        }
        return file;
    }

    private static IFile retrieveDefaultFileFor(IVirtualComponent component, String instanceFileName, String getAreaName, int underbars) {
        String templatePrefix = instanceFileName;
        String templateSuffix = templatePrefix.substring(templatePrefix.lastIndexOf("."));
        templatePrefix = templatePrefix.substring(0, templatePrefix.lastIndexOf("."));
        String prefix = UNDERBAR;
        while (--underbars > 0) {
            prefix = String.valueOf(prefix) + UNDERBAR;
        }
        prefix = String.valueOf(templatePrefix) + prefix + getAreaName;
        String suffix = templateSuffix;
        WebComponent comp = new WebComponent(component);
        try {
            IContainer container = comp.getRootPublishableFolder();
            container = container.getFolder((IPath)new Path(TILES_DEFAULT_CONTENT_FOLDER));
            IFile iFile = container.getFile((IPath)new Path(String.valueOf(prefix) + suffix));
            return iFile;
        }
        finally {
            comp.dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean createNewContentFile(HTMLCommandTarget target, Object template, IProgressMonitor monitor, IFile file, IDOMModel refModel, NodeList contents) {
        IDOMModel newModel = TilesNewFileUtil.createNewContentModel(target, template, file, refModel, contents, false);
        try {
            try {
                ModelManagerEncodingHelperForSave.save((IStructuredModel)newModel, (IFile)file, null);
                return false;
            }
            catch (IOException e) {
                Logger.log((Throwable)e);
                if (newModel == null) return false;
                newModel.releaseFromEdit();
                return false;
            }
            catch (CoreException e) {
                Logger.log((Throwable)e);
                if (newModel == null) return false;
                newModel.releaseFromEdit();
                return false;
            }
        }
        finally {
            if (newModel != null) {
                newModel.releaseFromEdit();
            }
        }
    }

    protected static boolean linkFixup(IStructuredModel model, IProgressMonitor monitor, IProject orgProject, IPath orgPath, IProject newProject, IPath newPath, Shell shell) {
        boolean ret = false;
        LinkFixup linkfixup = new LinkFixup();
        linkfixup.setMakeAllDocRootRelative(true);
        String baseHref = HeaderModifier.getHTMLBaseHref((IStructuredModel)model);
        if (baseHref != null && baseHref.length() > 0) {
            linkfixup.setSkipHTMLBaseAwareLink(true);
        }
        String fileExt = newPath.getFileExtension();
        IFile virtualFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(orgPath.removeLastSegments(1).append(UUID.randomUUID().toString().concat("." + fileExt)));
        VirtualModelNodeProvider.getInstance().addVirtualModel(virtualFile, model);
        ret = linkfixup.performFixup(virtualFile, model, orgProject, orgPath, newProject, newPath, shell, true, null);
        if (!ret) {
            monitor.setCanceled(true);
            model.changedModel();
            VirtualModelNodeProvider.getInstance().removeVirualModel(virtualFile);
            return false;
        }
        VirtualModelNodeProvider.getInstance().removeVirualModel(virtualFile);
        return true;
    }

    public static IDOMModel createNewContentModel(HTMLCommandTarget target, Object template, IFile file, IDOMModel refModel, NodeList contents, boolean read) {
        IModelManager mgr = StructuredModelManager.getModelManager();
        IDOMModel newModel = null;
        ModelManagerUtil mmu = new ModelManagerUtil(null, null);
        String sseId = ModelManagerUtil.calculateSSEModelId((IFile)file);
        if (read) {
            newModel = (IDOMModel)mgr.getExistingModelForRead((Object)sseId);
            if (newModel == null) {
                newModel = (IDOMModel)mmu.getNewModelForRead(file);
            }
        } else {
            newModel = (IDOMModel)mgr.getExistingModelForEdit((Object)sseId);
            if (newModel == null) {
                newModel = (IDOMModel)mmu.getNewModelForEdit(file);
            }
        }
        if (newModel != null) {
            IFile refFile;
            IDOMDocument doc = newModel.getDocument();
            Node child = doc.getFirstChild();
            while (child != null) {
                Node toBeRemoved = child;
                child = toBeRemoved.getNextSibling();
                toBeRemoved.getParentNode().removeChild(toBeRemoved);
            }
            HTMLEditDomainCommandProxy domain = null;
            if (target instanceof HTMLEditDomain && target.getActiveModel().equals(newModel)) {
                domain = (HTMLEditDomain)target;
            } else {
                domain = new HTMLEditDomainCommandProxy(newModel);
                Range range = ((DocumentRange)doc).createRange();
                range.setStart((Node)doc, 0);
                range.setEnd((Node)doc, 0);
                domain.getSelectionMediator().setRange(range);
            }
            Object command = null;
            TilesNewFileGenerationCommand defaultCommand = new TilesNewFileGenerationCommand("command.template.contentAreaFileCreation");
            defaultCommand.setRefModel(refModel);
            defaultCommand.setContents(contents);
            TemplateCommandExtensionContext context = new TemplateCommandExtensionContext((HTMLCommandTarget)domain, (HTMLCommand)defaultCommand, new TemplateForCommands(template), "command.template.contentAreaFileCreation");
            command = OverrideActionRegistry.generateExtendedCommand((HTMLCommand)defaultCommand, (CommandExtensionContext)context, (String)"command.template.contentAreaFileCreation");
            if (command == null) {
                command = defaultCommand;
            }
            command.setCommandTarget((HTMLCommandTarget)domain);
            domain.execCommand((Command)command);
            if (refModel != null && (refFile = WebComponent.getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)refModel)))) != null) {
                TilesNewFileUtil.linkFixup((IStructuredModel)newModel, (IProgressMonitor)new NullProgressMonitor(), refFile.getProject(), refFile.getLocation(), file.getProject(), file.getLocation(), domain.getDialogParent());
            }
        }
        return newModel;
    }

    protected static IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }
}

