/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.tiles.util;

import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.tiles.ITilesConfigContentAreaConstants;
import com.ibm.etools.webpage.template.tiles.util.TilesNewFileUtil;
import com.ibm.etools.webpage.template.wizards.TemplateWizardsPlugin;
import com.ibm.etools.webpage.template.wizards.tiles.TilesSampleDefinitionElement;
import com.ibm.etools.webpage.template.wizards.tiles.areas.ITilesPutMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TilesConfigContentAreaUtil
implements ITilesConfigContentAreaConstants,
ITilesConstants {
    private static final String VALUE_DIRECT_TEXT_PREFIX = "**directValue**";
    private static final String VALUE_DEFAULT_PUT = "<put>content";
    private static final String VALUE_NEW_FILE_PREFIX = "**** create new file ****";
    private static final String VALUE_FORCE_NEW_FILE_PREFIX = "**** force create new file ****";
    private static final String VALUE_NONE = "***** none ******";
    private static final String VALUE_DEFINITION = "***** definition ******";
    private static final String VALUE_PUT_LIST = "***** putList ******";
    private static final String VALUE_PUT_LIST_SEP = "*** tiles putlist tag separator ***";
    private static final String VALUE_ERROR_FILE_PREFIX = "*** file path error ***";
    private static final String VALUE_ERROR_FILE_SEPARATOR = "*** file path error separator ***";
    private static final String COMMA = ",";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";

    public static int getType(String data) {
        if (data == null) {
            return 0;
        }
        if (data.startsWith(VALUE_DEFAULT_PUT)) {
            return 1;
        }
        if (data.startsWith(VALUE_DIRECT_TEXT_PREFIX)) {
            return 4;
        }
        if (data.startsWith(VALUE_NEW_FILE_PREFIX)) {
            return 3;
        }
        if (data.startsWith(VALUE_FORCE_NEW_FILE_PREFIX)) {
            return 3;
        }
        if (data.startsWith(VALUE_DEFINITION)) {
            return 5;
        }
        if (data.startsWith(VALUE_PUT_LIST)) {
            return 6;
        }
        if (data.startsWith(VALUE_NONE)) {
            return 0;
        }
        return 2;
    }

    public static boolean isForceCreate(String data) {
        return data.startsWith(VALUE_FORCE_NEW_FILE_PREFIX);
    }

    public static String getDirectText(String data) {
        if (TilesConfigContentAreaUtil.getType(data) != 4) {
            return null;
        }
        return data.substring(VALUE_DIRECT_TEXT_PREFIX.length());
    }

    public static IPath getFilePath(String data) {
        int type = TilesConfigContentAreaUtil.getType(data);
        if (type != 3 && type != 2) {
            return null;
        }
        if (type == 3) {
            data = TilesConfigContentAreaUtil.isForceCreate(data) ? data.substring(VALUE_FORCE_NEW_FILE_PREFIX.length()) : data.substring(VALUE_NEW_FILE_PREFIX.length());
        }
        if (TilesConfigContentAreaUtil.getErrorFileInfo(data) != null) {
            return null;
        }
        return new Path(data);
    }

    public static String[] getErrorFileInfo(String data) {
        int index;
        if (data != null && data.startsWith(VALUE_ERROR_FILE_PREFIX) && (index = (data = data.substring(VALUE_ERROR_FILE_PREFIX.length())).indexOf(VALUE_ERROR_FILE_SEPARATOR)) > 0) {
            String severity = data.substring(0, index);
            String message = data.substring(index + VALUE_ERROR_FILE_SEPARATOR.length());
            return new String[]{severity, message};
        }
        return null;
    }

    public static String getDefinition(String data) {
        int type = TilesConfigContentAreaUtil.getType(data);
        if (type != 5) {
            return null;
        }
        return data.substring(VALUE_DEFINITION.length());
    }

    public static String getPutDefaultContent(String data) {
        int type = TilesConfigContentAreaUtil.getType(data);
        if (type != 1) {
            return null;
        }
        String nestedContent = data.substring(VALUE_DEFAULT_PUT.length());
        if (nestedContent.length() > 0) {
            return nestedContent;
        }
        return null;
    }

    public static Object[] getPutListContent(String data) {
        if (TilesConfigContentAreaUtil.getType(data) != 6) {
            return null;
        }
        data = data.substring(VALUE_PUT_LIST.length());
        ArrayList<Object[]> addTags = new ArrayList<Object[]>();
        while (data != null && data.length() > 0) {
            int sep = data.indexOf(VALUE_PUT_LIST_SEP);
            if (sep < 0) break;
            String value = data.substring(0, sep);
            data = data.substring(sep + VALUE_PUT_LIST_SEP.length());
            sep = data.indexOf(COMMA);
            String type = null;
            if (sep < 0) {
                sep = data.length();
                type = data.substring(0, sep);
                data = null;
            } else {
                type = data.substring(0, sep);
                data = data.substring(sep + COMMA.length());
            }
            addTags.add(new Object[]{value, type});
        }
        return addTags.toArray();
    }

    public static String generateData(int type, Object rawData) {
        switch (type) {
            case 1: {
                if (rawData != null) {
                    return VALUE_DEFAULT_PUT + rawData;
                }
                return VALUE_DEFAULT_PUT;
            }
            case 2: {
                return rawData.toString();
            }
            case 3: {
                return VALUE_NEW_FILE_PREFIX + rawData;
            }
            case 4: {
                return VALUE_DIRECT_TEXT_PREFIX + rawData;
            }
            case 5: {
                return VALUE_DEFINITION + rawData;
            }
            case 6: {
                Object[] addArray = (Object[])rawData;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < addArray.length) {
                    Object[] add = (Object[])addArray[i];
                    buf.append(add[0]);
                    buf.append(VALUE_PUT_LIST_SEP);
                    buf.append(add[1]);
                    if (i != addArray.length - 1) {
                        buf.append(COMMA);
                    }
                    ++i;
                }
                return VALUE_PUT_LIST + buf;
            }
            case 0: {
                return VALUE_NONE + rawData;
            }
        }
        return "";
    }

    public static String generateForceCreateData(Object rawData) {
        return VALUE_FORCE_NEW_FILE_PREFIX + rawData;
    }

    public static String generateErrorFilePathData(int status, String errorMessage) {
        return VALUE_ERROR_FILE_PREFIX + status + VALUE_ERROR_FILE_SEPARATOR + errorMessage;
    }

    public static String generateDefaultContentAreaValue(TilesDefinitionElement def, IDOMModel supplementalTemplateModel, String areaName, Map map, String filePrefix, List newFiles) {
        Object value = map != null ? map.get(areaName) : null;
        String defaultPath = null;
        String defName = def.getDefinitionName();
        IVirtualComponent component = def.getComponent();
        TilesDefinitionUtil util = new TilesDefinitionUtil(component);
        if (util == null) {
            return null;
        }
        try {
            List<String> areas;
            String[] areaNames = null;
            areaNames = def.getFile().exists() ? util.collectGetAreaNames(defName, false, false, true) : TilesUtil.collectGetAreaNames((IDOMModel)supplementalTemplateModel, (boolean)false, (boolean)false, (boolean)true);
            if (areaNames != null && (areas = Arrays.asList(areaNames)).contains(areaName)) {
                if (value instanceof Attr) {
                    defaultPath = ((Attr)value).getValue();
                } else if (value instanceof Node || value instanceof NodeList) {
                    Node textNode = TilesConfigContentAreaUtil.getDefaultContentTextNode(value);
                    if (textNode != null) {
                        defaultPath = textNode.getNodeValue();
                        String textData = defaultPath.trim();
                        if (textData.startsWith(COMMENT_START) && textData.endsWith(COMMENT_END)) {
                            defaultPath = textData.substring(COMMENT_START.length(), textData.length() - COMMENT_END.length());
                        }
                    } else {
                        NodeList nodeList = value instanceof Node ? ((Node)value).getChildNodes() : (NodeList)value;
                        int len = nodeList.getLength();
                        StringBuffer buf = new StringBuffer();
                        int i = 0;
                        while (i < len) {
                            IDOMNode domNode = (IDOMNode)nodeList.item(i);
                            buf.append(domNode.getSource());
                            ++i;
                        }
                        defaultPath = buf.toString();
                    }
                } else {
                    defaultPath = "";
                }
                String string = defaultPath = TilesConfigContentAreaUtil.generateData(4, defaultPath);
                return string;
            }
            if (!(value instanceof NodeList) || ((NodeList)value).getLength() <= 0) {
                Map defMap = null;
                defMap = def.getFile().exists() ? util.lookupPutAreaMap(defName) : TilesUtil.collectPutAreaMap((IDOMModel)supplementalTemplateModel);
                if (defMap.get(areaName) != null) {
                    String string = defaultPath = TilesConfigContentAreaUtil.generateData(1, null);
                    return string;
                }
            }
            IFile newFile = TilesNewFileUtil.retrieveDefaultFileFor(component, filePrefix, areaName, newFiles);
            defaultPath = value == null ? TilesConfigContentAreaUtil.generateData(3, WebComponent.getVirtualResource((IResource)newFile).getRuntimePath().toString()) : TilesConfigContentAreaUtil.generateForceCreateData(WebComponent.getVirtualResource((IResource)newFile).getRuntimePath().toString());
            String string = defaultPath;
            return string;
        }
        finally {
            if (util != null) {
                util.dispose();
            }
        }
    }

    private static Node getDefaultContentTextNode(Object value) {
        Node targetNode;
        Node node = value instanceof Node ? (Node)value : (targetNode = value instanceof NodeList && ((NodeList)value).getLength() == 1 ? ((NodeList)value).item(0) : null);
        if (targetNode == null || targetNode.getChildNodes().getLength() > 1) {
            return null;
        }
        if (targetNode.getChildNodes().getLength() == 1) {
            targetNode = targetNode.getFirstChild();
        }
        if (targetNode != null && targetNode.getNodeValue() != null) {
            return targetNode;
        }
        return null;
    }

    public static String generateFromPutTypeValue(Object[] putValue, boolean isDirect) {
        if (putValue == null || putValue[1] == null) {
            return TilesConfigContentAreaUtil.generateData(0, null);
        }
        if (isDirect || putValue[1].equals("string")) {
            return TilesConfigContentAreaUtil.generateData(4, putValue[0]);
        }
        if (putValue[1].equals("definition")) {
            return TilesConfigContentAreaUtil.generateData(5, putValue[0]);
        }
        if (putValue[1].equals("list")) {
            return TilesConfigContentAreaUtil.generateData(6, putValue[0]);
        }
        return TilesConfigContentAreaUtil.generateData(2, putValue[0]);
    }

    public static IStatus validate(ITilesPutMap map, Object file) {
        if (map != null) {
            Map mapInDef = null;
            IVirtualComponent component = null;
            Map putValues = map.getPutValues(file);
            if (putValues != null) {
                Object template = map.getTemplate();
                if (template instanceof TilesDefinitionElement) {
                    TilesDefinitionElement ele = (TilesDefinitionElement)template;
                    if (!(ele instanceof TilesSampleDefinitionElement)) {
                        TilesDefinitionUtil util = new TilesDefinitionUtil(ele.getComponent());
                        try {
                            mapInDef = util.lookupPutAreaMap(ele.getDefinitionName());
                        }
                        finally {
                            util.dispose();
                        }
                    }
                    component = ele.getComponent();
                } else if (template instanceof IFile) {
                    component = ComponentCore.createComponent((IProject)((IFile)template).getProject());
                }
                if (component != null) {
                    MultiStatus multiStatus = new MultiStatus(TemplateWizardsPlugin.getDefault().getBundle().getSymbolicName(), 0, Status.OK_STATUS.getMessage(), null);
                    for (Object area : putValues.keySet()) {
                        Object value = putValues.get(area);
                        IStatus status = TilesConfigContentAreaUtil.validate(value.toString(), component, area.toString(), mapInDef);
                        if (status == null || status.isOK()) continue;
                        multiStatus.add(status);
                    }
                    if (!multiStatus.isOK()) {
                        return multiStatus;
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus validate(String data, IVirtualComponent component, String areaName, Map putAreaMap) {
        return TilesConfigContentAreaUtil.validate(data, component.getRootFolder().getUnderlyingFolder().getFile((IPath)new Path("a.jsp")), areaName, putAreaMap);
    }

    public static IStatus validate(String data, IFile baseFile, String areaName, Map putAreaMap) {
        int selected = TilesConfigContentAreaUtil.getType(data);
        String message = null;
        int status = 0;
        if (selected == 2 || selected == 3) {
            IPath path = TilesConfigContentAreaUtil.getFilePath(data);
            if (path == null || path.segmentCount() <= 0) {
                message = ResourceHandler._UI_Tiles_Config_Content_Area_Util_0;
                status = 2;
                String[] errorFileInfo = TilesConfigContentAreaUtil.getErrorFileInfo(data);
                if (errorFileInfo != null) {
                    message = errorFileInfo[1];
                    status = Integer.parseInt(errorFileInfo[0]);
                }
            } else {
                IFile file = TilesDefinitionUtil.getWebFile((IFile)baseFile, (IPath)path);
                if (!file.exists() && selected == 2) {
                    message = ResourceHandler._UI_Tiles_Config_Content_Area_Util_1;
                    status = 2;
                } else if (file.exists() && selected == 3) {
                    message = ResourceHandler._UI_Tiles_Config_Content_Area_Util_2;
                    status = 4;
                } else if (!"jsp".equals(FileTypeHandler.getFileType((IFile)file))) {
                    message = ResourceHandler._UI_New_Fragment_Creation_Dialog_7;
                    status = 4;
                } else if (selected == 3) {
                    message = ResourceHandler._UI_Tiles_Config_Content_Area_Util_3;
                    status = 1;
                }
            }
        } else if (selected == 1) {
            if (putAreaMap == null || putAreaMap.get(areaName) == null || putAreaMap.get(areaName).equals(VALUE_NONE)) {
                message = ResourceHandler._UI_Tiles_Config_Content_Area_Util_4;
                status = 4;
            }
        } else if (selected == 0) {
            message = ResourceHandler._UI_Tiles_Config_Content_Area_Util_5;
            status = 2;
        } else if (selected == 5) {
            TilesDefinitionUtil util = new TilesDefinitionUtil(WebComponent.getComponent((IResource)baseFile), baseFile);
            try {
                List<String> defs = Arrays.asList(util.getDefinitions());
                if (!defs.contains(TilesConfigContentAreaUtil.getDefinition(data))) {
                    message = ResourceHandler._UI_Tiles_Config_Content_Area_Util_6;
                    status = 2;
                }
            }
            finally {
                util.dispose();
            }
        }
        if (message != null) {
            message = NLS.bind((String)ResourceHandler._UI_Tiles_Config_Content_Area_Util_7, (Object[])new Object[]{areaName, message});
            return new Status(status, TemplateWizardsPlugin.getDefault().getBundle().getSymbolicName(), status, message, null);
        }
        return Status.OK_STATUS;
    }
}

