/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.tiles.commands;

import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.common.commands.NonActiveDocumentEditCommand;
import com.ibm.etools.webedit.common.commands.utils.ImportSource;
import com.ibm.etools.webedit.common.commands.utils.RemoveTag;
import com.ibm.etools.webedit.common.internal.commands.utils.IInvisibleNodeDeletionCustomizor;
import com.ibm.etools.webedit.editor.internal.page.design.IDesignPage;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webedit.viewer.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.wizards.tiles.TilesDefinitionElementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class TilesDetachTemplateCommand
extends NonActiveDocumentEditCommand
implements IInvisibleNodeDeletionCustomizor {
    public TilesDetachTemplateCommand(String label) {
        super(label);
    }

    protected boolean canDoExecute() {
        return super.canDoExecute();
    }

    protected void doExecute() {
        Node newNode;
        Node node = TilesUtil.getTemplateNode((IDOMModel)this.getModel());
        Map putMap = TilesUtil.collectPutAreaMapWithType((IDOMModel)this.getModel());
        TilesDetachTemplateCommand.mergeDefinition(this.getModel(), new TilesUtil.ContentArea(node), TilesDefinitionElementFactory.createElementFromInstanceModel(this.getModel()), putMap, true);
        RemoveTag removeTag = new RemoveTag(null, true);
        ArrayList<Node> directives = new ArrayList<Node>();
        NodeIterator itr = ((DocumentTraversal)this.getModel().getDocument()).createNodeIterator((Node)this.getModel().getDocument(), 1, null, false);
        while ((newNode = itr.nextNode()) != null) {
            if (!newNode.getNodeName().equals("jsp:directive.taglib") && !newNode.getNodeName().equals("jsp:useBean") && !newNode.getNodeName().equals("jsp:directive.page")) continue;
            if (this.contains(directives, newNode)) {
                removeTag.remove((Element)newNode);
                continue;
            }
            directives.add(newNode);
        }
        if (this.getDomain() != null && this.getDomain().getActivePageType() == 0 && PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((IDesignPage)TilesDetachTemplateCommand.this.getDomain().getDesignPart()).updateView();
                }
            });
        }
    }

    private static void mergeDefinition(IDOMModel model, TilesUtil.ContentArea parentArea, TilesDefinitionElement ele, Map putMap, boolean removeSelf) {
        String baseLocation = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        IFile file = WebComponent.getFileForLocation((IPath)new Path(baseLocation));
        ModelManagerUtil mmu = new ModelManagerUtil(null, null);
        IDOMModel templateModel = (IDOMModel)mmu.getModelForRead(ele.getFile());
        Element templateLocatorNode = null;
        if (templateModel != null) {
            try {
                if (!parentArea.hasRegion() && parentArea.getNode().getNodeType() == 1) {
                    Node templateNode = templateModel.getDocument().getFirstChild();
                    templateLocatorNode = model.getDocument().createElement("SPAN");
                    parentArea.getNode().getParentNode().insertBefore(templateLocatorNode, parentArea.getNode());
                    while (templateNode != null) {
                        Node orgNode = templateNode;
                        Node newNode = model.getDocument().importNode(orgNode, true);
                        templateNode = templateNode.getNextSibling();
                        if (newNode.getNodeType() == 10) {
                            IDOMDocumentType docType = (IDOMDocumentType)newNode;
                            DocumentType orgDocType = (DocumentType)orgNode;
                            docType.setPublicId(orgDocType.getPublicId());
                            docType.setSystemId(orgDocType.getSystemId());
                        }
                        templateLocatorNode.appendChild(newNode);
                    }
                } else if (!parentArea.hasRegion() && parentArea.getNode().getNodeType() == 2) {
                    ((Attr)parentArea.getNode()).setNodeValue(templateModel.getDocument().getSource());
                } else {
                    StringBuffer buf = new StringBuffer();
                    String baseSrc = ((IDOMNode)parentArea.getNode()).getSource();
                    if (parentArea.getNode().getNodeType() == 2) {
                        baseSrc = ((Attr)parentArea.getNode()).getValue();
                    }
                    buf.append(baseSrc.substring(0, parentArea.getStartPos()));
                    buf.append(templateModel.getDocument().getSource());
                    buf.append(baseSrc.substring(parentArea.getEndPos(), baseSrc.length()));
                    parentArea.getNode().setNodeValue(buf.toString());
                }
            }
            finally {
                templateModel.releaseFromRead();
            }
        }
        RemoveTag removeTag = new RemoveTag(null, true);
        if (removeSelf && parentArea.getNode().getNodeType() == 1) {
            removeTag.remove((Element)parentArea.getNode());
        }
        TilesDefinitionUtil defUtil = new TilesDefinitionUtil(ele.getComponent(), file);
        Map putDefMap = null;
        try {
            putDefMap = defUtil.lookupPutAreaMapWithType(ele.getDefinitionName());
            Map getMap = TilesUtil.collectGetAreaMap((IDOMModel)model, (Node)templateLocatorNode, (boolean)true, (boolean)true, (boolean)true);
            if (templateLocatorNode != null) {
                new RemoveTag(null, false).remove(templateLocatorNode);
            }
            for (String areaName : getMap.keySet()) {
                TilesUtil.ContentArea area = (TilesUtil.ContentArea)getMap.get(areaName);
                String value = null;
                String type = null;
                Object[] valueJsp = (Object[])putMap.get(areaName);
                Object[] valueDef = (Object[])putDefMap.get(areaName);
                if (valueJsp != null) {
                    value = valueJsp[0].toString();
                    type = valueJsp[1].toString();
                } else if (valueDef != null) {
                    value = valueDef[0].toString();
                    type = valueDef[1].toString();
                }
                if (value != null) {
                    IFile contentFile = null;
                    if ("page".equals(type)) {
                        contentFile = TilesDefinitionUtil.getWebFile((IFile)file, (IPath)new Path(value));
                    }
                    if (contentFile != null && contentFile.exists()) {
                        IDOMModel contentModel = (IDOMModel)mmu.getModelForRead(contentFile);
                        try {
                            if (!area.hasRegion() && area.getNode().getNodeType() == 1) {
                                Node contentNode = contentModel.getDocument().getFirstChild();
                                while (contentNode != null) {
                                    Node orgNode = contentNode;
                                    Node newNode = model.getDocument().importNode(orgNode, true);
                                    contentNode = contentNode.getNextSibling();
                                    if (newNode.getNodeType() == 10) {
                                        IDOMDocumentType docType = (IDOMDocumentType)newNode;
                                        DocumentType orgDocType = (DocumentType)orgNode;
                                        docType.setPublicId(orgDocType.getPublicId());
                                        docType.setSystemId(orgDocType.getSystemId());
                                    }
                                    area.getNode().getParentNode().insertBefore(newNode, area.getNode());
                                }
                            }
                            if (!area.hasRegion() && area.getNode().getNodeType() == 2) {
                                ((Attr)area.getNode()).setNodeValue(contentModel.getDocument().getSource());
                            }
                            StringBuffer buf = new StringBuffer();
                            String baseSrc = ((IDOMNode)area.getNode()).getSource();
                            if (area.getNode().getNodeType() == 2) {
                                baseSrc = ((Attr)area.getNode()).getValue();
                            }
                            buf.append(baseSrc.substring(0, area.getStartPos()));
                            buf.append(contentModel.getDocument().getSource());
                            buf.append(baseSrc.substring(area.getEndPos(), baseSrc.length()));
                            area.getNode().setNodeValue(buf.toString());
                        }
                        finally {
                            contentModel.releaseFromRead();
                        }
                    } else if ("definition".equals(type)) {
                        TilesDetachTemplateCommand.mergeDefinition(model, area, TilesDefinitionElementFactory.createElementFromInstanceFile(value, file), Collections.EMPTY_MAP, false);
                    } else {
                        ImportSource is = new ImportSource((Document)model.getDocument(), null);
                        is.doFixup(false);
                        DocumentFragment frag = is.getFragment(value);
                        if (!area.hasRegion()) {
                            if (area.getNode().getNodeType() == 2) {
                                ((Attr)area.getNode()).setNodeValue(((IDOMNode)frag).getSource());
                            } else {
                                area.getNode().getParentNode().insertBefore(frag, area.getNode());
                            }
                        } else {
                            StringBuffer buf = new StringBuffer();
                            String baseSrc = ((IDOMNode)area.getNode()).getSource();
                            if (area.getNode().getNodeType() == 2) {
                                baseSrc = ((Attr)area.getNode()).getValue();
                            }
                            buf.append(baseSrc.substring(0, area.getStartPos()));
                            buf.append(((IDOMNode)frag).getSource());
                            buf.append(baseSrc.substring(area.getEndPos(), baseSrc.length()));
                            area.getNode().setNodeValue(buf.toString());
                        }
                    }
                }
                if (area.getNode() == null || area.getNode().getNodeType() != 1) continue;
                removeTag.remove((Element)area.getNode());
            }
        }
        finally {
            defUtil.dispose();
        }
    }

    private boolean contains(List nodes, Node node) {
        for (Object obj : nodes) {
            Node target;
            if (!(obj instanceof Node) || (target = (Node)obj).getNodeType() != node.getNodeType() || !target.getNodeName().equals(node.getNodeName()) || target.getChildNodes() != null && target.getChildNodes().getLength() > 0 || node.getChildNodes() != null && node.getChildNodes().getLength() > 0) continue;
            if (target.getAttributes() != null) {
                int len;
                if (node.getAttributes() == null || (len = target.getAttributes().getLength()) != node.getAttributes().getLength()) continue;
                boolean same = true;
                int i = 0;
                while (i < len) {
                    Node attr = target.getAttributes().item(i);
                    Node attrSrc = node.getAttributes().getNamedItem(attr.getNodeName());
                    if (attrSrc == null || !attr.getNodeValue().equals(attrSrc.getNodeValue())) {
                        same = false;
                        break;
                    }
                    ++i;
                }
                if (!same) {
                    continue;
                }
            } else if (node.getAttributes() != null) continue;
            return true;
        }
        return false;
    }

    protected boolean bufferModelEvent() {
        return true;
    }

    public int getInvisibleNodeDeletionVerbosity() {
        return 1;
    }
}

