/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.tiles.commands;

import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.utils.ImportSource;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.internal.commands.utils.IInvisibleNodeDeletionCustomizor;
import com.ibm.etools.webedit.common.utils.NodeDataAccessor;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.tiles.ITilesConfigContentAreaConstants;
import com.ibm.etools.webpage.template.tiles.util.TilesConfigContentAreaUtil;
import com.ibm.etools.webpage.template.wizards.tiles.TilesEditTargetUtil;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TilesApplyTemplateCommand
extends EditRangeCommand
implements ITilesConfigContentAreaConstants,
ITilesConstants,
IInvisibleNodeDeletionCustomizor {
    private static final String XMLNS = "xmlns:";
    private String definitionName;
    private Map putMap;

    public TilesApplyTemplateCommand(String definitionName) {
        super(ResourceHandler._UI_Tiles_Apply_Template_Command_0);
        this.definitionName = definitionName;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public Map getPutMap() {
        return this.putMap;
    }

    public void setPutMap(Map putMap) {
        this.putMap = putMap;
    }

    protected Node cleanDocAndSetupTaglib(IDOMDocument doc, boolean isXMLStyleJsp) {
        IProject project = WebComponent.getProjectForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)doc.getModel())));
        if (!isXMLStyleJsp) {
            NodeList list = doc.getElementsByTagName("jsp:directive.page");
            Node child = doc.getFirstChild();
            while (child != null) {
                Node toBeRemoved = child;
                child = toBeRemoved.getNextSibling();
                toBeRemoved.getParentNode().removeChild(toBeRemoved);
            }
            int pageDirs = list.getLength();
            int i = 0;
            while (i < pageDirs) {
                Element ele = (Element)list.item(i);
                if (ele.getAttributeNode("contentType") != null || ele.getAttributeNode("pageEncoding") != null) {
                    doc.appendChild((Node)ele);
                }
                ++i;
            }
            Element ele = doc.createElement("jsp:directive.taglib");
            ((IDOMElement)ele).setJSPTag(true);
            String[] taglib = TilesUtil.getTilesTaglibURIAndPrefixToInsert((HTMLEditDomain)this.getDomain(), (IProject)project, (IDOMModel)doc.getModel());
            ele.setAttribute("uri", taglib[0]);
            ele.setAttribute("prefix", taglib[1]);
            doc.appendChild((Node)ele);
            return doc;
        }
        NodeList list = doc.getElementsByTagName("jsp:directive.page");
        Element ele = doc.getDocumentElement();
        Node child = ele.getFirstChild();
        while (child != null) {
            Node toBeRemoved = child;
            child = toBeRemoved.getNextSibling();
            toBeRemoved.getParentNode().removeChild(toBeRemoved);
        }
        int pageDirs = list.getLength();
        int i = 0;
        while (i < pageDirs) {
            Element pageDirective = (Element)list.item(i);
            if (pageDirective.getAttributeNode("contentType") != null || pageDirective.getAttributeNode("pageEncoding") != null) {
                ele.appendChild(pageDirective);
            }
            ++i;
        }
        String attrName = "xmlns:tiles";
        String[] taglib = TilesUtil.getTilesTaglibURIAndPrefixToInsert((HTMLEditDomain)this.getDomain(), (IProject)project, (IDOMModel)doc.getModel());
        NodeDataAccessor.setAttribute((Element)ele, (String)attrName, (String)taglib[0]);
        return ele;
    }

    protected void doExecute() {
        IDOMDocument doc = this.getModel().getDocument();
        if (this.definitionName == null) {
            return;
        }
        boolean isXMLStyleJsp = doc.isJSPType() && doc.isJSPDocument();
        Node root = this.cleanDocAndSetupTaglib(doc, isXMLStyleJsp);
        Element ele = doc.createElement("tiles:insert");
        ele.setAttribute("definition", this.definitionName);
        root.appendChild(ele);
        if (this.putMap == null) {
            return;
        }
        Iterator it = this.putMap.keySet().iterator();
        while (it.hasNext()) {
            String areaName = it.next().toString();
            Object path = this.putMap.get(areaName);
            int type = TilesConfigContentAreaUtil.getType(path.toString());
            if (type == 0 || type == 1 || type == 6) continue;
            Element put = doc.createElement("tiles:put");
            put.setAttribute("name", areaName);
            if (type == 4) {
                String value = TilesConfigContentAreaUtil.getDirectText(path.toString());
                if (value.indexOf(60) < 0 && value.indexOf(13) < 0 && value.indexOf(10) < 0) {
                    put.setAttribute("value", value);
                } else {
                    ImportSource is = new ImportSource((Document)doc, null);
                    is.doFixup(false);
                    put.appendChild(is.getFragment(value));
                }
                put.setAttribute("direct", "true");
                put.setAttribute("type", "string");
            } else if (type == 5) {
                put.setAttribute("value", TilesConfigContentAreaUtil.getDefinition(path.toString()));
                put.setAttribute("type", "definition");
            } else {
                IPath filePath = TilesConfigContentAreaUtil.getFilePath(path.toString());
                if (filePath != null) {
                    put.setAttribute("value", filePath.toString());
                }
                put.setAttribute("type", "page");
            }
            ele.appendChild(put);
        }
    }

    protected boolean canDoExecute() {
        if (!TilesEditTargetUtil.getTargetModel(this.getDomain()).equals(this.getModel())) {
            return false;
        }
        return "NoRelationToTemplate".equals(TilesUtil.getTilesType((IDOMModel)this.getModel()));
    }

    public int getInvisibleNodeDeletionVerbosity() {
        return 1;
    }
}

