/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.wizards.parts;

import com.ibm.etools.webedit.editparts.design.DesignTimeTagManager;
import com.ibm.etools.webedit.editparts.vct.DesignTimeTagManagerImpl;
import com.ibm.etools.webedit.viewer.thumbnails.FrameThumbnail;
import com.ibm.etools.webedit.viewer.thumbnails.FrameViewInitializer;
import com.ibm.etools.webedit.viewer.thumbnails.HTMLThumbnail;
import java.util.List;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class HTMLThumbnailRenderer {
    private final int DEFAULT_RENDERING_WIDTH = 500;
    private final int DEFAULT_RENDERING_HEIGHT = 500;
    private IDOMModel model;
    private Display disp;
    private FrameThumbnail t;
    private HTMLThumbnail ht;

    public void dispose() {
        this.clear();
        if (this.disp != null) {
            this.disp.close();
            this.disp = null;
        }
    }

    public void clear() {
        if (this.t != null) {
            this.t.dispose();
            this.t = null;
        }
        if (this.ht != null) {
            this.ht.dispose();
            this.ht = null;
        }
    }

    public void setModel(IDOMModel model) {
        this.model = model;
    }

    public List getTargetNodeRects(Node node) {
        if (this.ht != null) {
            return this.ht.getTargetNodeRects((Object)node);
        }
        return null;
    }

    public List getNodeRects(Node node) {
        if (this.ht != null) {
            return this.ht.getNodeRects((Object)node);
        }
        return null;
    }

    public ImageData getImageData(int preferWidth, int preferHeight) {
        if (this.model == null) {
            return null;
        }
        this.updateThumbnail(preferWidth, preferHeight);
        ImageData imagedata = null;
        if (this.t != null && this.t.isValid()) {
            imagedata = this.t.getTargetImageData();
        } else if (this.ht != null) {
            imagedata = this.ht.getTargetImageData();
        }
        return imagedata;
    }

    private void updateThumbnail(int preferWidth, int preferHeight) {
        int defaultSize = 320;
        if (preferWidth <= 0 && preferHeight <= 0) {
            preferWidth = preferHeight = defaultSize;
        } else if (preferWidth <= 0) {
            preferWidth = preferHeight;
        } else if (preferHeight <= 0) {
            preferHeight = preferWidth;
        }
        if (this.disp == null && Display.getCurrent() == null) {
            this.disp = new Display();
        }
        if (this.t == null) {
            this.t = new FrameThumbnail();
        }
        this.t.setPageSize(500, 500);
        this.t.setTargetSize(preferWidth, preferHeight);
        this.t.setInitializer(new FrameViewInitializer(){

            public void initialize(HTMLThumbnail thumbnail) {
                if (thumbnail != null) {
                    thumbnail.getViewOption().setVisualizingTagMode(true);
                    thumbnail.getViewOption().setShowEmbeddedDocument(true);
                    thumbnail.setDesignTimeTagManager((DesignTimeTagManager)new DesignTimeTagManagerImpl((EditPartViewer)thumbnail));
                }
            }
        });
        this.t.setModel(this.model);
        if (this.t.isValid()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            if (this.ht == null) {
                this.ht = new HTMLThumbnail();
            }
            this.ht.setPageSize(500, 500, false);
            this.ht.getViewOption().setVisualizingTagMode(true);
            this.ht.getViewOption().setShowEmbeddedDocument(true);
            this.ht.setDesignTimeTagManager((DesignTimeTagManager)new DesignTimeTagManagerImpl((EditPartViewer)this.ht));
            this.ht.setModel(this.model);
            ImageData temp = this.ht.getPageImageData();
            int orgWidth = temp.width;
            int orgHeight = temp.height;
            if (orgWidth >= orgHeight) {
                preferHeight = preferWidth * orgHeight / orgWidth;
            } else {
                preferWidth = preferHeight * orgWidth / orgHeight;
            }
            this.ht.setTargetSize(preferWidth, preferHeight);
        }
    }

    public ImageData getPageImageData() {
        if (this.model == null) {
            return null;
        }
        ImageData imagedata = null;
        if (this.t != null && this.t.isValid()) {
            imagedata = this.t.getPageImageData();
        } else if (this.ht != null) {
            imagedata = this.ht.getPageImageData();
        }
        return imagedata;
    }
}

