/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.validation.validator;

import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.dialog.IMsgReplaceTemplateErrorInfo;
import com.ibm.etools.webpage.template.validation.IPropertyResolver;
import com.ibm.etools.webpage.template.validation.ITemplateValidator;
import com.ibm.etools.webpage.template.validation.PropertyValueUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class MatchEncodingValidator
implements ITemplateValidator {
    protected String getProperty() {
        return "page.encoding";
    }

    public IStatus validate(String type, IPropertyResolver instance, IPropertyResolver template) {
        String p = this.getProperty();
        if (instance.hasProperty(p) && template.hasProperty(p)) {
            if (PropertyValueUtil.hasIntersectionString((Object)instance.getProperty(p), (Object)template.getProperty(p), (boolean)true)) {
                return Status.OK_STATUS;
            }
            return this.createError(type, instance, template);
        }
        return null;
    }

    protected IStatus createError(String type, IPropertyResolver instance, IPropertyResolver template) {
        boolean reportError = false;
        if (instance.hasProperty("page.model")) {
            reportError = true;
            IDOMModel model = (IDOMModel)instance.getProperty("page.model");
            if (model.isSharedForEdit()) {
                reportError = false;
            }
        }
        if (reportError) {
            return new Status(4, TemplatePlugin.ID, 170, IMsgReplaceTemplateErrorInfo.MSG_ENCODING_ERROR, null);
        }
        String message = NLS.bind((String)WizardFileUtil.MSG_ENCODING_MISMATCH, (Object)instance.getProperty("page.encoding"), (Object)template.getProperty("page.encoding"));
        return new Status(2, TemplatePlugin.ID, 170, message, null);
    }
}

