/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.validation.validator;

import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.validation.IPropertyResolver;
import com.ibm.etools.webpage.template.validation.ITemplateValidator;
import com.ibm.etools.webpage.template.validation.PropertyValueUtil;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FramesetInstanceValidator
implements ITemplateValidator {
    public IStatus validate(String type, IPropertyResolver instance, IPropertyResolver template) {
        if (instance.hasProperty("page.model")) {
            IDOMModel model = (IDOMModel)instance.getProperty("page.model");
            if (SelectRegionsUtil.isFrameset(model)) {
                return this.createError();
            }
            return Status.OK_STATUS;
        }
        if (instance.hasProperty("page.doctype")) {
            Collection docTypes = PropertyValueUtil.asCollection((Object)instance.getProperty("page.doctype"));
            if (!docTypes.isEmpty()) {
                boolean hasOtherThanFrameset = false;
                for (String docType : docTypes) {
                    if (docType.indexOf("Frameset") != -1) continue;
                    hasOtherThanFrameset = true;
                    break;
                }
                if (!hasOtherThanFrameset) {
                    return this.createError();
                }
            }
            return Status.OK_STATUS;
        }
        return null;
    }

    private IStatus createError() {
        return new Status(4, TemplatePlugin.ID, 150, WizardFileUtil.MSG_FRAMESET, null);
    }
}

