/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.validation.props;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplGet;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.validation.IPropertyResolverContributor;
import com.ibm.etools.webpage.template.validation.IPropertyResolverForContributor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ModelBasedPagePropRslvContributor
implements IPropertyResolverContributor {
    private IDOMModel model;

    public Set getPropertySet() {
        HashSet<String> result = new HashSet<String>(1);
        result.add("page.model");
        result.add("page.content-area");
        result.add("page.doctype");
        result.add("page.xml-syntax");
        result.add("page.template");
        result.add("page.template-type");
        result.add("template.content-area");
        result.add("template.type");
        return result;
    }

    public boolean hasProperty(String propertyName, IPropertyResolverForContributor parent) {
        return this.getModel() != null && ("page.model".equals(propertyName) || "page.content-area".equals(propertyName) || "page.doctype".equals(propertyName) || "page.xml-syntax".equals(propertyName) || "page.template".equals(propertyName) || "page.template-type".equals(propertyName) || "template.content-area".equals(propertyName) || "template.type".equals(propertyName));
    }

    public Object getProperty(String propertyName, IPropertyResolverForContributor parent) {
        if (this.getModel() != null) {
            if ("page.model".equals(propertyName)) {
                return this.getModel();
            }
            if ("page.content-area".equals(propertyName)) {
                ArrayList<String> result = new ArrayList<String>();
                TemplateModel tm = new TemplateModelSession().getTemplateModel((IStructuredModel)this.getModel());
                List putNodes = TemplateTypeUtil.collectPutNode((TemplateModel)tm);
                if (putNodes != null) {
                    for (TplPut put : putNodes) {
                        result.add(put.getName());
                    }
                }
                return result;
            }
            if ("page.doctype".equals(propertyName)) {
                return this.getModel().getDocument().getDocumentTypeId();
            }
            if ("page.xml-syntax".equals(propertyName)) {
                boolean modelSyntax = this.getModel().getDocument().isJSPType() && this.getModel().getDocument().isJSPDocument();
                return modelSyntax;
            }
            if ("page.template".equals(propertyName)) {
                IFile tplFile = TemplateTypeUtil.getTemplateFileOf((IStructuredModel)this.getModel());
                return tplFile;
            }
            if ("page.template-type".equals(propertyName)) {
                IFile tplFile = TemplateTypeUtil.getTemplateFileOf((IStructuredModel)this.getModel());
                if (tplFile == null) {
                    return null;
                }
                String type = FileTypeHandler.getFileType((IFile)tplFile);
                if (type == "htpl") {
                    return "htpl";
                }
                if (type == "jtpl") {
                    return "jtpl";
                }
                return null;
            }
            if ("template.content-area".equals(propertyName)) {
                ArrayList<String> result = new ArrayList<String>();
                TemplateModel tm = new TemplateModelSession().getTemplateModel((IStructuredModel)this.getModel());
                List getNodes = TemplateTypeUtil.collectGetNode((TemplateModel)tm);
                if (getNodes != null) {
                    for (TplGet get : getNodes) {
                        result.add(get.getName());
                    }
                }
                return result;
            }
            if ("template.type".equals(propertyName)) {
                IPath path;
                if (parent.hasProperty("page.path") && (path = (IPath)parent.getProperty("page.path")) != null) {
                    String type = FileTypeHandler.getFileType((String)path.lastSegment());
                    if (type == "htpl") {
                        return "htpl";
                    }
                    if (type == "jtpl") {
                        return "jtpl";
                    }
                }
                return null;
            }
        }
        throw new IllegalArgumentException(propertyName);
    }

    public boolean init(String type, IPropertyResolverForContributor parent) {
        IPath path;
        IStructuredModel candidate = null;
        if (parent.hasProperty("page.file")) {
            IFile file = (IFile)parent.getProperty("page.file");
            if (file != null && file.exists()) {
                candidate = new ModelManagerUtil(null, null).getModelForRead(file);
            }
        } else if (parent.hasProperty("page.path") && (path = (IPath)parent.getProperty("page.path")) != null && path.toFile().exists()) {
            candidate = new ModelManagerUtil(null, null).getModelForRead(path);
        }
        if (candidate instanceof IDOMModel) {
            this.model = (IDOMModel)candidate;
        } else if (candidate != null) {
            candidate.releaseFromRead();
        }
        return this.model != null;
    }

    public void clear() {
        if (this.model != null) {
            this.model.releaseFromRead();
        }
        this.model = null;
    }

    protected IDOMModel getModel() {
        return this.model;
    }
}

