/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.utils;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentHeadContentDetector;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentCharsetDetector;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentCharsetDetector;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public final class ModelManagerUtil {
    private com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil instance = null;

    public ModelManagerUtil(Shell shell, String title) {
        this.instance = new com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil(shell, title);
    }

    public IStructuredModel getModelForEdit(Object id, IFile input, IPath fullIPath, IProject project, Object modelType) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getModelForEdit(id, input, fullIPath, project, modelType);
    }

    public IStructuredModel getModelForRead(Object id, IFile input, IPath fullIPath, IProject project, Object modelType) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getModelForRead(id, input, fullIPath, project, modelType);
    }

    public IStructuredModel getModelForEdit(IFile input) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getModelForEdit(input);
    }

    public IStructuredModel getModelForRead(IFile input) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getModelForRead(input);
    }

    public IStructuredModel getModelForEdit(IPath location) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getModelForEdit(location);
    }

    public IStructuredModel getModelForRead(IPath location) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getModelForRead(location);
    }

    public IStructuredModel getNewModelForEdit(IFile input) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getNewModelForEdit(input);
    }

    public IStructuredModel getNewModelForEdit(IFile input, IStructuredModel refModel, boolean frameSet) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getNewModelForEdit(input, refModel, frameSet);
    }

    public IStructuredModel getNewModelForRead(IFile input) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getNewModelForRead(input);
    }

    public IStructuredModel getNewModelForRead(IFile input, IStructuredModel refModel, boolean frameSet) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getNewModelForRead(input, refModel, frameSet);
    }

    public static boolean isHTMLFamily(IStructuredModel model) {
        return com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil.isHTMLFamily(model);
    }

    public static void openUnsupportedEncodingWarningForLoad(String encoding, String defaultToUse, String title, Shell shell) {
        com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil.openUnsupportedEncodingWarningForLoad(encoding, defaultToUse, title, shell);
    }

    public static IStatus validateEdit(IStructuredModel model, Shell context, boolean nonExistAsWritable) {
        return com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil.validateEdit(model, context, nonExistAsWritable);
    }

    public static IStatus validateEdit(IFile file, Shell context, boolean nonExistAsWritable) {
        return com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil.validateEdit(file, context, nonExistAsWritable);
    }

    public static boolean isWML(IDOMDocument document) {
        return com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil.isWML(document);
    }

    public static IPath getLocation(IResource resource) {
        return com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil.getLocation(resource);
    }

    public static void updateEncodingMemento(IStructuredModel model) {
        IStructuredDocument doc = model.getStructuredDocument();
        EncodingMemento memento = doc.getEncodingMemento();
        IDocumentCharsetDetector detector = model.getModelHandler().getDocumentLoader().getDocumentEncodingDetector();
        if (memento != null && detector != null) {
            detector.set((IDocument)doc);
        }
        EncodingMemento newMemento = null;
        try {
            if (detector instanceof HTMLDocumentCharsetDetector) {
                newMemento = ((HTMLDocumentCharsetDetector)detector).getEncodingMemento();
            } else if (detector instanceof JSPDocumentHeadContentDetector) {
                newMemento = ((JSPDocumentHeadContentDetector)detector).getEncodingMemento();
            } else if (detector instanceof XMLDocumentCharsetDetector) {
                newMemento = ((XMLDocumentCharsetDetector)detector).getEncodingMemento();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (newMemento != null) {
            doc.setEncodingMemento(newMemento);
        }
    }

    public static String getBaseLocation(IStructuredModel model) {
        String baseLocation = null;
        if (model != null) {
            URIResolver resolver = model.getResolver();
            if (resolver != null) {
                baseLocation = resolver.getFileBaseLocation();
            }
            if (baseLocation == null) {
                baseLocation = model.getBaseLocation();
            }
            if (baseLocation != null) {
                Path path = new Path(baseLocation);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFileForLocation((IPath)path);
                if (file == null && path.segmentCount() > 1) {
                    file = root.getFile((IPath)path);
                }
                if (file != null) {
                    baseLocation = file.getLocation().toString();
                }
            }
        }
        return baseLocation != null ? baseLocation : new String();
    }

    public static String calculateSSEModelId(IFile file) {
        return StructuredModelManager.getModelManager().calculateId(file);
    }

    public static Object calculateModelId(String filename) {
        if (filename == null) {
            return null;
        }
        Path path = new Path(filename);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)path);
        if (file == null) {
            file = root.getFile((IPath)path);
        }
        return ModelManagerUtil.calculateModelId(file);
    }

    public static Object calculateModelId(IEditorInput input) {
        if (input == null) {
            return null;
        }
        IFile file = (IFile)input.getAdapter(IFile.class);
        return ModelManagerUtil.calculateModelId(file);
    }

    public static Object calculateModelId(IFile file) {
        return StructuredModelManager.getModelManager().calculateId(file);
    }
}

