/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.utils;

import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.web.URIUtil;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class LinkUtils {
    public static Set<ILink> getILinksOfText(IResource withinResource, String linkText, IProgressMonitor monitor) throws ReferenceException {
        Assert.isNotNull((Object)withinResource);
        Assert.isNotNull((Object)linkText);
        SearchPattern patternOne = null;
        SearchPattern patternTwo = null;
        SearchPattern patternThree = null;
        patternOne = SearchPattern.createPattern((String)linkText, (SearchType)SearchType.BY_LINKTEXT, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        patternTwo = SearchPattern.createPattern((String)("\"" + linkText + "\""), (SearchType)SearchType.BY_LINKTEXT, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        patternThree = SearchPattern.createPattern((String)("'" + linkText + "'"), (SearchType)SearchType.BY_LINKTEXT, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern firstLeft = SearchPattern.createOrPattern((SearchPattern)patternOne, (SearchPattern)patternTwo);
        SearchPattern firstFinal = null;
        firstFinal = SearchPattern.createOrPattern((SearchPattern)firstLeft, (SearchPattern)patternThree);
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{withinResource});
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.search(firstFinal, scope, (SearchRequestor)requestor, monitor);
        return requestor.getMatches();
    }

    public static ILink getILinkFor(IFile sourceFile, IDOMAttr attribute, IProgressMonitor monitor) throws ReferenceException {
        Assert.isNotNull((Object)sourceFile);
        Assert.isNotNull((Object)attribute);
        int valueStartOffset = attribute.getValueRegionStartOffset();
        int valueLength = attribute.getValueRegionText() == null ? 0 : attribute.getValueRegionText().length();
        TextRange attributeRange = new TextRange(valueStartOffset, valueLength, 0);
        IDOMElement contextNode = (IDOMElement)attribute.getParentNode();
        contextNode = contextNode == null ? (IDOMElement)attribute.getOwnerElement() : contextNode;
        int contextStartOffset = contextNode.getStartOffset();
        int contextLength = contextNode.getEndOffset() - contextStartOffset;
        TextRange contextRange = new TextRange(contextStartOffset, contextLength, 0);
        LinkNode fileForNodes = ReferenceManager.getReferenceManager().getLinkNode(sourceFile);
        Collection links = fileForNodes.getLinks(monitor);
        for (ILink link : links) {
            TextRange txtRange = link.getLinkLocation();
            if (!attributeRange.contains(txtRange) || !contextRange.contains(link.getContextLocation())) continue;
            return link;
        }
        return null;
    }

    public static Set<ILink> getILinksOfType(IResource withinResource, String linkType, IProgressMonitor monitor) throws ReferenceException {
        Assert.isNotNull((Object)withinResource);
        SearchPattern pattern = null;
        pattern = linkType == null ? SearchPattern.createPattern((String)"*", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)2) : SearchPattern.createPattern((String)linkType, (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{withinResource});
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, monitor);
        return requestor.getMatches();
    }

    public static IFile getTargetOfILink(ILink link, IProgressMonitor monitor) throws ReferenceException {
        IResolvedReference rr;
        ILink target;
        Assert.isNotNull((Object)link);
        Collection refs = link.resolveReference("web.reference.workspacePath", monitor);
        if (!refs.isEmpty() && (target = (rr = (IResolvedReference)refs.iterator().next()).getTarget()) != null) {
            return (IFile)target.getContainer().getResource();
        }
        return null;
    }

    public static String makeRelative(ILink link, IPath currentFilePath, boolean addQuotes) {
        return LinkUtils.makeRelative(link.getLinkText(), currentFilePath, addQuotes);
    }

    public static String makeRelative(String linkText, IPath currentFilePath, boolean addQuotes) {
        IPath newFilePath = currentFilePath;
        if (linkText.startsWith("\"")) {
            linkText = linkText.substring(1, linkText.length());
        }
        if (linkText.endsWith("\"")) {
            linkText = linkText.substring(0, linkText.length() - 1);
        }
        URIUtil.ParsedURI URIParsed = URIUtil.parse((String)linkText);
        String schemeURI = URIParsed.scheme;
        boolean fileURI = false;
        if (schemeURI != null && schemeURI.startsWith("file")) {
            fileURI = true;
        }
        if (fileURI) {
            Path linkPath = new Path(URIParsed.path);
            int matchingSegments = linkPath.matchingFirstSegments(newFilePath);
            int currentFileSegmentCount = newFilePath.segmentCount();
            int segmentsToDot = currentFileSegmentCount - matchingSegments - 1;
            linkPath = linkPath.removeFirstSegments(matchingSegments);
            linkPath = linkPath.makeRelative();
            String relativeLink = linkPath.toString();
            relativeLink = relativeLink.replaceAll(linkPath.getDevice(), "");
            int i = 0;
            while (i < segmentsToDot) {
                relativeLink = "../".concat(relativeLink);
                ++i;
            }
            if (addQuotes && !relativeLink.endsWith("\"")) {
                relativeLink = relativeLink.concat("\"");
            }
            if (addQuotes && !relativeLink.startsWith("\"")) {
                relativeLink = "\"".concat(relativeLink);
            }
            return relativeLink;
        }
        return null;
    }

    public static String getAbsoluteLink(ILink link) {
        Collection referenceCollection = link.resolveReference(null, null);
        for (IResolvedReference reference : referenceCollection) {
            if (reference.getBrokenStatus() != BrokenStatus.NOTBROKEN) continue;
            IResource targetResource = reference.getTarget().getContainer().getResource();
            String filePath = targetResource.getLocation().toString();
            return filePath;
        }
        return null;
    }

    public static String getTagOfLink(ILink link) {
        String tagname = null;
        String contextText = link.getContextText();
        String[] params = contextText.split("[^a-zA-Z]+", 2);
        tagname = params[1];
        return tagname;
    }

    public static IStructuredModel getModel(IStructuredDocument document, URIResolver resolver, String baseLocationId) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without a document reference");
            throw iae;
        }
        String contentType = ContentTypeIdForJSP.ContentTypeID_JSP;
        IStructuredModel model = null;
        IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(contentType);
        IModelLoader loader = handler.getModelLoader();
        model = loader.createModel(document, baseLocationId, handler);
        try {
            model.setId(baseLocationId);
            if (model instanceof AbstractStructuredModel) {
                ((AbstractStructuredModel)model).setContentTypeIdentifier(contentType);
            }
            model.setResolver(resolver);
            model.setDirtyState(true);
        }
        catch (ResourceInUse resourceInUse) {
            model = null;
        }
        return model;
    }

    public static IStructuredModel getModelForCSS(IStructuredDocument document, URIResolver resolver, String baseLocationId) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without a document reference");
            throw iae;
        }
        String contentType = ContentTypeIdForCSS.ContentTypeID_CSS;
        IStructuredModel model = null;
        IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(contentType);
        IModelLoader loader = handler.getModelLoader();
        model = loader.createModel(document, baseLocationId, handler);
        try {
            model.setId(baseLocationId);
            if (model instanceof AbstractStructuredModel) {
                ((AbstractStructuredModel)model).setContentTypeIdentifier(contentType);
            }
            model.setResolver(resolver);
            model.setDirtyState(true);
        }
        catch (ResourceInUse resourceInUse) {
            model = null;
        }
        return model;
    }

    public static void parseRawLink(String newRawLink, String[] links) {
        String raw;
        String frag;
        String query;
        int extraIndex;
        links[0] = "";
        links[1] = "";
        links[2] = "";
        if (newRawLink == null) {
            newRawLink = "";
        }
        if ((extraIndex = (newRawLink = newRawLink.trim()).indexOf(63)) != -1) {
            query = newRawLink.substring(extraIndex);
            newRawLink = newRawLink.substring(0, extraIndex);
        } else {
            query = "";
        }
        int length = newRawLink.length();
        int poundIndex = -1;
        if (length > 0) {
            int i = length - 1;
            while (i >= 0) {
                char ch = newRawLink.charAt(i);
                if (ch == '#') {
                    poundIndex = i;
                    break;
                }
                if (ch == '/' && (i == length - 1 || newRawLink.charAt(i + 1) != '>')) break;
                --i;
            }
        }
        if (poundIndex != -1) {
            frag = newRawLink.substring(poundIndex);
            raw = newRawLink.substring(0, poundIndex);
        } else {
            frag = "";
            raw = newRawLink;
        }
        links[0] = raw;
        links[1] = frag;
        links[2] = query;
    }
}

