/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.utils;

import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.links.util.InvalidURLException;
import com.ibm.etools.webedit.links.util.ModuleUtil;
import com.ibm.etools.webedit.links.util.URI;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.xve.renderer.utils.URLContext;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkUtil {
    public static String resolveBaseLocation(EditPart part) {
        if (part == null) {
            return null;
        }
        Document doc = ((NodeEditPart)part).getNode().getOwnerDocument();
        if (doc == null) {
            doc = (Document)((NodeEditPart)part).getNode();
        }
        IDOMModel model = ((IDOMNode)doc).getModel();
        return LinkUtil.resolveBaseLocation(part, ModelManagerUtil.getBaseLocation((IStructuredModel)model));
    }

    public static String resolveBaseLocation(EditPart part, String baseLocation) {
        RootEditPart root;
        String baseHref;
        if (part == null) {
            return null;
        }
        if (part.getViewer() != null && (baseHref = LinkUtil.findBaseLocation((EditPart)((root = part.getViewer().getRootEditPart()) != null ? root : part))) != null) {
            baseLocation = LinkUtil.getAbsURL((IPath)new Path(baseLocation), (IPath)new Path(baseLocation), baseHref, true);
        }
        return baseLocation;
    }

    protected static String findBaseLocation(EditPart part) {
        List children = part.getChildren();
        int numChild = children != null ? children.size() : 0;
        int i = 0;
        while (i < numChild) {
            EditPart childPart = (EditPart)children.get(i);
            if (!LinkUtil.cannotHaveBase(childPart)) {
                String base = LinkUtil.getBaseLocation(childPart);
                if (base != null && !base.isEmpty()) {
                    return base;
                }
                List subChildren = childPart.getChildren();
                if (subChildren != null && subChildren.size() > 0 && (base = LinkUtil.findBaseLocation(childPart)) != null) {
                    return base;
                }
            }
            ++i;
        }
        return null;
    }

    protected static String getBaseLocation(EditPart part) {
        Node node;
        if (part instanceof NodeEditPart && (node = ((NodeEditPart)part).getNode()).getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("BASE")) {
            return LinkUtil.getBaseHref(node);
        }
        return null;
    }

    protected static boolean cannotHaveBase(EditPart part) {
        Node ele;
        return part instanceof ElementEditPart && (ele = ((ElementEditPart)part).getNode()) != null && ele.getNodeType() == 1 && ele.getNodeName().equalsIgnoreCase("BODY");
    }

    public static String resolveBaseLocation(IStructuredModel baseModel) {
        IDOMModel xmlmodel;
        IDOMDocument doc;
        NodeList nl;
        String baseLocation = ModelManagerUtil.getBaseLocation(baseModel);
        String baseHref = null;
        if (ModelManagerUtil.isHTMLFamily(baseModel) && (nl = (doc = (xmlmodel = (IDOMModel)baseModel).getDocument()).getElementsByTagName("BASE")) != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Node baseNode = nl.item(i);
                if (baseNode != null) {
                    baseHref = LinkUtil.getBaseHref(baseNode);
                }
                if (baseHref != null) break;
                ++i;
            }
        }
        if (baseHref != null) {
            baseLocation = LinkUtil.getAbsURL((IPath)new Path(baseLocation), (IPath)new Path(baseLocation), baseHref, true);
        }
        return baseLocation;
    }

    private static String getBaseHref(Node baseNode) {
        String scheme;
        String attrValue;
        Node attrNode;
        String baseHref = null;
        NamedNodeMap attrNodes = baseNode.getAttributes();
        if (attrNodes != null && (attrNode = attrNodes.getNamedItem("HREF")) != null && (attrValue = attrNode.getNodeValue()) != null && (baseHref = attrValue.trim()) != null && ((scheme = URI.getOnlyScheme((String)baseHref)) == null || scheme.trim().length() == 0)) {
            return "";
        }
        return baseHref;
    }

    public static String getAbsURL(IPath baseLocation, IPath srcLocation, String src, boolean contextRootSensitive) {
        if (src == null) {
            return null;
        }
        if (srcLocation == null || srcLocation.isEmpty() || src.isEmpty()) {
            return src;
        }
        if (URI.getOnlyScheme((String)src).equalsIgnoreCase("file")) {
            URIUtil.ParsedURI parsedURI = URIUtil.parse((String)src);
            FileURL fileURL = null;
            try {
                fileURL = new FileURL(src);
            }
            catch (InvalidURLException invalidURLException) {}
            if (fileURL != null) {
                return fileURL.getPath().toString();
            }
            return parsedURI.path;
        }
        EnumSet<ProviderArguments> args = EnumSet.of(ProviderArguments.LINKSTYLE_ABSOLUTE);
        SpecializedType linkType = ReferenceManager.getReferenceManager().getLinkType("web.commonlink");
        IFile wsFile = WebComponent.getFileForLocation(srcLocation);
        if (wsFile == null && (wsFile = WebComponent.getFileForLocation(baseLocation)) == null) {
            URIUtil.ParsedURI uri = URIUtil.parse((String)src);
            if (uri.scheme != null || uri.authority != null) {
                return src;
            }
            String absUrl = srcLocation.removeLastSegments(1) + "/" + src;
            return absUrl;
        }
        String linkText = ReferenceManager.getReferenceManager().expandLinkText(linkType, src, (IResource)wsFile, args);
        if (!(linkText = AbstractWebProvider.trimQuotes((String)linkText)).startsWith("file://") && (linkText = URIUtil.makeAbsoluteURI((String)("file:////" + baseLocation.toString()), (String)src)).indexOf("file/") >= 0) {
            linkText = linkText.split("file/")[1];
        }
        if (linkText != null && ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(linkText)) != null) {
            return linkText;
        }
        if (src.startsWith("/")) {
            IProject projectPath = WebComponent.getProjectForLocation(srcLocation);
            String absUrl = null;
            Path tempSrcPath = new Path(src);
            String contextRoot = ModuleUtil.getServerContextRoot((IProject)projectPath);
            if (tempSrcPath.toString().startsWith("/" + contextRoot)) {
                tempSrcPath = tempSrcPath.removeFirstSegments(1);
            }
            String docRootLocation = ModuleUtil.getDocumentRootLocation((IProject)projectPath);
            Path docRootLocationPath = new Path(docRootLocation);
            IPath completePath = docRootLocationPath.append((IPath)tempSrcPath);
            absUrl = completePath.toString();
            return absUrl;
        }
        if (src.startsWith(".") || src.matches("^[a-zA-Z0-9]+")) {
            String absURL = URIUtil.makeAbsoluteURI((String)("file://////" + baseLocation.toString()), (String)src);
            if (absURL.startsWith("file///")) {
                absURL = absURL.replaceFirst("file///", "");
            }
            return absURL;
        }
        String expandedLink = ReferenceManager.getReferenceManager().expandLinkText(ReferenceManager.getReferenceManager().getLinkType("web.commonlink"), src, (IResource)WebComponent.getFileForLocation(srcLocation), EnumSet.of(ProviderArguments.LINKSTYLE_ABSOLUTE));
        URIUtil.ParsedURI parsedPath = URIUtil.parse((String)expandedLink);
        String fileName = parsedPath.path;
        Path path = new Path(fileName);
        if (path.segmentCount() == 1) {
            path = srcLocation.removeLastSegments(1).append((IPath)path);
        }
        if ((fileName = path.toString()).startsWith("/")) {
            fileName = fileName.substring(1, fileName.length());
        }
        if (fileName != null && fileName.length() > 0) {
            return fileName;
        }
        return null;
    }

    public static String getAbsURL(URLContext context, String src, String tagName, String attrName) {
        IPath base = LinkUtil.getBase(context, tagName);
        boolean contextRootSensitive = LinkUtil.isContextRootSensitiveLink(base, src, tagName, attrName);
        return LinkUtil.getAbsURL(base, context.getFileBase(), src, contextRootSensitive);
    }

    private static IPath getBase(URLContext context, String tagName) {
        if (tagName.equalsIgnoreCase("jsp:directive.include") || tagName.equalsIgnoreCase("jsp:directive.page") || tagName.equalsIgnoreCase("jsp:directive.taglib")) {
            return context.getFileBase();
        }
        if (tagName.indexOf(58) > 0) {
            return context.getPageBase();
        }
        if (tagName.equals("tpl:insert") || tagName.equals("tpl:put") || tagName.equals("tpl:metadata")) {
            return context.getFileBase();
        }
        return context.getLinkBase();
    }

    private static boolean isContextRootSensitiveLink(IPath location, String src, String tagName, String attrName) {
        return true;
    }

    public static URLContext createURLContextFor(IStructuredModel model) {
        Path file = new Path(ModelManagerUtil.getBaseLocation(model));
        Path link = new Path(LinkUtil.resolveBaseLocation(model));
        return new URLContext((IPath)file, (IPath)link){
            private final /* synthetic */ IPath val$file;
            private final /* synthetic */ IPath val$link;
            {
                this.val$file = iPath;
                this.val$link = iPath2;
            }

            public IPath getFileBase() {
                return this.val$file;
            }

            public IPath getPageBase() {
                return this.val$file;
            }

            public IPath getLinkBase() {
                return this.val$link;
            }
        };
    }

    public static IPath getFilePath(URLContext context, String src, String tagName, String attrName, boolean resolveMapping) {
        if (src == null) {
            return null;
        }
        String absURL = null;
        absURL = context != null ? LinkUtil.getAbsURL(context, src, tagName, attrName) : src;
        if (absURL == null || absURL.length() == 0) {
            return null;
        }
        Path filePath = null;
        String scheme = URI.getOnlyScheme((String)absURL);
        if (scheme != null && scheme.length() > 0) {
            if (scheme.compareToIgnoreCase("file") == 0) {
                try {
                    FileURL fileURL = new FileURL(absURL);
                    filePath = fileURL.getPath();
                }
                catch (InvalidURLException e) {
                    Logger.log(e);
                }
            }
        } else {
            IPath path;
            if (absURL != null && (path = new URI(absURL).getPath()) != null) {
                absURL = path.toString();
            }
            filePath = new Path(absURL);
        }
        if (resolveMapping && filePath != null && context != null) {
            WebComponent webComponent = new WebComponent((IResource)WebComponent.getFileForLocation(context.getLinkBase()));
            boolean[] types = new boolean[2];
            try {
                IPath newLocalFilePath = webComponent.getRealLocationOfIPath((IPath)filePath, types);
                if (types[1]) {
                    filePath = newLocalFilePath;
                }
            }
            finally {
                webComponent.dispose();
            }
        }
        return filePath;
    }

    public static boolean isValidInlineFrameSource(IDOMModel model, URLContext context, String src, String tagName, String attrName) {
        String absUrl;
        String baseLocation;
        return model != null && context != null && src != null && (baseLocation = ModelManagerUtil.getBaseLocation((IStructuredModel)model)) != null && baseLocation.compareToIgnoreCase(absUrl = LinkUtil.getAbsURL(context, src, tagName, attrName)) != 0;
    }

    public static void releaseModel(IStructuredModel model, boolean forEdit) {
        if (forEdit) {
            model.releaseFromEdit();
        } else {
            model.releaseFromRead();
        }
    }

    public static IStructuredModel getModel(URLContext context, Node node, String src, boolean forEdit, boolean newModel, boolean frameSet, String tagName, String attrName) {
        IStructuredModel ret = null;
        IPath path = LinkUtil.getFilePath(context, src, tagName, attrName, true);
        if (path != null) {
            IFile file = WebComponent.getFileForLocation(path);
            if (file == null) {
                return null;
            }
            IModelManager mm = StructuredModelManager.getModelManager();
            String sseId = ModelManagerUtil.calculateSSEModelId(file);
            ret = forEdit ? mm.getExistingModelForEdit((Object)sseId) : mm.getExistingModelForRead((Object)sseId);
            if (ret == null) {
                ModelManagerUtil mmu = new ModelManagerUtil(null, null);
                if (forEdit) {
                    ret = mmu.getModelForEdit(file);
                    if (ret == null && newModel) {
                        IDOMModel refModel = node instanceof IDOMNode ? ((IDOMNode)node).getModel() : null;
                        ret = mmu.getNewModelForEdit(file, (IStructuredModel)refModel, frameSet);
                    }
                } else {
                    ret = mmu.getModelForRead(file);
                    if (ret == null && newModel) {
                        IDOMModel refModel = node instanceof IDOMNode ? ((IDOMNode)node).getModel() : null;
                        ret = mmu.getNewModelForRead(file, (IStructuredModel)refModel, frameSet);
                    }
                }
            }
            if (ret != null && !ModelManagerUtil.isHTMLFamily(ret)) {
                if (forEdit) {
                    ret.releaseFromEdit();
                } else {
                    ret.releaseFromRead();
                }
                ret = null;
            }
        }
        return ret;
    }

    public static IStructuredModel getModel(URLContext context, String src, boolean forEdit, String tagName, String attrName) {
        return LinkUtil.getModel(context, null, src, forEdit, false, false, tagName, attrName);
    }

    public static IStructuredModel getModel(URLContext context, Node node, String src, boolean forEdit, boolean newModel, String tagName, String attrName) {
        return LinkUtil.getModel(context, node, src, forEdit, newModel, false, tagName, attrName);
    }

    public static boolean needsEncoding(IDOMModel model) {
        return true;
    }
}

