/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.utils;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class HTMLViewerUtil {
    public static boolean scrollByKey(EditPartViewer viewer, int keyCode) {
        switch (keyCode) {
            case 0x1000001: {
                return HTMLViewerUtil.scrollUp(viewer);
            }
            case 0x1000002: {
                return HTMLViewerUtil.scrollDown(viewer);
            }
            case 0x1000003: {
                return HTMLViewerUtil.scrollLeft(viewer);
            }
            case 0x1000004: {
                return HTMLViewerUtil.scrollRight(viewer);
            }
            case 0x1000007: {
                return HTMLViewerUtil.scrollHome(viewer);
            }
            case 0x1000008: {
                return HTMLViewerUtil.scrollToEnd(viewer);
            }
            case 0x1000005: {
                return HTMLViewerUtil.scrollPageUp(viewer);
            }
            case 0x1000006: {
                return HTMLViewerUtil.scrollPageDown(viewer);
            }
        }
        return false;
    }

    public static boolean scrollUp(EditPartViewer viewer) {
        int incY = HTMLViewerUtil.getIncrementY(viewer);
        incY = incY != 0 ? incY : 10;
        Point delta = HTMLViewerUtil.scrollBy(viewer, 0, -incY);
        return delta.x != 0 || delta.y != 0;
    }

    public static boolean scrollDown(EditPartViewer viewer) {
        int incY = HTMLViewerUtil.getIncrementY(viewer);
        incY = incY != 0 ? incY : 10;
        Point delta = HTMLViewerUtil.scrollBy(viewer, 0, incY);
        return delta.x != 0 || delta.y != 0;
    }

    public static boolean scrollLeft(EditPartViewer viewer) {
        int incX = HTMLViewerUtil.getIncrementX(viewer);
        incX = incX != 0 ? incX : 10;
        Point delta = HTMLViewerUtil.scrollBy(viewer, -incX, 0);
        return delta.x != 0 || delta.y != 0;
    }

    public static boolean scrollRight(EditPartViewer viewer) {
        int incX = HTMLViewerUtil.getIncrementX(viewer);
        incX = incX != 0 ? incX : 10;
        Point delta = HTMLViewerUtil.scrollBy(viewer, incX, 0);
        return delta.x != 0 || delta.y != 0;
    }

    public static boolean scrollPageUp(EditPartViewer viewer) {
        Viewport viewport = HTMLViewerUtil.getViewport(viewer);
        if (viewport == null) {
            return false;
        }
        Canvas canvas = (Canvas)viewer.getControl();
        Point delta = null;
        delta = viewport.getVerticalRangeModel().isEnabled() ? HTMLViewerUtil.scrollBy(viewer, 0, -canvas.getClientArea().height) : HTMLViewerUtil.scrollBy(viewer, -canvas.getClientArea().width, 0);
        return delta.x != 0 || delta.y != 0;
    }

    public static boolean scrollPageDown(EditPartViewer viewer) {
        Viewport viewport = HTMLViewerUtil.getViewport(viewer);
        if (viewport == null) {
            return false;
        }
        Canvas canvas = (Canvas)viewer.getControl();
        Point delta = null;
        delta = viewport.getVerticalRangeModel().isEnabled() ? HTMLViewerUtil.scrollBy(viewer, 0, canvas.getClientArea().height) : HTMLViewerUtil.scrollBy(viewer, canvas.getClientArea().width, 0);
        return delta.x != 0 || delta.y != 0;
    }

    public static boolean scrollHome(EditPartViewer viewer) {
        Viewport viewport = HTMLViewerUtil.getViewport(viewer);
        if (viewport == null) {
            return false;
        }
        Point delta = null;
        delta = viewport.getVerticalRangeModel().isEnabled() ? HTMLViewerUtil.scrollBy(viewer, 0, -viewport.getVerticalRangeModel().getValue()) : HTMLViewerUtil.scrollBy(viewer, -viewport.getHorizontalRangeModel().getValue(), 0);
        return delta.x != 0 || delta.y != 0;
    }

    public static boolean scrollToEnd(EditPartViewer viewer) {
        Viewport viewport = HTMLViewerUtil.getViewport(viewer);
        if (viewport == null) {
            return false;
        }
        Point delta = null;
        delta = viewport.getVerticalRangeModel().isEnabled() ? HTMLViewerUtil.scrollBy(viewer, 0, viewport.getVerticalRangeModel().getMaximum()) : HTMLViewerUtil.scrollBy(viewer, viewport.getHorizontalRangeModel().getMaximum(), 0);
        return delta.x != 0 || delta.y != 0;
    }

    public static Point scrollBy(EditPartViewer viewer, int deltaX, int deltaY) {
        Point point = new Point(0, 0);
        Viewport viewport = HTMLViewerUtil.getViewport(viewer);
        if (viewport == null) {
            return point;
        }
        Rectangle bounds = viewport.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return point;
        }
        if (deltaX != 0) {
            int extentX;
            int curX = viewport.getViewLocation().x;
            int newX = curX + deltaX;
            int minX = viewport.getHorizontalRangeModel().getMinimum();
            int maxX = viewport.getHorizontalRangeModel().getMaximum();
            if (newX > maxX - (extentX = viewport.getHorizontalRangeModel().getExtent())) {
                newX = maxX - extentX;
            }
            if (newX < minX) {
                newX = minX;
            }
            if (viewport.getHorizontalRangeModel().getValue() != newX) {
                viewport.getHorizontalRangeModel().setValue(newX);
                point.x = viewport.getHorizontalRangeModel().getValue() - curX;
            }
        }
        if (deltaY != 0) {
            int extentY;
            int curY = viewport.getViewLocation().y;
            int newY = curY + deltaY;
            int minY = viewport.getVerticalRangeModel().getMinimum();
            int maxY = viewport.getVerticalRangeModel().getMaximum();
            if (newY > maxY - (extentY = viewport.getVerticalRangeModel().getExtent())) {
                newY = maxY - extentY;
            }
            if (newY < minY) {
                newY = minY;
            }
            if (viewport.getVerticalRangeModel().getValue() != newY) {
                viewport.getVerticalRangeModel().setValue(newY);
                point.y = viewport.getVerticalRangeModel().getValue() - curY;
            }
        }
        if (point.x != 0 || point.y != 0) {
            viewer.flush();
        }
        return point;
    }

    private static int getIncrementX(EditPartViewer viewer) {
        if (viewer == null) {
            return 0;
        }
        Control control = viewer.getControl();
        if (!(control instanceof Scrollable) || control.isDisposed()) {
            return 0;
        }
        ScrollBar bar = ((Scrollable)control).getHorizontalBar();
        if (bar != null && !bar.isDisposed()) {
            return bar.getIncrement();
        }
        return 0;
    }

    private static int getIncrementY(EditPartViewer viewer) {
        if (viewer == null) {
            return 0;
        }
        Control control = viewer.getControl();
        if (!(control instanceof Scrollable) || control.isDisposed()) {
            return 0;
        }
        ScrollBar bar = ((Scrollable)control).getVerticalBar();
        if (bar != null && !bar.isDisposed()) {
            return bar.getIncrement();
        }
        return 0;
    }

    private static Viewport getViewport(EditPartViewer viewer) {
        Viewport viewport = null;
        Canvas canvas = (Canvas)viewer.getControl();
        if (canvas instanceof FigureCanvas && (viewport = ((FigureCanvas)canvas).getViewport()) != null && viewport.isEnabled() && viewport.isVisible()) {
            return viewport;
        }
        return null;
    }
}

