/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.thumbnails;

import com.ibm.etools.webedit.frame.FrameLayouter;
import com.ibm.etools.webedit.frame.FrameLayouterImpl;
import com.ibm.etools.webedit.frame.FrameManager;
import com.ibm.etools.webedit.imagetool.internal.filter.ResizeOp;
import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import com.ibm.etools.webedit.viewer.internal.HTMLViewPartFactory;
import com.ibm.etools.webedit.viewer.internal.thumbnails.FrameViewFactory;
import com.ibm.etools.webedit.viewer.internal.thumbnails.FrameViewImpl;
import com.ibm.etools.webedit.viewer.thumbnails.FrameViewInitializer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FrameThumbnail {
    private Image image;
    private GC imageGC;
    private int width = 500;
    private int height = 500;
    private int targetWidth = 100;
    private int targetHeight = 100;
    private int clipWidth = this.width;
    private int clipHeight = this.height;
    private FrameLayouter frameLayouter;
    private FrameViewInitializer initializer;
    private HTMLViewPartFactory viewFactory = new HTMLViewPartFactory();

    protected void disposeImages() {
        if (this.imageGC != null) {
            this.imageGC.dispose();
            this.imageGC = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void dispose() {
        if (this.frameLayouter != null) {
            this.frameLayouter.dispose();
        }
        this.viewFactory.dispose();
        this.disposeImages();
    }

    public void setModel(IDOMModel newModel) {
        this.viewFactory.setModel(newModel);
        this.setupFrame();
    }

    public void setFile(String filename) {
        this.viewFactory.setFile(filename);
        this.setupFrame();
    }

    public boolean isValid() {
        FrameManager fm;
        if (this.frameLayouter != null && this.frameLayouter.getTopLayoutNode() != null && (fm = this.frameLayouter.getFrameManager()) != null) {
            return fm.isFrame();
        }
        return false;
    }

    private void setupFrame() {
        if (this.frameLayouter != null) {
            this.frameLayouter.dispose();
        }
        this.frameLayouter = new FrameLayouterImpl();
        this.frameLayouter.setViewFactory(new FrameViewFactory(this.getImageGC(this.width, this.height), this.initializer));
        this.frameLayouter.setModel(this.viewFactory.getModel());
        this.frameLayouter.setBounds(new Rectangle(0, 0, this.width, this.height));
    }

    public void setPageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setTargetSize(int width, int height) {
        this.targetWidth = width;
        this.targetHeight = height;
    }

    private int getTargetWidth() {
        return this.targetWidth > 0 ? this.targetWidth : this.clipWidth;
    }

    private int getTargetHeight() {
        return this.targetHeight > 0 ? this.targetHeight : this.clipHeight;
    }

    public ImageData getPageImageData() {
        this.refreshThumbnailImage();
        if (this.image == null) {
            return null;
        }
        return this.image.getImageData();
    }

    public ImageData getTargetImageData() {
        this.refreshThumbnailImage();
        Image target = new Image((Device)Display.getCurrent(), this.getTargetWidth(), this.getTargetHeight());
        GC gc = new GC((Drawable)target);
        this.draw(gc, 0, 0, false);
        ImageData data = target.getImageData();
        gc.dispose();
        target.dispose();
        return data;
    }

    private Image resizeImage(Image pageimage) {
        double zx = (double)this.getTargetWidth() / (double)this.clipWidth;
        double zy = (double)this.getTargetHeight() / (double)this.clipHeight;
        RasterImage frameimage = new RasterImage(this.image.getImageData());
        ResizeOp resizeop = TransformOp.createResizeOp(zx, zy, 2);
        HandyImage handyimage = frameimage.create(resizeop);
        ImageData imagedata = handyimage.getFrame().createImageData();
        Image targetimage = new Image(null, imagedata);
        return targetimage;
    }

    private void draw(GC gc, int x, int y, boolean refresh) {
        if (refresh) {
            this.refreshThumbnailImage();
        }
        if (this.image != null) {
            Image targetimage = this.image;
            if (this.getTargetWidth() != this.clipWidth || this.getTargetHeight() != this.clipHeight) {
                targetimage = this.resizeImage(this.image);
            }
            Rectangle imageRect = targetimage.getBounds();
            gc.drawImage(targetimage, 0, 0, imageRect.width, imageRect.height, x, y, this.getTargetWidth(), this.getTargetHeight());
            if (targetimage != this.image) {
                targetimage.dispose();
            }
        }
    }

    private void refreshThumbnailImage() {
        GC imgGC = this.getImageGC(this.width, this.height);
        if (imgGC == null) {
            return;
        }
        ((FrameViewImpl)this.frameLayouter.getTopLayoutNode().getView()).draw(imgGC);
    }

    private Image getImage(int imageWidth, int imageHeight) {
        if (this.image == null || imageWidth != this.clipWidth || imageHeight != this.clipHeight) {
            this.image = new Image((Device)Display.getCurrent(), imageWidth, imageHeight);
            this.clipWidth = imageWidth;
            this.clipHeight = imageHeight;
            if (this.imageGC != null) {
                this.imageGC.dispose();
                this.imageGC = null;
            }
        }
        return this.image;
    }

    private GC getImageGC(int imageWidth, int imageHeight) {
        Image img;
        if ((this.imageGC == null || imageWidth != this.clipWidth || imageHeight != this.clipHeight) && (img = this.getImage(imageWidth, imageHeight)) != null) {
            this.imageGC = new GC((Drawable)img);
        }
        return this.imageGC;
    }

    public void setInitializer(FrameViewInitializer initializer) {
        this.initializer = initializer;
    }
}

