/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.utils;

import com.ibm.etools.webedit.viewer.WebEditViewerPlugin;
import com.ibm.etools.webedit.viewer.internal.ResourceHandler;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerEncodingHelper;
import com.ibm.etools.webedit.viewer.utils.ContentTypeCSSUtil;
import com.ibm.etools.webedit.viewer.utils.HeaderModifier;
import com.ibm.etools.webedit.viewer.utils.ModelAdapterFactoryRegistry;
import com.ibm.etools.webtools.wizards.cgen.FilesPreferenceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentHeadContentDetector;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentCharsetDetector;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentCharsetDetector;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ModelManagerUtil {
    private static final int GET_MODEL_FOR_READ = 1;
    private static final int GET_NEW_MODEL_FOR_READ = 2;
    private static final int GET_MODEL_FOR_EDIT = 3;
    private static final int GET_NEW_MODEL_FOR_EDIT = 4;
    private Shell shell = null;
    private String title = null;
    private IModelManager modelManager = null;
    private static final String ENCODING_WARNING = ResourceHandler._UI_This_encoding___0___is_not_supported__The_default_encoding___1___will_be_used_instead__1;
    private static final String BODY_TAG = "BODY";
    private static final IStatus STATUS_OK = new Status(0, WebEditViewerPlugin.getDefault().getBundle().getSymbolicName(), 0, "OK", null);
    private static final IStatus STATUS_ERROR = new Status(4, WebEditViewerPlugin.getDefault().getBundle().getSymbolicName(), 1, "ERROR", null);

    public ModelManagerUtil(Shell shell, String title) {
        this.shell = shell;
        this.title = title;
        this.modelManager = StructuredModelManager.getModelManager();
    }

    public static IPath getLocation(IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getLocation();
        if (path == null && (path = ResourcesPlugin.getWorkspace().getRoot().getLocation()) != null) {
            path = path.addTrailingSeparator();
            path = path.append(resource.getFullPath());
        }
        return path;
    }

    private IStructuredModel getModel(int which, IFile input, IPath fullIPath) {
        return this.getModel(which, input, fullIPath, null, false, null);
    }

    private IStructuredModel getModel(int which, URL url) {
        return this.getModel(which, null, null, null, false, url);
    }

    /*
     * Exception decompiling
     */
    private IStructuredModel getModel(int which, IFile input, IPath fullIPath, IStructuredModel refModel, boolean frameSet, URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IStructuredModel retryToLoadWithDefaultEncoding(int which, IFile input, CharacterCodingException codingException, UnsupportedCharsetException charsetException) {
        boolean canRetry = true;
        boolean expectedFailure = false;
        if (input != null) {
            String foundEncoding = ModelManagerEncodingHelper.getDetectedEncoding((IFile)input).iana;
            String defaultToUse = ModelManagerEncodingHelper.getDefaultEncoding((IFile)input).iana;
            boolean bl = canRetry = !foundEncoding.equals(defaultToUse);
            if (canRetry && this.shell != null) {
                if (charsetException != null) {
                    if (!ModelManagerUtil.openUnsupportedEncodingWarningForLoad(charsetException.getCharsetName(), defaultToUse, this.title, this.shell)) {
                        canRetry = false;
                        expectedFailure = true;
                    }
                } else if (codingException != null) {
                    if (!ModelManagerUtil.openCharConversionWarningForLoad(input, defaultToUse, this.title, this.shell)) {
                        canRetry = false;
                        expectedFailure = true;
                    }
                } else {
                    canRetry = false;
                }
            }
        }
        IStructuredModel model = null;
        try {
            if (canRetry && input != null) {
                switch (which) {
                    case 1: {
                        model = ModelManagerEncodingHelper.getModelForRead(this.modelManager, input, EncodingRule.FORCE_DEFAULT);
                        break;
                    }
                    case 3: {
                        model = ModelManagerEncodingHelper.getModelForEdit(this.modelManager, input, EncodingRule.FORCE_DEFAULT);
                    }
                }
            } else {
                if (!expectedFailure) {
                    if (codingException != null) {
                        Logger.log(codingException);
                    } else if (charsetException != null) {
                        Logger.log(charsetException);
                    }
                }
                model = null;
            }
        }
        catch (CharacterCodingException ex) {
            String error_title = ResourceHandler._UI_Error_opening_file_2;
            String error_msg = ex.toString();
            Status status = new Status(4, WebEditViewerPlugin.getDefault().getBundle().getSymbolicName(), 0, ModelManagerUtil.getCharacterCodingExceptionMessage(input, ModelManagerEncodingHelper.getDefaultEncoding(input)), (Throwable)ex);
            ErrorDialog.openError((Shell)this.shell, (String)error_title, (String)error_msg, (IStatus)status);
            model = null;
        }
        catch (UnsupportedCharsetException e2) {
            Logger.log(e2);
        }
        catch (IOException ioe) {
            Logger.log(ioe);
        }
        catch (CoreException ce) {
            Logger.log(ce);
        }
        return model;
    }

    private static String getCharacterCodingExceptionMessage(IFile input, ModelManagerEncodingHelper.EncodingHolder holder) {
        int pos = ModelManagerEncodingHelper.findCharcterCodingExceptionPosition(input, holder.java);
        return MessageFormat.format(ResourceHandler._7concat_UI_, Integer.toString(pos), holder.iana);
    }

    public IStructuredModel getModelForEdit(Object id, IFile input, IPath fullIPath, IProject project, Object modelType) {
        return this.getModel(3, input, fullIPath);
    }

    public IStructuredModel getModelForRead(Object id, IFile input, IPath fullIPath, IProject project, Object modelType) {
        return this.getModel(1, input, fullIPath);
    }

    public IStructuredModel getModelForEdit(IFile input) {
        if (input == null) {
            return null;
        }
        return this.getModel(3, input, input.getLocation());
    }

    public IStructuredModel getModelForRead(IFile input) {
        if (input == null) {
            return null;
        }
        return this.getModel(1, input, input.getLocation());
    }

    public IStructuredModel getModelForEdit(IPath location) {
        if (location == null) {
            return null;
        }
        return this.getModel(3, null, location);
    }

    public IStructuredModel getModelForRead(IPath location) {
        if (location == null) {
            return null;
        }
        return this.getModel(1, null, location);
    }

    public IStructuredModel getModelForRead(URL url) {
        if (url == null) {
            return null;
        }
        return this.getModel(1, url);
    }

    public IStructuredModel getNewModelForEdit(IFile input) {
        return this.getModel(4, input, input.getLocation());
    }

    public IStructuredModel getNewModelForEdit(IFile input, IStructuredModel refModel, boolean frameSet) {
        return this.getModel(4, input, input.getLocation(), refModel, frameSet, null);
    }

    public IStructuredModel getNewModelForRead(IFile input) {
        return this.getModel(2, input, input.getLocation());
    }

    public IStructuredModel getNewModelForRead(IFile input, IStructuredModel refModel, boolean frameSet) {
        return this.getModel(2, input, input.getLocation(), refModel, frameSet, null);
    }

    private void initModel(IStructuredModel model, int which, IStructuredModel refModel, boolean frameSet) {
        if (model == null) {
            return;
        }
        if (ModelManagerUtil.isHTMLFamily(model)) {
            this.initModelForHTML(model, which, refModel, frameSet);
        } else if (ContentTypeCSSUtil.isContentTypeCSSExtend(model)) {
            this.initModelForCSS(model, which);
        }
        this.initModelForSSE(model);
    }

    private void initModelForSSE(IStructuredModel model) {
    }

    private void initModelForCSS(IStructuredModel model, int which) {
        if (model == null) {
            return;
        }
        ModelAdapterFactoryRegistry.registerAdapterFactories(model);
    }

    private void initModelForHTML(IStructuredModel model, int which, IStructuredModel refModel, boolean frameSet) {
        if (model == null) {
            return;
        }
        ModelAdapterFactoryRegistry.registerAdapterFactories(model);
        if (which == 2 || which == 4) {
            Element htmlNode;
            Node headNode;
            IDOMModel xmlmodel;
            IDOMDocument doc;
            NodeList nl;
            String charSet;
            DocumentType documentType;
            boolean orgIsDirty = model.isDirty();
            boolean isDirty = false;
            if (FilesPreferenceUtil.getCheckDocType() && HeaderModifier.addDoctype(model, documentType = HeaderModifier.getDocumentType((IDOMModel)model, (IDOMModel)refModel, frameSet), false)) {
                isDirty = true;
            }
            if (HeaderModifier.addCharset(model, charSet = FilesPreferenceUtil.getUserPreferredCharsetName((String)model.getContentTypeIdentifier()), false)) {
                isDirty = true;
            }
            if (FilesPreferenceUtil.getGeneratorOut() && HeaderModifier.addGenerator(model, false)) {
                isDirty = true;
            }
            if (HeaderModifier.addContentStyleType(model, false)) {
                isDirty = true;
            }
            String titleString = "";
            String fileName = ModelManagerUtil.getBaseLocation(model);
            if (fileName != null) {
                Path title = new Path(fileName);
                titleString = title.lastSegment();
            }
            if (HeaderModifier.addTitle(model, titleString, false)) {
                isDirty = true;
            }
            if (((nl = (doc = (xmlmodel = (IDOMModel)model).getDocument()).getElementsByTagName(BODY_TAG)) == null || nl.getLength() <= 0) && (headNode = HeaderModifier.findHeadNode(model)) != null && (htmlNode = doc.getDocumentElement()) != null) {
                Element bodyTag = doc.createElement(BODY_TAG);
                htmlNode.appendChild(bodyTag);
                String newLine = model.getStructuredDocument().getLineDelimiter();
                if (newLine == null || newLine.length() == 0) {
                    newLine = System.getProperty("line.separator");
                }
                Text text = doc.createTextNode(newLine);
                htmlNode.appendChild(text);
                isDirty = true;
            }
            if (!orgIsDirty && isDirty) {
                model.setDirtyState(false);
            }
        }
    }

    public static boolean isHTMLFamily(IStructuredModel model) {
        if (model instanceof IDOMModel) {
            IDOMDocument document = ((IDOMModel)model).getDocument();
            DocumentTypeAdapter adapter = (DocumentTypeAdapter)document.getAdapterFor(DocumentTypeAdapter.class);
            ModelQuery modelQuery = document.getNodeType() == 9 ? ModelQueryUtil.getModelQuery((Document)document) : ModelQueryUtil.getModelQuery((Document)document.getOwnerDocument());
            if (modelQuery == null) {
                return false;
            }
            CMDocument cmdoc = modelQuery.getCorrespondingCMDocument((Node)document);
            if (cmdoc == null) {
                return false;
            }
            if (adapter != null) {
                return adapter.hasFeature("HTML");
            }
        }
        return false;
    }

    public static boolean isAcceptableModelHanlderId(IFile input) throws CoreException {
        String id;
        IModelHandler handler = input != null ? ModelHandlerRegistry.getInstance().getHandlerFor(input) : null;
        String string = id = handler != null ? handler.getId() : null;
        return id != null && (id.equals("org.eclipse.wst.html.core.modelhandler") || id.equals("org.eclipse.jst.jsp.core.modelhandler") || id.equals("org.eclipse.wst.css.core.modelhandler") || id.equals("org.eclipse.jst.jsp.css.core.modelhandler"));
    }

    public static boolean openUnsupportedEncodingWarningForLoad(String encoding, String defaultToUse, String title, Shell shell) {
        if (shell == null) {
            return false;
        }
        MessageFormat form = new MessageFormat(ENCODING_WARNING);
        Object[] args = new Object[]{encoding, defaultToUse};
        String msg = form.format(args);
        MessageDialog warning = new MessageDialog(shell, title, null, msg, 4, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.ABORT_LABEL}, 1);
        return warning.open() == 0;
    }

    public static boolean openCharConversionWarningForLoad(IFile file, String defaultToUse, String title, Shell shell) {
        String reason = ModelManagerUtil.getCharacterCodingExceptionMessage(file, ModelManagerEncodingHelper.getDetectedEncoding(file));
        String message = NLS.bind((String)ResourceHandler._UI_Model_Manager_Util_0, (Object)reason, (Object)defaultToUse);
        MessageDialog warning = new MessageDialog(shell, title, null, message, 4, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.ABORT_LABEL}, 1);
        return warning.open() == 0;
    }

    public static IStatus validateEdit(IStructuredModel model, Shell context, boolean nonExistAsWritable) {
        if (model == null) {
            return STATUS_ERROR;
        }
        String location = ModelManagerUtil.getBaseLocation(model);
        if (location == null || location.length() == 0) {
            return STATUS_ERROR;
        }
        Path fullIPath = new Path(location);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)fullIPath);
        return ModelManagerUtil.validateEdit(file, context, nonExistAsWritable);
    }

    public static IStatus validateEdit(IFile file, Shell context, boolean nonExistAsWritable) {
        long afterModifiedFromIFile;
        long afterModifiedFromJavaIO;
        long beforeModifiedFromIFile;
        long beforeModifiedFromJavaIO;
        block14: {
            if (file == null) {
                return STATUS_ERROR;
            }
            if (!file.exists()) {
                return nonExistAsWritable ? STATUS_OK : STATUS_ERROR;
            }
            if (!file.isReadOnly()) {
                return STATUS_OK;
            }
            IPath fullIPath = file.getProject().getLocation();
            fullIPath = fullIPath.append(file.getName());
            beforeModifiedFromJavaIO = fullIPath.toFile().lastModified();
            beforeModifiedFromIFile = file.getModificationStamp();
            IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)context);
            if (!status.isOK()) {
                return status;
            }
            afterModifiedFromJavaIO = fullIPath.toFile().lastModified();
            afterModifiedFromIFile = file.getModificationStamp();
            if (beforeModifiedFromJavaIO != afterModifiedFromJavaIO) {
                String sseId;
                IModelManager manager = StructuredModelManager.getModelManager();
                IStructuredModel model = manager.getExistingModelForRead((Object)(sseId = ModelManagerUtil.calculateSSEModelId(file)));
                if (model == null || !model.isDirty()) {
                    try {
                        try {
                            file.refreshLocal(1, null);
                            break block14;
                        }
                        catch (CoreException coreException) {
                            IStatus iStatus = STATUS_ERROR;
                            if (model != null) {
                                model.releaseFromRead();
                            }
                            return iStatus;
                        }
                    }
                    finally {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                    }
                }
                model.releaseFromRead();
            }
        }
        if (beforeModifiedFromJavaIO != afterModifiedFromJavaIO || beforeModifiedFromIFile != afterModifiedFromIFile) {
            return STATUS_ERROR;
        }
        return STATUS_OK;
    }

    public static boolean isWML(IDOMDocument document) {
        if (document == null) {
            return false;
        }
        DocumentTypeAdapter adapter = (DocumentTypeAdapter)document.getAdapterFor(DocumentTypeAdapter.class);
        if (adapter == null) {
            return false;
        }
        DocumentType docType = adapter.getDocumentType();
        if (docType == null) {
            return false;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery == null) {
            return false;
        }
        CMDocument cmdoc = modelQuery.getCorrespondingCMDocument((Node)document);
        if (cmdoc == null) {
            return false;
        }
        CMNamedNodeMap map = cmdoc.getElements();
        if (map == null) {
            return false;
        }
        CMElementDeclaration decl = (CMElementDeclaration)map.getNamedItem("card");
        if (decl == null) {
            return false;
        }
        String name = docType.getName();
        return name.equalsIgnoreCase("wml");
    }

    public static void updateEncodingMemento(IStructuredModel model) {
        if (model == null) {
            return;
        }
        IStructuredDocument doc = model.getStructuredDocument();
        IDocumentCharsetDetector detector = model.getModelHandler().getDocumentLoader().getDocumentEncodingDetector();
        EncodingMemento memento = doc.getEncodingMemento();
        if (memento != null && detector != null) {
            detector.set((IDocument)doc);
        }
        EncodingMemento newMemento = null;
        try {
            if (detector instanceof HTMLDocumentCharsetDetector) {
                newMemento = ((HTMLDocumentCharsetDetector)detector).getEncodingMemento();
            } else if (detector instanceof JSPDocumentHeadContentDetector) {
                newMemento = ((JSPDocumentHeadContentDetector)detector).getEncodingMemento();
            } else if (detector instanceof XMLDocumentCharsetDetector) {
                newMemento = ((XMLDocumentCharsetDetector)detector).getEncodingMemento();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (newMemento != null) {
            doc.setEncodingMemento(newMemento);
        }
    }

    public static String getBaseLocation(IStructuredModel model) {
        String baseLocation = null;
        if (model != null) {
            URIResolver resolver = model.getResolver();
            if (resolver != null) {
                baseLocation = resolver.getFileBaseLocation();
            }
            if (baseLocation == null) {
                baseLocation = model.getBaseLocation();
            }
            if (baseLocation != null) {
                IPath loc;
                Path path = new Path(baseLocation);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFileForLocation((IPath)path);
                if (file == null && path.segmentCount() > 1) {
                    file = root.getFile((IPath)path);
                }
                if (file != null && (loc = file.getLocation()) != null) {
                    baseLocation = loc.toString();
                }
            }
        }
        return baseLocation != null ? baseLocation : new String();
    }

    public static String calculateSSEModelId(IFile file) {
        if (file == null) {
            return null;
        }
        String sseId = StructuredModelManager.getModelManager().calculateId(file);
        if (sseId == null) {
            Path absolutePath;
            sseId = file.getLocation() != null ? file.getLocation().toString() : ((absolutePath = new Path(file.getFullPath().toFile().getAbsolutePath())) != null ? absolutePath.toString() : null);
        }
        return sseId;
    }

    public static Object calculateModelId(String filename) {
        if (filename == null) {
            return null;
        }
        Path path = new Path(filename);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)path);
        if (file == null) {
            return path.toString();
        }
        return ModelManagerUtil.calculateModelId(file);
    }

    public static Object calculateModelId(IEditorInput input) {
        if (input == null) {
            return null;
        }
        IFile file = (IFile)input.getAdapter(IFile.class);
        return ModelManagerUtil.calculateModelId(file);
    }

    public static Object calculateModelId(IFile file) {
        if (file == null) {
            return null;
        }
        if (file.getLocation() != null) {
            return file.getLocation().toString();
        }
        Path absolutePath = new Path(file.getFullPath().toFile().getAbsolutePath());
        return absolutePath != null ? absolutePath.toString() : null;
    }

    public static void reloadModel(IStructuredModel model, IFile file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (model == null) {
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer.getDocument() == model.getStructuredDocument()) {
            try {
                buffer.revert((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Logger.log(e);
            }
            return;
        }
        InputStream inStream = null;
        try {
            inStream = file.getContents(true);
            if (inStream == null) {
                return;
            }
            try {
                model.reload(inStream);
                model.setDirtyState(false);
                model.resetSynchronizationStamp((IResource)file);
            }
            catch (CoreException e) {
                Logger.log(e);
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    Logger.log(e);
                }
            }
        }
    }

    private class BundleEntryURIResolver
    implements URIResolver {
        URL url;

        BundleEntryURIResolver(URL url) {
            this.url = url;
        }

        public String getFileBaseLocation() {
            return this.url.toExternalForm();
        }

        public String getLocationByURI(String uri) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), false);
        }

        public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
        }

        public String getLocationByURI(String uri, String baseReference) {
            return this.getLocationByURI(uri, baseReference, false);
        }

        public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
            if (uri == null) {
                return null;
            }
            if (uri.startsWith("file:")) {
                try {
                    URL url = new URL(uri);
                    return url.getFile();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return URIHelper.normalize((String)uri, (String)baseReference, (String)Path.ROOT.toString());
        }

        public IProject getProject() {
            return null;
        }

        public IContainer getRootLocation() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }

        public InputStream getURIStream(String uri) {
            return null;
        }

        public void setFileBaseLocation(String newLocation) {
        }

        public void setProject(IProject newProject) {
        }
    }

    private class ExternalURIResolver
    implements URIResolver {
        IPath fLocation;

        ExternalURIResolver(IPath location) {
            this.fLocation = location;
        }

        public String getFileBaseLocation() {
            return this.fLocation.toString();
        }

        public String getLocationByURI(String uri) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), false);
        }

        public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
        }

        public String getLocationByURI(String uri, String baseReference) {
            return this.getLocationByURI(uri, baseReference, false);
        }

        public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
            if (uri == null) {
                return null;
            }
            if (uri.startsWith("file:")) {
                try {
                    URL url = new URL(uri);
                    return url.getFile();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return URIHelper.normalize((String)uri, (String)baseReference, (String)Path.ROOT.toString());
        }

        public IProject getProject() {
            return null;
        }

        public IContainer getRootLocation() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }

        public InputStream getURIStream(String uri) {
            return null;
        }

        public void setFileBaseLocation(String newLocation) {
        }

        public void setProject(IProject newProject) {
        }
    }
}

