/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.utils;

import com.ibm.etools.webedit.viewer.WebEditViewerPlugin;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerEncodingHelper;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.icu.text.BreakIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.encoding.CodedStreamCreator;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.exceptions.CharConversionErrorWithDetail;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedOutputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ModelManagerEncodingHelperForSave {
    public static void save(IStructuredModel model, EncodingRule rule) throws CoreException, IOException, UnsupportedCharsetException {
        ModelManagerEncodingHelperForSave.save(model, ModelManagerEncodingHelperForSave.getFile(model), rule);
    }

    public static void save(IStructuredModel model, IFile file, EncodingRule rule) throws CoreException, IOException, UnsupportedCharsetException {
        ITextFileBuffer buffer = ModelManagerEncodingHelperForSave.getBufferForSave(model, file);
        if (buffer == null) {
            model.save(file);
        } else {
            ModelManagerEncodingHelperForSave.save(model, file, rule, new ModelDumper(), buffer);
        }
    }

    private static void save(IStructuredModel model, IFile file, EncodingRule rule, ModelDumper dumper, ITextFileBuffer buffer) throws CoreException, IOException, UnsupportedCharsetException {
        SaveHandler handler = rule == EncodingRule.FORCE_DEFAULT ? new SaveHandlerForForceDefault(model, file, dumper, buffer) : (rule == EncodingRule.IGNORE_CONVERSION_ERROR ? new SaveHandlerForIgnoreConversionError(model, file, dumper, buffer) : new SaveHandlerForContentBased(model, file, dumper, buffer));
        try {
            handler.doSave();
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status == null || status.isOK()) {
                throw e;
            }
            if (status.getException() instanceof UnsupportedCharsetException) {
                throw (UnsupportedCharsetException)status.getException();
            }
            CharacterCodingException ce = null;
            if (status.getException() instanceof CharacterCodingException) {
                ce = (CharacterCodingException)status.getException();
            }
            if ("org.eclipse.core.filebuffers".equals(status.getPlugin()) && status.getCode() == 3) {
                ce = new CharacterCodingException();
            }
            if (ce != null) {
                if (ce instanceof CharConversionErrorWithDetail || ce instanceof MalformedInputExceptionWithDetail) {
                    throw ce;
                }
                IStructuredModel model2 = handler.getModel();
                ModelManagerEncodingHelper.EncodingHolder enc = handler.getEncoding();
                int pos = ModelManagerEncodingHelperForSave.findCharcterCodingExceptionPosition(model2, enc.java);
                throw new MalformedOutputExceptionWithDetail(enc.java, enc.iana, pos);
            }
            throw e;
        }
    }

    private static IFile getFile(IStructuredModel model) {
        if (FileBufferModelManager.getInstance().isExistingBuffer((IDocument)model.getStructuredDocument())) {
            ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer((IDocument)model.getStructuredDocument());
            return FileBuffers.getWorkspaceFileAtLocation((IPath)buffer.getLocation());
        }
        return FileBuffers.getWorkspaceFileAtLocation((IPath)new Path(ModelManagerUtil.getBaseLocation(model)));
    }

    private static void saveStructuredDocument(IStructuredDocument structuredDocument, IFile file, EncodingRule rule) throws UnsupportedCharsetException, CoreException, IOException {
        CodedStreamCreator codedStreamCreator = new CodedStreamCreator();
        DocumentReader reader = new DocumentReader((IDocument)structuredDocument);
        codedStreamCreator.set(file, (Reader)reader);
        codedStreamCreator.setPreviousEncodingMemento(structuredDocument.getEncodingMemento());
        EncodingMemento encodingMemento = codedStreamCreator.getCurrentEncodingMemento();
        structuredDocument.setEncodingMemento(encodingMemento);
        ByteArrayOutputStream codedByteStream = codedStreamCreator.getCodedByteArrayOutputStream(rule);
        ByteArrayInputStream codedStream = new ByteArrayInputStream(codedByteStream.toByteArray());
        if (file.exists()) {
            file.setContents((InputStream)codedStream, true, true, null);
        } else {
            file.create((InputStream)codedStream, false, null);
        }
        codedByteStream.close();
        ((InputStream)codedStream).close();
    }

    public static int findCharcterCodingExceptionPosition(IStructuredModel model, String javaEncoding) {
        return ModelManagerEncodingHelperForSave.findCharcterCodingExceptionPosition(model.getStructuredDocument().get(), javaEncoding);
    }

    static int findCharcterCodingExceptionPosition(String content, String javaEncoding) {
        Assert.isNotNull((Object)content);
        Assert.isLegal((javaEncoding != null && javaEncoding.length() > 0 ? 1 : 0) != 0);
        CharsetEncoder encoder = Charset.forName(javaEncoding).newEncoder();
        if (encoder.canEncode(content)) {
            return -1;
        }
        String text = content;
        BreakIterator it = BreakIterator.getCharacterInstance();
        it.setText(text);
        int start = it.first();
        int end = it.next();
        while (end != -1) {
            String c = text.substring(start, end);
            if (!encoder.canEncode(c)) {
                return start;
            }
            start = end;
            end = it.next();
        }
        return -1;
    }

    public static ModelManagerEncodingHelper.EncodingHolder getDetectedEncodingForSave(IStructuredModel model, IFile file) {
        String java = null;
        String iana = null;
        try {
            IContentDescription desc = Platform.getContentTypeManager().getDescriptionFor((Reader)new DocumentReader((IDocument)model.getStructuredDocument()), file.getName(), IContentDescription.ALL);
            java = desc.getCharset();
            iana = (String)desc.getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
        }
        catch (IOException iOException) {}
        if (java == null) {
            return ModelManagerEncodingHelper.getDefault(model, file);
        }
        if (iana == null) {
            iana = java;
        }
        return new ModelManagerEncodingHelper.EncodingHolder(java, iana);
    }

    public static ModelManagerEncodingHelper.EncodingHolder getExplicitEncodingForSave(IStructuredModel model, IFile file) {
        return ModelManagerEncodingHelperForSave.getExplicitEncodingForSave(model, file, ModelManagerEncodingHelperForSave.getBufferForSave(model, file));
    }

    private static ModelManagerEncodingHelper.EncodingHolder getExplicitEncodingForSave(IStructuredModel model, IFile file, ITextFileBuffer buffer) {
        String resourceCharset = null;
        try {
            resourceCharset = file.getCharset(false);
        }
        catch (CoreException coreException) {}
        if (resourceCharset != null && resourceCharset.equals(buffer.getEncoding())) {
            return new ModelManagerEncodingHelper.EncodingHolder(resourceCharset, resourceCharset);
        }
        return null;
    }

    public static ModelManagerEncodingHelper.EncodingHolder getDefaultEncodingForSave(IStructuredModel model, IFile file) {
        return ModelManagerEncodingHelper.getDefault(model, file);
    }

    public static void setEncodingForSave(IStructuredModel model, IFile target, String javaEncoding, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ModelManagerEncodingHelperForSave.setEncodingForSave(model, target, javaEncoding, monitor, ModelManagerEncodingHelperForSave.getBufferForSave(model, target));
    }

    private static void setEncodingForSave(IStructuredModel model, IFile target, final String javaEncoding, IProgressMonitor monitor, final ITextFileBuffer buffer) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation((ISchedulingRule)target){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                buffer.setEncoding(javaEncoding);
            }
        };
        op.run(monitor);
    }

    private static ITextFileBuffer getBufferForSave(IStructuredModel model, IFile file) {
        if (model == null || file == null) {
            return null;
        }
        if (FileBufferModelManager.getInstance().isExistingBuffer((IDocument)model.getStructuredDocument())) {
            ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer((IDocument)model.getStructuredDocument());
            IPath fileLocation = FileBuffers.normalizeLocation((IPath)file.getFullPath());
            if (fileLocation.equals((Object)buffer.getLocation())) {
                return buffer;
            }
        }
        return null;
    }

    public static boolean canIgnoreEncodingConflict(IStructuredModel model) {
        IContentType type = Platform.getContentTypeManager().getContentType(model.getContentTypeIdentifier());
        if (type == null) {
            return false;
        }
        IContentType fragment = Platform.getContentTypeManager().getContentType("org.eclipse.jst.jsp.core.jspfragmentsource");
        return type.isKindOf(fragment);
    }

    private static class ModelDumper {
        private ModelDumper() {
        }

        public void dump(IStructuredModel model, IFile file, EncodingRule rule) throws CoreException, IOException, UnsupportedCharsetException {
            if (rule == null || rule == EncodingRule.CONTENT_BASED) {
                model.save(file);
            } else if (rule == EncodingRule.FORCE_DEFAULT) {
                model.save(file, rule);
            } else if (rule == EncodingRule.IGNORE_CONVERSION_ERROR) {
                ModelManagerEncodingHelperForSave.saveStructuredDocument(model.getStructuredDocument(), file, rule);
            }
        }
    }

    private static interface SaveHandler {
        public ModelManagerEncodingHelper.EncodingHolder getEncoding();

        public void doSave() throws CoreException, IOException, UnsupportedCharsetException;

        public IStructuredModel getModel();
    }

    private static class SaveHandlerForContentBased
    implements SaveHandler {
        private ModelDumper dumper;
        private IStructuredModel model;
        private IFile file;
        private final ITextFileBuffer buffer;

        public SaveHandlerForContentBased(IStructuredModel model, IFile file, ModelDumper dumper, ITextFileBuffer buffer) {
            this.model = model;
            this.file = file;
            this.dumper = dumper;
            this.buffer = buffer;
        }

        @Override
        public void doSave() throws CoreException, IOException, UnsupportedCharsetException {
            this.dumper.dump(this.model, this.file, EncodingRule.CONTENT_BASED);
        }

        @Override
        public ModelManagerEncodingHelper.EncodingHolder getEncoding() {
            ModelManagerEncodingHelper.EncodingHolder enc = ModelManagerEncodingHelperForSave.getExplicitEncodingForSave(this.model, this.file, this.buffer);
            if (enc == null) {
                enc = ModelManagerEncodingHelperForSave.getDetectedEncodingForSave(this.model, this.file);
            }
            return enc;
        }

        @Override
        public IStructuredModel getModel() {
            return this.model;
        }
    }

    private static class SaveHandlerForForceDefault
    implements SaveHandler {
        private ModelDumper dumper;
        private IStructuredModel model;
        private IFile file;
        private ITextFileBuffer buffer;

        public SaveHandlerForForceDefault(IStructuredModel model, IFile file, ModelDumper dumper, ITextFileBuffer buffer) {
            this.model = model;
            this.file = file;
            this.dumper = dumper;
            this.buffer = buffer;
        }

        @Override
        public void doSave() throws CoreException, IOException, UnsupportedCharsetException {
            ModelManagerEncodingHelper.EncodingHolder explicitEncoding = ModelManagerEncodingHelperForSave.getExplicitEncodingForSave(this.model, this.file, this.buffer);
            try {
                ModelManagerEncodingHelper.EncodingHolder defaultEncoding = ModelManagerEncodingHelperForSave.getDefaultEncodingForSave(this.model, this.file);
                ModelManagerEncodingHelperForSave.setEncodingForSave(this.model, this.file, defaultEncoding.java, null, this.buffer);
                boolean done = false;
                try {
                    this.dumper.dump(this.model, this.file, EncodingRule.FORCE_DEFAULT);
                    done = true;
                }
                catch (Throwable throwable) {
                    if (!done) {
                        String javaEncdoing = explicitEncoding == null ? null : explicitEncoding.java;
                        ModelManagerEncodingHelperForSave.setEncodingForSave(this.model, this.file, javaEncdoing, null, this.buffer);
                    }
                    throw throwable;
                }
                if (!done) {
                    String javaEncdoing = explicitEncoding == null ? null : explicitEncoding.java;
                    ModelManagerEncodingHelperForSave.setEncodingForSave(this.model, this.file, javaEncdoing, null, this.buffer);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, WebEditViewerPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }

        @Override
        public ModelManagerEncodingHelper.EncodingHolder getEncoding() {
            return ModelManagerEncodingHelperForSave.getDefaultEncodingForSave(this.model, this.file);
        }

        @Override
        public IStructuredModel getModel() {
            return this.model;
        }
    }

    private static class SaveHandlerForIgnoreConversionError
    implements SaveHandler {
        private ModelDumper dumper;
        private IStructuredModel model;
        private IFile file;
        private final ITextFileBuffer buffer;

        public SaveHandlerForIgnoreConversionError(IStructuredModel model, IFile file, ModelDumper dumper, ITextFileBuffer buffer) {
            this.model = model;
            this.file = file;
            this.dumper = dumper;
            this.buffer = buffer;
        }

        @Override
        public void doSave() throws CoreException, IOException, UnsupportedCharsetException {
            this.dumper.dump(this.model, this.file, EncodingRule.IGNORE_CONVERSION_ERROR);
            this.buffer.revert(null);
        }

        @Override
        public ModelManagerEncodingHelper.EncodingHolder getEncoding() {
            ModelManagerEncodingHelper.EncodingHolder enc = ModelManagerEncodingHelperForSave.getExplicitEncodingForSave(this.model, this.file);
            if (enc == null) {
                enc = ModelManagerEncodingHelperForSave.getDetectedEncodingForSave(this.model, this.file);
            }
            return enc;
        }

        @Override
        public IStructuredModel getModel() {
            return this.model;
        }
    }
}

