/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.submodel;

import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.links.util.InvalidURLException;
import com.ibm.etools.webedit.links.util.URI;
import com.ibm.etools.webedit.viewer.ModelCollectorsContext;
import com.ibm.etools.webedit.viewer.internal.submodel.ISubModelCollector;
import com.ibm.etools.webedit.viewer.internal.submodel.ISubModelKey;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FrameSubModelCollector
implements ISubModelCollector {
    private static final String TAG_NAME_FRAME = "FRAME";
    private static final String ATTRIBUTE_NAME_SRC = "SRC";

    @Override
    public ISubModelKey[] collectChildTargets(ModelCollectorsContext context, IDOMModel model) {
        if (model == null) {
            return null;
        }
        NodeList nodeList = FrameSubModelCollector.collectChildTargets(model);
        if (nodeList == null || nodeList.getLength() <= 0) {
            return null;
        }
        ISubModelKey[] keys = new ISubModelKey[nodeList.getLength()];
        int i = 0;
        while (i < keys.length) {
            keys[i] = new FrameSubModelKey(nodeList.item(i));
            ++i;
        }
        return keys;
    }

    public static NodeList collectChildTargets(IDOMModel model) {
        if (model == null) {
            return null;
        }
        return model.getDocument().getElementsByTagName(TAG_NAME_FRAME);
    }

    @Override
    public Object getChildId(ModelCollectorsContext context, IDOMModel model, ISubModelKey key) {
        String fileName = this.getChildFileName(context, model, key);
        if (fileName == null) {
            return null;
        }
        Path filePath = new Path(fileName);
        FileURL fileURL = new FileURL((IPath)filePath);
        IFile fileIFile = fileURL.getIFile();
        return ModelManagerUtil.calculateModelId(fileIFile);
    }

    @Override
    public String getChildFileName(ModelCollectorsContext context, IDOMModel model, ISubModelKey key) {
        if (model == null) {
            return null;
        }
        String baseLocation = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        if (baseLocation == null || baseLocation.length() == 0) {
            return null;
        }
        Path docPath = new Path(baseLocation);
        String[] urlInfo = FrameSubModelCollector.getTargetURLInfo((IPath)docPath, key.getNode());
        if (urlInfo == null || urlInfo.length < 4) {
            return null;
        }
        String absURL = urlInfo[1];
        Path filePath = null;
        String scheme = URI.getOnlyScheme((String)absURL);
        if (scheme != null && scheme.length() > 0) {
            if (scheme.compareToIgnoreCase("file") == 0) {
                try {
                    FileURL fileURL = new FileURL(absURL);
                    filePath = fileURL.getPath();
                }
                catch (InvalidURLException e) {
                    Logger.log(e);
                }
            }
        } else {
            filePath = new Path(absURL);
        }
        if (filePath != null) {
            boolean[] types = new boolean[2];
            WebComponent component = new WebComponent((IResource)WebComponent.getFileForLocation((IPath)filePath));
            IPath newLocalFilePath = component.getRealLocationOfIPath((IPath)filePath, types);
            component.dispose();
            if (types[1]) {
                filePath = newLocalFilePath;
            }
        }
        return filePath != null ? filePath.toString() : absURL;
    }

    public static String[] getTargetURLInfo(IPath docPath, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        Element element = (Element)node;
        String src = element.getAttribute(ATTRIBUTE_NAME_SRC);
        if (src == null) {
            return null;
        }
        String absURL = LinkUtil.getAbsURL(docPath, docPath, src, true);
        if (absURL == null) {
            return null;
        }
        String[] links = new String[3];
        FrameSubModelCollector.parseRawLink(absURL, links);
        absURL = links[0] != null && links[0].trim().length() > 0 ? links[0].trim() : absURL;
        String fragment = links[1];
        String queryString = links[2];
        return new String[]{src, absURL, fragment, queryString};
    }

    public static void parseRawLink(String newRawLink, String[] links) {
        String raw;
        String frag;
        String query;
        int extraIndex;
        links[0] = "";
        links[1] = "";
        links[2] = "";
        if (newRawLink == null) {
            newRawLink = "";
        }
        if ((extraIndex = (newRawLink = newRawLink.trim()).indexOf(63)) != -1) {
            query = newRawLink.substring(extraIndex);
            newRawLink = newRawLink.substring(0, extraIndex);
        } else {
            query = "";
        }
        int length = newRawLink.length();
        int poundIndex = -1;
        if (length > 0) {
            int i = length - 1;
            while (i >= 0) {
                char ch = newRawLink.charAt(i);
                if (ch == '#') {
                    poundIndex = i;
                    break;
                }
                if (ch == '/' && (i == length - 1 || newRawLink.charAt(i + 1) != '>')) break;
                --i;
            }
        }
        if (poundIndex != -1) {
            frag = newRawLink.substring(poundIndex);
            raw = newRawLink.substring(0, poundIndex);
        } else {
            frag = "";
            raw = newRawLink;
        }
        links[0] = raw;
        links[1] = frag;
        links[2] = query;
    }

    public static class FrameSubModelKey
    implements ISubModelKey {
        private Node node;

        public FrameSubModelKey(Node node) {
            this.node = node;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            return obj != null && obj.getClass().equals(this.getClass()) && ((FrameSubModelKey)obj).getNode() == this.getNode();
        }

        public String toString() {
            if (this.node != null) {
                return this.node.toString();
            }
            return null;
        }
    }
}

