/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.frame;

import com.ibm.etools.webedit.frame.FrameLayoutNode;
import com.ibm.etools.webedit.frame.FrameLayouter;
import com.ibm.etools.webedit.frame.FrameNode;
import com.ibm.etools.webedit.frame.FramePageNode;
import com.ibm.etools.webedit.frame.FrameSetNode;
import com.ibm.etools.webedit.frame.FrameView;
import com.ibm.etools.webedit.frame.FrameViewFactory;
import com.ibm.etools.webedit.frame.Length;
import java.util.Vector;
import org.eclipse.swt.graphics.Rectangle;

public class FrameLayoutNodeImpl
implements FrameLayoutNode {
    private FrameNode node;
    private FrameLayoutNodeImpl[] panes;
    private Rectangle bounds;
    private FrameLayouter layouter;
    private FrameView view;
    private Object model;
    private int index = -1;

    public FrameLayoutNodeImpl(FrameLayoutNode parent, FrameLayouter layouter, int index) {
        this.layouter = layouter;
        FrameViewFactory viewFactory = layouter.getViewFactory();
        if (viewFactory != null) {
            this.view = viewFactory.createView(parent != null ? parent.getView() : null);
        }
        this.index = index;
    }

    @Override
    public void dispose() {
        this.disposePanes();
        this.view.dispose();
    }

    private void disposePanes() {
        if (this.panes != null) {
            int i = this.panes.length - 1;
            while (i >= 0) {
                this.panes[i].dispose();
                --i;
            }
            this.panes = null;
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public FrameLayoutNode[] getChildPanes() {
        return this.panes;
    }

    @Override
    public FrameNode getFrameNode() {
        return this.node;
    }

    private FrameSetNode getFrameSetNode() {
        if (this.node == null) {
            return null;
        }
        if (this.node.getType() == 1) {
            return (FrameSetNode)this.node;
        }
        if (this.node.getType() == 2) {
            return ((FramePageNode)this.node).getNestedFrameSet();
        }
        return null;
    }

    private Object getModel() {
        return this.model;
    }

    @Override
    public FrameView getView() {
        return this.view;
    }

    private int[] parseSpaces(Length[] attr, int allSpace, int border) {
        int[] ret;
        block13: {
            int restArea;
            int i;
            int allSpecified;
            block14: {
                int allPercent;
                block12: {
                    int allBorder = (attr.length - 1) * border;
                    if ((allSpace -= allBorder) < attr.length) {
                        allSpace = attr.length;
                    }
                    ret = new int[attr.length];
                    allSpecified = 0;
                    allPercent = 0;
                    int allRemaining = 0;
                    i = attr.length - 1;
                    while (i >= 0) {
                        int t = attr[i].getType();
                        if (t == 2) {
                            ret[i] = attr[i].getValue() * allSpace / 100;
                            allPercent += ret[i];
                        } else if (t == 3) {
                            ret[i] = 0;
                            allRemaining += attr[i].getValue();
                        } else {
                            ret[i] = attr[i].getValue();
                            allSpecified += ret[i];
                        }
                        --i;
                    }
                    restArea = allSpace - (allPercent + allSpecified);
                    if (restArea <= 0 || allRemaining <= 0) break block12;
                    i = attr.length - 1;
                    while (i >= 0) {
                        int t = attr[i].getType();
                        if (t == 3) {
                            ret[i] = attr[i].getValue() * restArea / allRemaining;
                        }
                        --i;
                    }
                    break block13;
                }
                if (restArea == 0) break block13;
                if (allPercent <= 0) break block14;
                i = attr.length - 1;
                while (i >= 0) {
                    if (attr[i].getType() == 2) {
                        int n = i;
                        ret[n] = ret[n] + ret[i] * restArea / allPercent;
                    }
                    --i;
                }
                break block13;
            }
            if (allSpecified <= 0) break block13;
            i = attr.length - 1;
            while (i >= 0) {
                if (attr[i].getType() == 1) {
                    int n = i;
                    ret[n] = ret[n] + ret[i] * restArea / allSpecified;
                }
                --i;
            }
        }
        return ret;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
        if (this.view != null) {
            this.view.setBounds(bounds);
        }
        if (this.panes != null) {
            this.updateChildBounds();
        }
    }

    public void setFrameNode(FrameNode node) {
        this.node = node;
        this.model = node != null && node.getType() == 2 ? ((FramePageNode)node).getModel() : null;
        if (this.view != null) {
            this.view.setFrameLayoutNode(this);
        }
        this.updateChildren();
        this.updateChildBounds();
        this.updateMargins();
    }

    public void updateMargins() {
        if (this.node != null) {
            if (this.node.getType() == 2 && this.view != null) {
                FramePageNode fnode = (FramePageNode)this.node;
                this.view.setMargins(fnode.getHorizontalMargin(), fnode.isHorizontalMargin(), fnode.getVerticalMargin(), fnode.isVerticalMargin());
            }
            if (this.panes != null) {
                int max = this.panes.length;
                int i = 0;
                while (i < max) {
                    this.panes[i].updateMargins();
                    ++i;
                }
            }
        }
    }

    private void updateChildBounds() {
        if (this.panes == null || this.panes.length == 0) {
            return;
        }
        if (this.view == null) {
            return;
        }
        Rectangle clientArea = this.view.getClientArea();
        if (clientArea == null) {
            return;
        }
        FrameSetNode fsn = this.getFrameSetNode();
        if (fsn == null) {
            return;
        }
        int border = fsn.getBorder();
        if (border <= 0) {
            border = 1;
        } else if (border > 6) {
            border += 4;
        }
        int[] colSpaces = this.parseSpaces(fsn.getCols(), clientArea.width, border);
        int[] rowSpaces = this.parseSpaces(fsn.getRows(), clientArea.height, border);
        int p = 0;
        int y = clientArea.y;
        Rectangle[] rowSashes = rowSpaces.length > 1 ? new Rectangle[rowSpaces.length - 1] : null;
        Rectangle[] colSashes = colSpaces.length > 1 ? new Rectangle[colSpaces.length - 1] : null;
        int rs = 0;
        int cs = 0;
        int r = 0;
        while (p < this.panes.length && r < rowSpaces.length) {
            int x = clientArea.x;
            int c = 0;
            while (p < this.panes.length && c < colSpaces.length) {
                this.panes[p++].setBounds(new Rectangle(x, y, colSpaces[c], rowSpaces[r]));
                int right = x + colSpaces[c];
                if (r == 0 && c < colSpaces.length - 1) {
                    colSashes[cs++] = new Rectangle(right, clientArea.y, border, clientArea.height);
                }
                x = right + border;
                ++c;
            }
            int bottom = y + rowSpaces[r];
            if (r < rowSpaces.length - 1) {
                rowSashes[rs++] = new Rectangle(clientArea.x, bottom, clientArea.width, border);
            }
            y = bottom + border;
            ++r;
        }
        this.view.setSashes(rowSashes, colSashes);
    }

    private void updateChildren() {
        Vector<FrameLayoutNodeImpl> newPanes = new Vector<FrameLayoutNodeImpl>();
        FrameSetNode fsn = this.getFrameSetNode();
        if (fsn != null) {
            FrameNode[] children = fsn.getChildren();
            int numChildren = children != null ? children.length : 0;
            Length[] cols = fsn.getCols();
            int numCols = cols != null ? cols.length : 1;
            Length[] rows = fsn.getRows();
            int numRows = rows != null ? rows.length : 1;
            int numFrames = numCols * numRows;
            int i = 0;
            int j = 0;
            int currentChildrenNum = this.panes != null ? this.panes.length : 0;
            while (i < numChildren) {
                FrameNode newNode = children[i];
                boolean reuse = false;
                while (j < currentChildrenNum) {
                    FrameNode oldNode = this.panes[j].getFrameNode();
                    if (oldNode != null && (newNode.getType() == 1 && oldNode.getType() == 1 || newNode.getType() == 2 && oldNode.getType() == 2 && ((FramePageNode)newNode).getModel() == this.panes[j].getModel() && ((FramePageNode)newNode).getNestedFrameSet() == null && (this.panes[j].getChildPanes() == null || this.panes[i].getChildPanes().length == 0))) {
                        this.panes[j].setFrameNode(newNode);
                        this.panes[j].setIndex(i);
                        newPanes.add(this.panes[j]);
                        ++j;
                        reuse = true;
                        break;
                    }
                    this.panes[j].dispose();
                    ++j;
                }
                if (!reuse) {
                    FrameLayoutNodeImpl n = new FrameLayoutNodeImpl(this, this.layouter, i);
                    n.setFrameNode(newNode);
                    newPanes.add(n);
                }
                ++i;
            }
            while (i < numFrames) {
                FrameLayoutNodeImpl n = new FrameLayoutNodeImpl(this, this.layouter, i);
                n.setFrameNode(null);
                newPanes.add(n);
                ++i;
            }
            while (j < currentChildrenNum) {
                this.panes[j].dispose();
                ++j;
            }
        }
        if (newPanes.size() > 0) {
            this.panes = new FrameLayoutNodeImpl[newPanes.size()];
            newPanes.toArray(this.panes);
        } else {
            this.disposePanes();
        }
    }

    public void setIndex(int i) {
        this.index = i;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

