/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal;

import com.ibm.etools.webedit.editparts.ElementHighlighter;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewerImpl;
import com.ibm.etools.webedit.editparts.adapter.SubModelOwner;
import com.ibm.etools.webedit.editparts.design.DesignTimeTagManager;
import com.ibm.etools.webedit.render.style.ViewOption;
import com.ibm.etools.webedit.viewer.DefaultHTMLViewerController;
import com.ibm.etools.webedit.viewer.HTMLViewPane;
import com.ibm.etools.webedit.viewer.HTMLViewerController;
import com.ibm.etools.webedit.viewer.internal.HTMLViewPartFactory;
import com.ibm.etools.xve.renderer.style.ContainerStyle;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class HTMLViewPaneImpl
extends HTMLGraphicalViewerImpl
implements HTMLViewPane {
    private HTMLViewPartFactory viewFactory = new HTMLViewPartFactory();
    private HTMLViewerController controller = null;
    private IDOMModel model;
    private Tool defaultTool;
    private SubModelOwner subModelOwner;

    public HTMLViewPaneImpl(String clientName) {
        super(clientName);
    }

    public HTMLViewPaneImpl(HTMLViewerController controller, String clientName) {
        this(clientName);
        this.setViewerController(controller);
    }

    public void init(Composite parent, HTMLViewerController control) {
        this.createControl(parent);
        this.setViewerController(control);
    }

    public void setViewerController(HTMLViewerController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            if (controller != null) {
                controller.initialized(this);
            }
        }
    }

    protected HTMLViewerController getViewerController() {
        if (this.controller == null) {
            this.setViewerController(new DefaultHTMLViewerController());
        }
        return this.controller;
    }

    @Override
    public void handleDispose(DisposeEvent e) {
        if (this.controller != null) {
            this.controller.disposed(this);
        }
        super.handleDispose(e);
        if (this.viewFactory != null) {
            this.viewFactory.dispose();
        }
    }

    @Override
    public void setTool(Tool tool) {
        EditDomain editDomain = this.getEditDomain();
        if (editDomain != null) {
            editDomain.setActiveTool(tool);
        }
        tool.setViewer((EditPartViewer)this);
        this.defaultTool = tool;
    }

    @Override
    public ViewOption getViewOption() {
        HTMLViewerController ctr = this.getViewerController();
        return ctr != null ? ctr.getViewOption() : null;
    }

    public void setModel(IDOMModel newModel) {
        this.releaseModel();
        this.viewFactory.setModel(newModel);
        this.setupModel();
    }

    @Override
    public IDOMModel getModel() {
        return this.model;
    }

    public void setFile(String filename) {
        this.releaseModel();
        this.viewFactory.setFile(filename);
        this.setupModel();
    }

    protected void setupModel() {
        this.model = this.viewFactory.getModel();
        if (this.model == null) {
            return;
        }
        if (this.controller != null) {
            this.controller.modelLoaded(this.model);
        }
        this.createViewPart();
    }

    private void createViewPart() {
        EditPart viewPart = this.viewFactory.getViewPart();
        this.getRootEditPart().activate();
        this.initEditDomain();
        this.setContents(viewPart);
    }

    private void releaseModel() {
        if (this.model != null) {
            if (this.controller != null) {
                this.controller.modelReleased(this.model);
            }
            this.model = null;
        }
    }

    protected void initEditDomain() {
        ElementHighlighter eh;
        EditDomain domain = this.getEditDomain();
        if (domain == null) {
            domain = new DefaultEditDomain(null);
            this.setEditDomain(domain);
        }
        Tool tool = null;
        if (this.controller != null) {
            tool = this.controller.getTool();
        }
        if (tool == null && this.defaultTool != null) {
            tool = this.defaultTool;
        }
        if (tool != null) {
            tool.setViewer((EditPartViewer)this);
            if (domain instanceof DefaultEditDomain) {
                ((DefaultEditDomain)domain).setDefaultTool(tool);
            }
            domain.setActiveTool(tool);
        }
        if (this.controller != null && (eh = this.controller.getElementHighlighter()) != null) {
            this.setElementHighligher(eh);
        }
    }

    public ImageData getImageData() {
        EditPart editPart = this.getContents();
        if (!(editPart instanceof GraphicalEditPart)) {
            return null;
        }
        IFigure fig = ((GraphicalEditPart)editPart).getFigure();
        if (fig == null) {
            return null;
        }
        Rectangle rect = fig.getBounds();
        if (rect == null || rect.width == 0 || rect.height == 0) {
            return null;
        }
        Image image = new Image((Device)Display.getCurrent(), rect.width, rect.height);
        GC imageGC = new GC((Drawable)image);
        fig.revalidate();
        fig.validate();
        SWTGraphics g = new SWTGraphics(imageGC);
        g.setClip(new Rectangle(0, 0, rect.width, rect.height));
        fig.paint((Graphics)g);
        ImageData data = image.getImageData();
        imageGC.dispose();
        image.dispose();
        return data;
    }

    @Override
    public void setDesignTimeTagManager(DesignTimeTagManager designTimeTagManager) {
        super.setDesignTimeTagManager(designTimeTagManager);
        this.viewFactory.setDesignTimeTagManager(designTimeTagManager);
    }

    @Override
    public EditPartViewer getViewer() {
        return this;
    }

    @Override
    protected ContainerStyle createContainerStyle() {
        ContainerStyle containerStyle = null;
        if (this.controller != null) {
            containerStyle = this.controller.createContainerStyle();
        }
        return containerStyle != null ? containerStyle : super.createContainerStyle();
    }

    @Override
    public SubModelOwner getSubModelOwner() {
        return this.subModelOwner;
    }

    public void setSubModelOwner(SubModelOwner subModelOwner) {
        this.subModelOwner = subModelOwner;
    }
}

