/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewer;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.viewer.HTMLViewer;
import com.ibm.etools.webedit.viewer.internal.submodel.SubModelManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class HTMLViewerSubModelManager
implements SubModelManager {
    protected boolean active;
    protected HTMLViewer htmlViewer;
    protected Runnable lastThrown;

    HTMLViewerSubModelManager(HTMLViewer viewer) {
        this.htmlViewer = viewer;
    }

    @Override
    public void subModelChanged() {
        if (this.active) {
            this.lastThrown = new Runnable(){

                @Override
                public void run() {
                    if (HTMLViewerSubModelManager.this.htmlViewer == null || !HTMLViewerSubModelManager.this.active) {
                        return;
                    }
                    if (this != HTMLViewerSubModelManager.this.lastThrown) {
                        return;
                    }
                    HTMLViewerSubModelManager.this.active = false;
                    HTMLViewerSubModelManager.this.htmlViewer.getHTMLViewerModelManager().refresh();
                    HTMLViewerSubModelManager.this.active = true;
                    HTMLViewerSubModelManager.this.lastThrown = null;
                }
            };
            Display.getDefault().asyncExec(this.lastThrown);
        }
    }

    @Override
    public void subModelActivated(IDOMModel model, HTMLGraphicalViewer viewer) {
    }

    public void activate(boolean newActive) {
        if (this.active == newActive) {
            return;
        }
        this.active = newActive;
    }

    public void dispose() {
        this.htmlViewer = null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public DocumentEditPart[] getAllDocumentEditPartFor(IStructuredModel model, HTMLGraphicalViewer viewer) {
        ArrayList<DocumentEditPart> editParts = new ArrayList<DocumentEditPart>();
        Object[] viewers = null;
        viewers = viewer != null ? new HTMLGraphicalViewer[]{viewer} : this.htmlViewer.getAllViewers(false);
        if (viewers == null) {
            return null;
        }
        int i = 0;
        while (i < viewers.length) {
            List editPartsPerView = ((HTMLGraphicalViewer)viewers[i]).getAllDocumentEditParts();
            int docs = editPartsPerView != null ? editPartsPerView.size() : 0;
            int j = 0;
            while (j < docs) {
                DocumentEditPart part = (DocumentEditPart)editPartsPerView.get(j);
                if (((IDOMDocument)part.getNode()).getModel().equals(model)) {
                    editParts.add(part);
                }
                ++j;
            }
            ++i;
        }
        return editParts.toArray(new DocumentEditPart[editParts.size()]);
    }

    @Override
    public NodeEditPart[] getSubModelsFor(DocumentEditPart parent) {
        if (parent == null) {
            return null;
        }
        ArrayList docParts = new ArrayList();
        this.getSubModelsFor((EditPart)parent, docParts);
        return docParts.toArray(new NodeEditPart[docParts.size()]);
    }

    private void getSubModelsFor(EditPart parent, List includeParts) {
        List children = parent.getChildren();
        if (children == null) {
            return;
        }
        for (EditPart part : children) {
            if (part instanceof NodeEditPart && ((NodeEditPart)part).getSubModelAdapter() != null) {
                includeParts.add(part);
                continue;
            }
            this.getSubModelsFor(part, includeParts);
        }
    }
}

