/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer;

import com.ibm.etools.webedit.viewer.ModelCollectorsContext;
import com.ibm.etools.webedit.viewer.internal.submodel.SubModelManager;
import com.ibm.etools.webedit.viewer.internal.utils.Debug;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class HTMLViewerModelContainer {
    private SubModelManager subModelManager;
    private List fileNameList = new ArrayList();
    private Dictionary managedModels;
    private Object topResId;
    private boolean manageChildren;

    HTMLViewerModelContainer(SubModelManager subModelManager) {
        this.manageChildren = subModelManager != null;
        this.subModelManager = subModelManager;
    }

    public void setTopModel(IDOMModel model, String filename) {
        Object newTopResId;
        Object object = newTopResId = model != null ? ModelManagerUtil.calculateModelId(filename) : null;
        if (newTopResId != null && newTopResId.equals(this.topResId)) {
            return;
        }
        this.releaseModel();
        if (newTopResId == null) {
            return;
        }
        IStructuredModel m = model.getModelManager().getExistingModelForRead((IDocument)model.getStructuredDocument());
        Debug.assertion(m == model);
        this.manageSingleModel(newTopResId, model);
        this.topResId = newTopResId;
        if (this.manageChildren) {
            this.createModelList(newTopResId, model);
        }
    }

    public IDOMModel getTopModel() {
        if (this.topResId == null) {
            return null;
        }
        return (IDOMModel)this.getManagedModels().get(this.topResId);
    }

    public Object getTopResId() {
        return this.topResId;
    }

    public boolean refresh() {
        ArrayList oldNameList = null;
        if (this.fileNameList == null) {
            this.fileNameList = new ArrayList();
        } else {
            oldNameList = new ArrayList(this.fileNameList);
            this.fileNameList.clear();
        }
        IDOMModel model = (IDOMModel)this.getManagedModels().get(this.topResId);
        String fileName = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        this.fileNameList.add(fileName);
        if (this.manageChildren) {
            this.createModelList(this.getTopResId(), this.getTopModel());
        }
        if (oldNameList == null || this.fileNameList == null) {
            return false;
        }
        if (oldNameList.equals(this.fileNameList)) {
            return false;
        }
        int i = 0;
        while (i < this.fileNameList.size()) {
            Object name = this.fileNameList.get(i);
            if (oldNameList.contains(name)) {
                oldNameList.remove(name);
            }
            ++i;
        }
        Iterator itr = oldNameList.iterator();
        while (itr.hasNext()) {
            this.unmanageModel(ModelManagerUtil.calculateModelId((String)itr.next()));
        }
        return true;
    }

    void dispose() {
        this.releaseModel();
    }

    SubModelManager getSubModelManager() {
        return this.subModelManager;
    }

    boolean isManagedModel(Object modelId) {
        return this.getManagedModels().get(modelId) != null;
    }

    boolean isStoredFileName(String fileName) {
        return this.fileNameList.contains(fileName);
    }

    void manageSingleModel(Object modelId, IDOMModel model) {
        if (modelId == null || model == null) {
            return;
        }
        this.getManagedModels().put(modelId, model);
        String fileName = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        if (this.fileNameList != null && !this.fileNameList.contains(fileName)) {
            this.fileNameList.add(fileName);
        }
    }

    private void releaseModel() {
        if (this.managedModels != null) {
            Enumeration enu = this.managedModels.keys();
            while (enu.hasMoreElements()) {
                Object key = enu.nextElement();
                IDOMModel model = (IDOMModel)this.managedModels.get(key);
                if (model == null) continue;
                model.releaseFromRead();
            }
            this.managedModels = null;
        }
        if (this.fileNameList != null) {
            this.fileNameList.clear();
        }
        this.topResId = null;
    }

    private Dictionary getManagedModels() {
        if (this.managedModels == null) {
            this.managedModels = new Hashtable();
        }
        return this.managedModels;
    }

    private boolean unmanageModel(Object modelId) {
        if (modelId == null) {
            return false;
        }
        IDOMModel model = (IDOMModel)this.getManagedModels().get(modelId);
        String fileName = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        if (fileName == null) {
            int i = 0;
            while (i < this.fileNameList.size()) {
                String name = (String)this.fileNameList.get(i);
                Object tempId = ModelManagerUtil.calculateModelId(name);
                if (modelId.equals(tempId)) {
                    fileName = name;
                    break;
                }
                ++i;
            }
        }
        if (this.fileNameList != null && fileName != null) {
            this.fileNameList.remove(fileName);
        }
        if (model == null) {
            return false;
        }
        model.releaseFromRead();
        this.getManagedModels().remove(modelId);
        return true;
    }

    private void createModelList(Object modelId, IDOMModel model) {
        if (model == null) {
            return;
        }
        ModelCollectorsContext context = new ModelCollectorsContext(this, null);
        List fileList = context.collectModels(modelId, model);
        for (Object fileName : fileList) {
            if (this.fileNameList.contains(fileName)) continue;
            this.fileNameList.add(fileName);
        }
    }
}

