/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.style.extended;

import com.ibm.etools.webedit.editparts.design.TaglibDirectiveHandler;
import com.ibm.etools.webedit.render.internal.style.HTMLStyleOwner;
import com.ibm.etools.webedit.render.internal.style.IconFactory;
import com.ibm.etools.webedit.render.internal.style.extended.HTMLStyleIconText;
import com.ibm.etools.webedit.viewer.utils.CustomTagUtil;
import com.ibm.etools.xve.renderer.style.ImageObject;
import com.ibm.etools.xve.renderer.style.Length;
import com.ibm.etools.xve.renderer.style.RenderOption;
import com.ibm.etools.xve.renderer.style.StyleOwner;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class HTMLStyleCustomTag
extends HTMLStyleIconText {
    private static final Length border_width = new Length(2.0f, 0);
    private static final Length icon_size = new Length(16.0f, 0);
    private static final int CONTENT_JSP = 0;
    private static final int CONTENT_TAGDEPENDENT = 1;
    private static final int CONTENT_EMPTY = 2;
    private int content_type = 0;
    private String action_name = null;
    private boolean hasVisualizer;

    protected int doUpdateAttr(boolean force) {
        StyleOwner owner;
        ModelQuery query;
        int result = 0;
        if (force) {
            this.resetState();
            result |= 1;
        }
        Element element = this.getDomElement();
        result |= this.doUpdateBidi(element);
        int oldValue = this.content_type;
        String oldString = this.action_name;
        this.content_type = 0;
        this.action_name = null;
        if (element != null && (query = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument())) != null) {
            CMElementDeclaration decl = query.getCMElementDeclaration(element);
            if (decl != null) {
                if (decl instanceof CMNodeWrapper) {
                    TLDElementDeclaration d;
                    CMNode n = ((CMNodeWrapper)decl).getOriginNode();
                    try {
                        d = (TLDElementDeclaration)n;
                    }
                    catch (ClassCastException classCastException) {
                        d = null;
                    }
                    if (d != null) {
                        this.action_name = d.getElementName();
                        String body_content = d.getBodycontent();
                        if (body_content != null && (body_content = body_content.trim()) != null) {
                            if (body_content.equalsIgnoreCase("JSP")) {
                                this.content_type = 0;
                            } else if (body_content.equalsIgnoreCase("TAGDEPENDENT")) {
                                this.content_type = 1;
                            } else if (body_content.equalsIgnoreCase("EMPTY")) {
                                this.content_type = 2;
                            }
                        }
                    }
                }
            } else {
                Vector uris;
                TaglibDirectiveHandler handler;
                Document doc;
                String prefix = ((IDOMNode)element).getPrefix();
                if (prefix != null && (doc = element.getOwnerDocument()) != null && (handler = (TaglibDirectiveHandler)((INodeNotifier)doc).getAdapterFor(TaglibDirectiveHandler.class)) != null && (uris = handler.getURIsByPrefix(prefix)) != null && uris.size() > 0) {
                    this.action_name = element.getLocalName();
                }
            }
        }
        if (oldValue != this.content_type) {
            result |= 1;
        }
        if (oldString == null) {
            if (this.action_name != null) {
                result |= 1;
            }
        } else if (!oldString.equals(this.action_name)) {
            result |= 1;
        }
        if ((owner = this.getStyleOwner()) instanceof HTMLStyleOwner && ((HTMLStyleOwner)owner).hasVisualizer()) {
            if (!this.hasVisualizer) {
                this.hasVisualizer = true;
                result |= 1;
            }
        } else if (this.hasVisualizer) {
            this.hasVisualizer = false;
            result |= 1;
        }
        return result;
    }

    protected int getBorderStyleByDefault(int prop) {
        RenderOption option = this.getRenderOption();
        if (option != null && (!option.isExtraBorder(10) || this.getMaskType() != 2) && option.isExtraBorder(7)) {
            return this.content_type == 0 ? 8 : 12345678;
        }
        return 12345678;
    }

    protected Color getColorByDefault(int prop) {
        switch (prop) {
            default: 
        }
        return null;
    }

    protected int getDisplayTypeByDefault() {
        if (this.hasVisualizer) {
            return 31;
        }
        return this.content_type == 0 ? 19 : 18;
    }

    protected Image getImageByDefault(int prop) {
        if (this.hasVisualizer) {
            return null;
        }
        Image image = null;
        switch (prop) {
            case 0: {
                RenderOption option = this.getRenderOption();
                if (option == null || !option.showIcon(6)) break;
                if (this.customIcon == null) {
                    InputStream is;
                    Element element = this.getDomElement();
                    if (element != null && (is = CustomTagUtil.getSmallIconImage(element)) != null) {
                        this.customIcon = IconFactory.getInstance().getObject(is);
                    }
                    if (this.customIcon != null) {
                        this.customIcon.addRef();
                    } else if (this.defaultIcon == null) {
                        this.defaultIcon = IconFactory.getInstance().getObject("jsptaglib_tag.gif");
                        if (this.defaultIcon == null) {
                            return null;
                        }
                    }
                }
                ImageObject icon = this.customIcon != null ? this.customIcon : this.defaultIcon;
                image = icon.getStaticImage();
                break;
            }
        }
        return image;
    }

    protected Length getLengthByDefault(int prop) {
        if (this.hasVisualizer) {
            return null;
        }
        RenderOption option = this.getRenderOption();
        if (!(option == null || option.isExtraBorder(10) && this.getMaskType() == 2)) {
            Length len = null;
            switch (prop) {
                case 31: 
                case 32: {
                    len = icon_size;
                    break;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    if (this.content_type != 0) break;
                    len = border_width;
                }
            }
            return len;
        }
        return null;
    }

    protected String getTextFromElement(int prop) {
        String s = null;
        switch (prop) {
            case 0: {
                RenderOption option = this.getRenderOption();
                if (option == null || !option.showText(2)) break;
                s = this.action_name;
                break;
            }
            case 200: {
                RenderOption option = this.getRenderOption();
                if (option == null || !option.showTooltip(1) || this.hasVisualizer) break;
                s = this.content_type == 1 ? this.getWholeContent() : this.getBeginTag();
            }
        }
        return s;
    }

    private String getWholeContent() {
        String s = null;
        StyleOwner owner = this.getStyleOwner();
        if (owner != null) {
            IDOMNode elem;
            try {
                elem = (IDOMNode)owner.getElement();
            }
            catch (ClassCastException classCastException) {
                elem = null;
            }
            if (elem != null) {
                s = elem.getSource();
            }
        }
        return s;
    }

    private String getBeginTag() {
        String s = null;
        StyleOwner owner = this.getStyleOwner();
        if (owner != null) {
            IStructuredDocumentRegion fn;
            IDOMNode elem;
            try {
                elem = (IDOMNode)owner.getElement();
            }
            catch (ClassCastException classCastException) {
                elem = null;
            }
            if (elem != null && (fn = elem.getFirstStructuredDocumentRegion()) != null) {
                s = fn.getText();
            }
        }
        return s;
    }

    protected void resetState() {
    }
}

